/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.config;

import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.EnumMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public abstract class Player<P, M> {
    private static boolean enableRendering = true;
    private static boolean enableNames = true;
    private CompletableFuture<ModelDefinition> definition;
    private EnumMap<AnimationEngine.AnimationMode, AnimationHandler> animHandler = new EnumMap(AnimationEngine.AnimationMode.class);
    private PlayerTextureLoader textures;
    public VanillaPose prevPose;
    public IPose currentPose;
    public boolean forcedSkin;

    public PlayerTextureLoader getTextures() {
        if (this.textures == null) {
            this.textures = this.initTextures();
            this.textures.load();
        }
        return this.textures;
    }

    public abstract SkinType getSkinType();

    protected abstract PlayerTextureLoader initTextures();

    public abstract String getName();

    public abstract UUID getUUID();

    public abstract VanillaPose getPose();

    public abstract int getEncodedGestureId();

    public abstract M getModel();

    public abstract void updateFromPlayer(P var1);

    public abstract Object getGameProfile();

    public void setModelDefinition(CompletableFuture<ModelDefinition> definition) {
        this.definition = definition;
    }

    public ModelDefinition getModelDefinition0() {
        try {
            return enableRendering && this.definition != null ? (ModelDefinition)this.definition.getNow(null) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ModelDefinition getModelDefinition() {
        ModelDefinition def = this.getModelDefinition0();
        if (def != null) {
            if (def.getResolveState() == ModelDefinition.ModelLoadingState.NEW) {
                def.startResolve();
            } else if (def.getResolveState() == ModelDefinition.ModelLoadingState.LOADED && def.doRender()) {
                return def;
            }
        }
        return null;
    }

    public CompletableFuture<ModelDefinition> getDefinitionFuture() {
        return this.definition;
    }

    public AnimationHandler getAnimationHandler(AnimationEngine.AnimationMode mode) {
        return this.animHandler.computeIfAbsent(mode, k -> new AnimationHandler(this::getModelDefinition));
    }

    public static boolean isEnableRendering() {
        return enableRendering;
    }

    public static void setEnableRendering(boolean enableRendering) {
        Player.enableRendering = enableRendering;
    }

    public static boolean isEnableNames() {
        return enableNames;
    }

    public static void setEnableNames(boolean enableNames) {
        Player.enableNames = enableNames;
    }

    public void cleanup() {
        ModelDefinition def = this.getModelDefinition0();
        if (def != null) {
            def.cleanup();
        }
    }

    public boolean isClientPlayer() {
        return this.getUUID().equals(MinecraftClientAccess.get().getCurrentClientPlayer().getUUID());
    }
}

