/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpm.shared.animation.Animation;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.definition.ModelDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class AnimationHandler {
    private final Supplier<ModelDefinition> player;
    private List<PlayingAnim> currentAnimations = new ArrayList<PlayingAnim>();
    private List<Animation> nextAnims = new ArrayList<Animation>();
    private AnimationRegistry.Gesture currentGesture;

    public AnimationHandler(Supplier<ModelDefinition> player) {
        this.player = player;
    }

    public void animate(long currentTime) {
        boolean needsSort = false;
        this.currentAnimations.removeIf(a -> !this.nextAnims.contains(((PlayingAnim)a).currentAnimation));
        for (Animation animation : this.nextAnims) {
            boolean found = false;
            for (int i = 0; i < this.currentAnimations.size(); ++i) {
                if (this.currentAnimations.get(i).currentAnimation != animation) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.currentAnimations.add(new PlayingAnim(animation, currentTime, this.currentGesture != null ? (this.currentGesture.animation.contains(animation) ? this.currentGesture.isLoop : true) : true));
            needsSort = true;
        }
        if (needsSort) {
            this.currentAnimations.sort((a, b) -> Integer.compare(((PlayingAnim)a).currentAnimation.priority, ((PlayingAnim)b).currentAnimation.priority));
        }
        this.player.get().resetAnimationPos();
        for (PlayingAnim a2 : this.currentAnimations) {
            if (a2.finished) continue;
            long currentStep = currentTime - a2.currentStart;
            a2.currentAnimation.animate(currentStep, this.player.get());
            if (a2.loop || currentStep <= (long)((PlayingAnim)a2).currentAnimation.duration) continue;
            a2.finished = true;
        }
        this.nextAnims.clear();
    }

    public void addAnimations(List<Animation> next) {
        this.nextAnims.addAll(next);
    }

    public void setGesture(AnimationRegistry.Gesture next) {
        this.currentGesture = next;
        if (next != null) {
            this.nextAnims.addAll(next.animation);
        }
    }

    public void clear() {
        this.currentGesture = null;
        this.nextAnims.clear();
        this.currentAnimations.clear();
    }

    private static class PlayingAnim {
        private Animation currentAnimation;
        private long currentStart;
        private boolean loop;
        private boolean finished;

        public PlayingAnim(Animation currentAnimation, long currentStart, boolean loop) {
            this.currentAnimation = currentAnimation;
            this.currentStart = currentStart;
            this.loop = loop;
            this.finished = false;
        }
    }
}

