/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.Animation;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.parts.ModelPartScale;
import java.util.List;

public class AnimationEngine {
    private long tickCounter;
    private float partial;
    private ModelPartScale modelScale;

    public void tick() {
        ++this.tickCounter;
        if (MinecraftClientAccess.get().isInGame()) {
            Player<?, ?> player = MinecraftClientAccess.get().getCurrentClientPlayer();
            ModelDefinition def = player.getModelDefinition();
            if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
                if (def != null && def.doRender()) {
                    if (def.getScale() != this.modelScale) {
                        this.modelScale = def.getScale();
                        if (this.modelScale == null) {
                            MinecraftClientAccess.get().setModelScale(0.0f);
                        } else {
                            MinecraftClientAccess.get().setModelScale(this.modelScale.getScale());
                        }
                    }
                } else if (this.modelScale != null) {
                    MinecraftClientAccess.get().setModelScale(0.0f);
                    this.modelScale = null;
                }
            }
        } else {
            this.modelScale = null;
        }
    }

    public void update(float partial) {
        this.partial = partial;
    }

    public long getTime() {
        return (long)(((float)this.tickCounter + this.partial) * 50.0f);
    }

    public void handleAnimation(Player<?, ?> player, AnimationMode mode) {
        AnimationHandler h = player.getAnimationHandler(mode);
        try {
            ModelDefinition def = player.getModelDefinition();
            switch (mode) {
                case HAND: {
                    def.resetAnimationPos();
                    return;
                }
                case PLAYER: {
                    VanillaPose pose = player.getPose();
                    int gesture = player.getEncodedGestureId();
                    AnimationRegistry reg = def.getAnimations();
                    if (pose != player.prevPose || gesture == reg.getPoseResetId()) {
                        player.currentPose = pose;
                    }
                    player.currentPose = def.getAnimations().getPose(gesture, player.currentPose);
                    player.prevPose = pose;
                    List<Animation> anim = def.getAnimations().getPoseAnimations(player.currentPose);
                    List<Animation> global = def.getAnimations().getPoseAnimations(VanillaPose.GLOBAL);
                    h.addAnimations(anim);
                    h.addAnimations(global);
                    h.setGesture(def.getAnimations().getGesture(gesture));
                    break;
                }
                case SKULL: {
                    List<Animation> anim = def.getAnimations().getPoseAnimations(VanillaPose.SKULL_RENDER);
                    List<Animation> global = def.getAnimations().getPoseAnimations(VanillaPose.GLOBAL);
                    h.addAnimations(anim);
                    h.addAnimations(global);
                    break;
                }
            }
            h.animate(this.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            player.getModelDefinition().resetAnimationPos();
            h.clear();
        }
    }

    public void handleGuiAnimation(AnimationHandler h, ModelDefinition def) {
        try {
            List<Animation> anim = def.getAnimations().getPoseAnimations(VanillaPose.STANDING);
            List<Animation> global = def.getAnimations().getPoseAnimations(VanillaPose.GLOBAL);
            h.addAnimations(anim);
            h.addAnimations(global);
            h.animate(this.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            def.resetAnimationPos();
            h.clear();
        }
    }

    public void onKeybind(int id) {
        ConfigEntry ce;
        String c;
        ModelDefinition def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition();
        if (def != null && (c = (ce = ModConfig.getCommonConfig().getEntry("keybinds")).getString("qa_" + id, null)) != null) {
            AnimationRegistry.Gesture g;
            if (c.startsWith("p")) {
                CustomPose pose = def.getAnimations().getCustomPoses().get(c.substring(1));
                if (pose != null) {
                    this.setCustomPose(def.getAnimations(), pose);
                }
            } else if (c.startsWith("g") && (g = def.getAnimations().getGestures().get(c.substring(1))) != null) {
                this.playGesture(def.getAnimations(), g);
            }
        }
    }

    public void setCustomPose(AnimationRegistry reg, CustomPose pose) {
        int enc;
        MinecraftClientAccess.ServerStatus status = MinecraftClientAccess.get().getServerSideStatus();
        if (status == MinecraftClientAccess.ServerStatus.OFFLINE || status == MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            return;
        }
        int n = enc = pose == null ? reg.getPoseResetId() : reg.getEncoded(pose);
        if (enc != -1) {
            if (enc == MinecraftClientAccess.get().getCurrentClientPlayer().getEncodedGestureId()) {
                enc = reg.getPoseResetId();
            }
            MinecraftClientAccess.get().setEncodedGesture(enc);
        }
    }

    public void playGesture(AnimationRegistry reg, AnimationRegistry.Gesture g) {
        int enc;
        MinecraftClientAccess.ServerStatus status = MinecraftClientAccess.get().getServerSideStatus();
        if (status == MinecraftClientAccess.ServerStatus.OFFLINE || status == MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            return;
        }
        int n = enc = g == null ? reg.getBlankGesture() : reg.getEncoded(g);
        if (enc != -1) {
            if (enc == MinecraftClientAccess.get().getCurrentClientPlayer().getEncodedGestureId()) {
                enc = reg.getBlankGesture();
            }
            MinecraftClientAccess.get().setEncodedGesture(enc);
        }
    }

    public int getTicks() {
        return (int)this.tickCounter;
    }

    public static enum AnimationMode {
        PLAYER,
        SKULL,
        HAND;

    }
}

