/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.client.ClientProxy;
import com.tom.cpm.client.CustomRenderTypes;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.VBuffer;
import com.tom.cpm.client.optifine.OptifineTexture;
import com.tom.cpm.client.optifine.RedirectRendererOF;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureProvider;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.ElytraModel;
import net.minecraft.client.renderer.entity.model.HumanoidHeadModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;

public class PlayerRenderManager
extends ModelRenderManager<IRenderTypeBuffer, ModelTexture, ModelRenderer, Model> {
    public static final Function<ResourceLocation, RenderType> armor = RenderType::func_239263_a_;
    public static final Function<ResourceLocation, RenderType> entity = RenderType::func_228644_e_;

    public PlayerRenderManager() {
        this.setFactory(new ModelRenderManager.RedirectHolderFactory<IRenderTypeBuffer, ModelTexture, ModelRenderer>(){

            @Override
            public <M> ModelRenderManager.RedirectHolder<?, IRenderTypeBuffer, ModelTexture, ModelRenderer> create(M model, String arg) {
                if (model instanceof PlayerModel) {
                    return new RedirectHolderPlayer(PlayerRenderManager.this, (PlayerModel<AbstractClientPlayerEntity>)((PlayerModel)model));
                }
                if (model instanceof HumanoidHeadModel) {
                    return new RedirectHolderSkull(PlayerRenderManager.this, (HumanoidHeadModel)model);
                }
                if (model instanceof ElytraModel) {
                    return new RedirectHolderElytra(PlayerRenderManager.this, (ElytraModel<AbstractClientPlayerEntity>)((ElytraModel)model));
                }
                if (model instanceof BipedModel && "armor1".equals(arg)) {
                    return new RedirectHolderArmor1(PlayerRenderManager.this, (BipedModel<AbstractClientPlayerEntity>)((BipedModel)model));
                }
                if (model instanceof BipedModel && "armor2".equals(arg)) {
                    return new RedirectHolderArmor2(PlayerRenderManager.this, (BipedModel<AbstractClientPlayerEntity>)((BipedModel)model));
                }
                return null;
            }
        });
        this.setRedirectFactory(new ModelRenderManager.RedirectRendererFactory<Model, ModelTexture, ModelRenderer>(){

            @Override
            public ModelRenderManager.RedirectRenderer<ModelRenderer> create(Model model, ModelRenderManager.RedirectHolder<Model, ?, ModelTexture, ModelRenderer> access, Supplier<ModelRenderer> modelPart, VanillaModelPart part) {
                return ClientProxy.optifineLoaded ? new RedirectRendererOF((RDH)access, modelPart, part) : new RedirectModelRendererVanilla((RDH)access, modelPart, part);
            }
        });
        this.setVis(m -> m.field_78806_j, (m, v) -> {
            m.field_78806_j = v;
        });
        this.setModelPosGetters(m -> m.field_78800_c, m -> m.field_78797_d, m -> m.field_78798_e);
        this.setModelRotGetters(m -> m.field_78795_f, m -> m.field_78796_g, m -> m.field_78808_h);
        this.setModelSetters((m, x, y, z) -> {
            m.field_78800_c = x;
            m.field_78797_d = y;
            m.field_78798_e = z;
        }, (m, x, y, z) -> {
            m.field_78795_f = x;
            m.field_78796_g = y;
            m.field_78808_h = z;
        });
    }

    public static void multiplyStacks(MatrixStack.Entry e, MatrixStack stack) {
        stack.func_227866_c_().func_227870_a_().func_226595_a_(new Matrix4f(e.getMatrixArray()));
        stack.func_227866_c_().func_227872_b_().func_226118_b_(new Matrix3f(new Matrix4f(e.getNormalArray())));
    }

    private static class RedirectModelRendererVanilla
    extends RedirectModelRendererBase {
        private MatrixStack matrixStackIn;
        private IVertexBuilder bufferIn;
        private int packedLightIn;
        private int packedOverlayIn;

        public RedirectModelRendererVanilla(RDH holder, Supplier<ModelRenderer> parent, VanillaModelPart part) {
            super(holder, parent, part);
        }

        public void func_228309_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            if (!this.holder.renderTypes.isInitialized()) {
                this.holder.copyModel(this, this.parent);
                this.parent.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                this.holder.logWarning();
                return;
            }
            this.matrixStackIn = matrixStackIn;
            this.bufferIn = bufferIn;
            this.packedLightIn = packedLightIn;
            this.packedOverlayIn = packedOverlayIn;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
            this.buffers = new VBuffers(rt -> new VBuffer(((IRenderTypeBuffer)this.holder.addDt).getBuffer((RenderType)rt.getNativeType()), packedLightIn, packedOverlayIn, matrixStackIn), new VBuffer(bufferIn, packedLightIn, packedOverlayIn, matrixStackIn));
            this.render();
            ((IRenderTypeBuffer)this.holder.addDt).getBuffer((RenderType)this.holder.renderTypes.get(RenderMode.DEFAULT).getNativeType());
            this.matrixStackIn = null;
            this.bufferIn = null;
        }

        @Override
        public void renderParent() {
            this.parent.func_228309_a_(this.matrixStackIn, this.bufferIn, this.packedLightIn, this.packedOverlayIn, this.red, this.green, this.blue, this.alpha);
        }
    }

    public static abstract class RedirectModelRendererBase
    extends ModelRenderer
    implements ModelRenderManager.RedirectRenderer<ModelRenderer> {
        protected final RDH holder;
        protected final VanillaModelPart part;
        protected final Supplier<ModelRenderer> parentProvider;
        protected ModelRenderer parent;
        protected VBuffers buffers;
        protected float red;
        protected float green;
        protected float blue;
        protected float alpha;

        public RedirectModelRendererBase(RDH holder, Supplier<ModelRenderer> parent, VanillaModelPart part) {
            super(0, 0, 0, 0);
            this.part = part;
            this.holder = holder;
            this.parentProvider = parent;
        }

        @Override
        public VBuffers getVBuffers() {
            return this.buffers;
        }

        @Override
        public ModelRenderer swapIn() {
            if (this.parent != null) {
                return this;
            }
            this.parent = this.parentProvider.get();
            this.holder.copyModel(this.parent, this);
            return this;
        }

        @Override
        public ModelRenderer swapOut() {
            if (this.parent == null) {
                return this.parentProvider.get();
            }
            ModelRenderer p = this.parent;
            this.parent = null;
            return p;
        }

        @Override
        public ModelRenderManager.RedirectHolder<?, ?, ?, ModelRenderer> getHolder() {
            return this.holder;
        }

        @Override
        public ModelRenderer getParent() {
            return this.parent;
        }

        @Override
        public VanillaModelPart getPart() {
            return this.part;
        }

        @Override
        public Vec4f getColor() {
            return new Vec4f(this.red, this.green, this.blue, this.alpha);
        }

        public void func_228307_a_(MatrixStack stack) {
            MatrixStack.Entry e = this.getPartTransform();
            if (e != null) {
                PlayerRenderManager.multiplyStacks(e, stack);
            } else {
                super.func_228307_a_(stack);
            }
        }
    }

    private static class RedirectHolderArmor2
    extends RDH {
        public RedirectHolderArmor2(PlayerRenderManager mngr, BipedModel<AbstractClientPlayerEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78115_e, v -> {
                model.field_78115_e = v;
            }, RootModelType.ARMOR_LEGGINGS_BODY));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178721_j, v -> {
                model.field_178721_j = v;
            }, RootModelType.ARMOR_RIGHT_LEG));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178722_k, v -> {
                model.field_178722_k = v;
            }, RootModelType.ARMOR_LEFT_LEG));
        }
    }

    private static class RedirectHolderArmor1
    extends RDH {
        public RedirectHolderArmor1(PlayerRenderManager mngr, BipedModel<AbstractClientPlayerEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78116_c, v -> {
                model.field_78116_c = v;
            }, RootModelType.ARMOR_HELMET));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78115_e, v -> {
                model.field_78115_e = v;
            }, RootModelType.ARMOR_BODY));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178723_h, v -> {
                model.field_178723_h = v;
            }, RootModelType.ARMOR_RIGHT_ARM));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178724_i, v -> {
                model.field_178724_i = v;
            }, RootModelType.ARMOR_LEFT_ARM));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178721_j, v -> {
                model.field_178721_j = v;
            }, RootModelType.ARMOR_RIGHT_FOOT));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178722_k, v -> {
                model.field_178722_k = v;
            }, RootModelType.ARMOR_LEFT_FOOT));
        }
    }

    private static class RedirectHolderElytra
    extends RDH {
        public RedirectHolderElytra(PlayerRenderManager mngr, ElytraModel<AbstractClientPlayerEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_187060_a, v -> {
                model.field_187060_a = v;
            }, RootModelType.ELYTRA_RIGHT));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_187061_b, v -> {
                model.field_187061_b = v;
            }, RootModelType.ELYTRA_LEFT));
        }
    }

    private static class RedirectHolderSkull
    extends RDH {
        private ModelRenderManager.RedirectRenderer<ModelRenderer> hat;

        public RedirectHolderSkull(PlayerRenderManager mngr, HumanoidHeadModel model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_217105_a, v -> {
                model.field_217105_a = v;
            }, PlayerModelParts.HEAD));
            this.hat = this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178717_b, v -> {
                model.field_178717_b = v;
            }, null));
        }
    }

    private static class RedirectHolderPlayer
    extends RDH {
        private ModelRenderManager.RedirectRenderer<ModelRenderer> head = this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78116_c, v -> {
            model.field_78116_c = v;
        }, PlayerModelParts.HEAD), p -> !((PlayerProfile)p).hasPlayerHead);
        private ModelRenderManager.RedirectRenderer<ModelRenderer> leftArm;
        private ModelRenderManager.RedirectRenderer<ModelRenderer> rightArm;
        private ModelRenderManager.RedirectRenderer<ModelRenderer> leftArmwear;
        private ModelRenderManager.RedirectRenderer<ModelRenderer> rightArmwear;

        public RedirectHolderPlayer(PlayerRenderManager mngr, PlayerModel<AbstractClientPlayerEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_78115_e, v -> {
                model.field_78115_e = v;
            }, PlayerModelParts.BODY));
            this.rightArm = this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178723_h, v -> {
                model.field_178723_h = v;
            }, PlayerModelParts.RIGHT_ARM));
            this.leftArm = this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178724_i, v -> {
                model.field_178724_i = v;
            }, PlayerModelParts.LEFT_ARM));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178721_j, v -> {
                model.field_178721_j = v;
            }, PlayerModelParts.RIGHT_LEG));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178722_k, v -> {
                model.field_178722_k = v;
            }, PlayerModelParts.LEFT_LEG));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178720_f, v -> {
                model.field_178720_f = v;
            }, null)).setCopyFrom(this.head);
            this.leftArmwear = this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178734_a, v -> {
                model.field_178734_a = v;
            }, null));
            this.rightArmwear = this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178732_b, v -> {
                model.field_178732_b = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178733_c, v -> {
                model.field_178733_c = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178731_d, v -> {
                model.field_178731_d = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178730_v, v -> {
                model.field_178730_v = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelRenderer>(() -> model.field_178729_w, v -> {
                model.field_178729_w = v;
            }, RootModelType.CAPE));
        }

        @Override
        public boolean skipTransform(ModelRenderManager.RedirectRenderer<ModelRenderer> part) {
            PlayerModel model = (PlayerModel)this.model;
            boolean skipTransform = false;
            if (this.leftArm == part && model.field_187075_l.ordinal() > 2) {
                skipTransform = true;
            }
            if (this.rightArm == part && model.field_187076_m.ordinal() > 2) {
                skipTransform = true;
            }
            return skipTransform;
        }
    }

    public static abstract class RDH
    extends ModelRenderManager.RedirectHolder<Model, IRenderTypeBuffer, ModelTexture, ModelRenderer> {
        public RDH(ModelRenderManager<IRenderTypeBuffer, ModelTexture, ModelRenderer, Model> mngr, Model model) {
            super(mngr, model);
        }

        @Override
        public void setupRenderSystem(ModelTexture cbi, TextureSheetType tex) {
            this.renderTypes.put(RenderMode.NORMAL, new VBuffers.NativeRenderType(0));
            this.renderTypes.put(RenderMode.DEFAULT, new VBuffers.NativeRenderType(cbi.getRenderType(), 0));
            this.renderTypes.put(RenderMode.GLOW, new VBuffers.NativeRenderType(RenderType.func_228652_i_((ResourceLocation)cbi.getTexture()), 1));
            this.renderTypes.put(RenderMode.OUTLINE, new VBuffers.NativeRenderType(CustomRenderTypes.getLinesNoDepth(), 2));
            this.renderTypes.put(RenderMode.COLOR, new VBuffers.NativeRenderType(CustomRenderTypes.getEntityColorTranslucentCull(), 0));
        }

        @Override
        protected void bindTexture(ModelTexture cbi, TextureProvider skin) {
            skin.bind();
            OptifineTexture.applyOptifineTexture(cbi.getTexture(), skin);
            cbi.setTexture(MinecraftObject.DynTexture.getBoundLoc());
        }

        @Override
        public void swapOut0() {
        }

        @Override
        public void swapIn0() {
        }
    }
}

