/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.util.ILogger;
import com.tom.cpm.CommonProxy;
import com.tom.cpm.Log4JLogger;
import com.tom.cpm.MinecraftServerObject;
import com.tom.cpm.client.ClientProxy;
import com.tom.cpm.common.ServerHandler;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.PlatformFeature;
import com.tom.cpm.shared.config.ModConfig;
import java.io.File;
import java.util.EnumSet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cpm")
public class CustomPlayerModels
implements MinecraftCommonAccess {
    public static final Logger LOG = LogManager.getLogger((String)"CPM");
    public static final ILogger log = new Log4JLogger(LOG);
    public static CommonProxy proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private ConfigEntry.ModConfigFile cfg;
    private static final EnumSet<PlatformFeature> features = EnumSet.of(PlatformFeature.EDITOR_HELD_ITEM, PlatformFeature.EDITOR_SUPPORTED);

    public CustomPlayerModels() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ServerHandler());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        proxy.init();
    }

    public void setup(FMLCommonSetupEvent evt) {
        this.cfg = new ConfigEntry.ModConfigFile(new File(FMLPaths.CONFIGDIR.get().toFile(), "cpm.json"));
        MinecraftObjectHolder.setCommonObject(this);
        LOG.info("Customizable Player Models Initialized");
    }

    @Override
    public ConfigEntry.ModConfigFile getConfig() {
        return this.cfg;
    }

    @SubscribeEvent
    public void onStart(FMLServerStartingEvent e) {
        MinecraftObjectHolder.setServerObject(new MinecraftServerObject(e.getServer()));
    }

    @SubscribeEvent
    public void onStop(FMLServerStoppingEvent e) {
        ModConfig.getWorldConfig().save();
        MinecraftObjectHolder.setServerObject(null);
    }

    @Override
    public ILogger getLogger() {
        return log;
    }

    @Override
    public EnumSet<PlatformFeature> getSupportedFeatures() {
        return features;
    }
}

