/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.ReplayBuffer;
import com.tom.cpl.render.TransformedBuffer;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.render.WrappedBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class VBuffers {
    private Function<NativeRenderType, VertexBuffer> bufferFactory;
    private Map<NativeRenderType, VertexBuffer> buffers = new HashMap<NativeRenderType, VertexBuffer>();
    private VertexBuffer normalBuffer;

    public VBuffers(Function<NativeRenderType, VertexBuffer> bufferFactory, VertexBuffer normalBuffer) {
        this.bufferFactory = bufferFactory;
        this.normalBuffer = normalBuffer;
    }

    public VBuffers(Function<NativeRenderType, VertexBuffer> bufferFactory) {
        this.bufferFactory = bufferFactory;
    }

    public VertexBuffer getBuffer(NativeRenderType type) {
        if (type.nativeType == null && this.normalBuffer != null) {
            this.buffers.put(type, this.normalBuffer);
            return new VBuf(this.normalBuffer, this, type);
        }
        return new VBuf(this.buffers.computeIfAbsent(type, this.bufferFactory), this, type);
    }

    public <E extends Enum<E>> VertexBuffer getBuffer(RenderTypes<E> types, E type) {
        return this.getBuffer(types.get(type));
    }

    public void finish(NativeRenderType type) {
        VertexBuffer buf = this.buffers.remove(type);
        if (buf != null) {
            buf.finish();
        }
    }

    public void finishAll() {
        ArrayList<NativeRenderType> rts = new ArrayList<NativeRenderType>(this.buffers.keySet());
        rts.sort((a, b) -> Integer.compare(((NativeRenderType)a).layer, ((NativeRenderType)b).layer));
        rts.forEach(rt -> this.buffers.get(rt).finish());
        this.buffers.clear();
    }

    public VBuffers replay() {
        return new VBuffers(rt -> new ReplayBuffer(() -> this.getBuffer((NativeRenderType)rt)), this.normalBuffer);
    }

    public VBuffers transform(MatrixStack stack) {
        return this.wrapped(b -> new TransformedBuffer((VertexBuffer)b, stack));
    }

    public VBuffers wrapped(UnaryOperator<VertexBuffer> func) {
        return new VBuffers(rt -> (VertexBuffer)func.apply(this.getBuffer((NativeRenderType)rt)), this.normalBuffer != null ? (VertexBuffer)func.apply(this.normalBuffer) : null);
    }

    public VBuffers finish(Consumer<VertexBuffer> finisher) {
        return this.wrapped(b -> new FinishBuffer((VertexBuffer)b, finisher));
    }

    public VBuffers normal(VertexBuffer normal) {
        return new VBuffers(this::getBuffer, normal);
    }

    private static class VBuf
    extends WrappedBuffer {
        private final VBuffers bufs;
        private final NativeRenderType rt;

        public VBuf(VertexBuffer buffer, VBuffers bufs, NativeRenderType rt) {
            super(buffer);
            this.bufs = bufs;
            this.rt = rt;
        }

        @Override
        public void finish() {
            this.bufs.finish(this.rt);
        }
    }

    private static class FinishBuffer
    extends WrappedBuffer {
        private final Consumer<VertexBuffer> finisher;

        public FinishBuffer(VertexBuffer buffer, Consumer<VertexBuffer> finisher) {
            super(buffer);
            this.finisher = finisher;
        }

        @Override
        public void finish() {
            this.finisher.accept(this.buffer);
        }
    }

    public static class NativeRenderType {
        private final Object nativeType;
        private int layer;

        public NativeRenderType(Object nativeType, int layer) {
            this.nativeType = nativeType;
            this.layer = layer;
        }

        public NativeRenderType(int layer) {
            this.nativeType = null;
            this.layer = layer;
        }

        public <RT> RT getNativeType() {
            return (RT)this.nativeType;
        }
    }
}

