/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.math;

import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Quaternion;
import com.tom.cpm.shared.editor.project.JsonMap;
import java.util.HashMap;
import java.util.Map;

public class Vec3f {
    public static final Vec3f NEGATIVE_X = new Vec3f(-1.0f, 0.0f, 0.0f);
    public static final Vec3f POSITIVE_X = new Vec3f(1.0f, 0.0f, 0.0f);
    public static final Vec3f NEGATIVE_Y = new Vec3f(0.0f, -1.0f, 0.0f);
    public static final Vec3f POSITIVE_Y = new Vec3f(0.0f, 1.0f, 0.0f);
    public static final Vec3f NEGATIVE_Z = new Vec3f(0.0f, 0.0f, -1.0f);
    public static final Vec3f POSITIVE_Z = new Vec3f(0.0f, 0.0f, 1.0f);
    public static final int MAX_POS = 48;
    public float x;
    public float y;
    public float z;

    public Vec3f() {
    }

    public Vec3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3f(Vec3f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vec3f(JsonMap m, Vec3f def) {
        this(def);
        if (m == null) {
            return;
        }
        this.x = m.getFloat("x");
        this.y = m.getFloat("y");
        this.z = m.getFloat("z");
    }

    public Vec3f(Map<String, Object> m, Vec3f def) {
        this(def);
        if (m == null) {
            return;
        }
        this.x = ((Number)m.get("x")).floatValue();
        this.y = ((Number)m.get("y")).floatValue();
        this.z = ((Number)m.get("z")).floatValue();
    }

    public Vec3f mul(float v) {
        return new Vec3f(this.x * v, this.y * v, this.z * v);
    }

    public Vec3f add(Vec3f v) {
        return new Vec3f(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vec3f sub(Vec3f v) {
        return new Vec3f(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public float getYaw() {
        float norm = (float)(1.0 / Math.sqrt(this.x * this.x + this.z * this.z));
        float x = this.x * norm;
        float y = this.z * norm;
        return (float)Math.acos(x) * Math.signum(y);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", Float.valueOf(this.x));
        map.put("y", Float.valueOf(this.y));
        map.put("z", Float.valueOf(this.z));
        return map;
    }

    public String toString() {
        return String.format("Vec3[%.3f, %.3f, %.3f]", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec3f other = (Vec3f)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }

    public void round(int i) {
        this.x = (float)Math.round(this.x * (float)i) / (float)i;
        this.y = (float)Math.round(this.y * (float)i) / (float)i;
        this.z = (float)Math.round(this.z * (float)i) / (float)i;
    }

    public Quaternion getDegreesQuaternion(float angle) {
        return new Quaternion(this, angle, true);
    }

    public Quaternion getRadialQuaternion(float angle) {
        return new Quaternion(this, angle, false);
    }

    public void mul(float x, float y, float z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
    }

    public Vec3f copy() {
        return new Vec3f(this);
    }

    public void transform(Mat3f matrixIn) {
        float f = this.x;
        float f1 = this.y;
        float f2 = this.z;
        this.x = matrixIn.m00 * f + matrixIn.m01 * f1 + matrixIn.m02 * f2;
        this.y = matrixIn.m10 * f + matrixIn.m11 * f1 + matrixIn.m12 * f2;
        this.z = matrixIn.m20 * f + matrixIn.m21 * f1 + matrixIn.m22 * f2;
    }
}

