/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.math;

public class MathHelper {
    public static final double LOG2 = Math.log(2.0);

    public static double clamp(double num, double min, double max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    public static int clamp(int num, int min, int max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    public static int ceil(float value) {
        int i = (int)value;
        return value > (float)i ? i + 1 : i;
    }

    public static int ceil(double value) {
        int i = (int)value;
        return value > (double)i ? i + 1 : i;
    }

    public static float round(float number, int scale) {
        int pow = 1;
        for (int i = 0; i < scale; ++i) {
            pow *= 10;
        }
        float tmp = number * (float)pow;
        return (float)((int)(tmp - (float)((int)tmp) >= 0.5f ? tmp + 1.0f : tmp)) / (float)pow;
    }

    public static float fastInvCubeRoot(float number) {
        int i = Float.floatToIntBits(number);
        i = 1419967116 - i / 3;
        float f = Float.intBitsToFloat(i);
        f = 0.6666667f * f + 1.0f / (3.0f * f * f * number);
        return 0.6666667f * f + 1.0f / (3.0f * f * f * number);
    }

    public static double log2(double v) {
        return Math.log(v) / LOG2;
    }

    public static float lerp(float partial, float prev, float current) {
        return prev + partial * (current - prev);
    }

    public static float cos(float f) {
        return (float)Math.cos(f);
    }

    public static float sin(float f) {
        return (float)Math.sin(f);
    }

    public static float sqrt(float f) {
        return (float)Math.sqrt(f);
    }
}

