/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Tree<T>
extends GuiElement {
    private TreeElement root;
    private Map<Integer, TreeElement> map = new HashMap<Integer, TreeElement>();
    private TreeModel<T> model;
    private Frame frame;
    private Consumer<Vec2i> sizeUpdate;

    public Tree(Frame gui, TreeModel<T> model) {
        super(gui.getGui());
        this.frame = gui;
        this.root = new TreeElement();
        this.root.display = "Root";
        this.model = model;
    }

    @Override
    public void mouseClick(MouseEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        if (this.bounds.isInBounds(evt.x, evt.y)) {
            int yp = (evt.y - this.bounds.y) / 10;
            TreeElement elem = this.map.get(yp);
            if (elem != null) {
                if (evt.btn == 0 && evt.x < 5 + elem.depth * 5 && elem != this.root && !elem.children.isEmpty()) {
                    elem.showChildren = !elem.showChildren;
                    if (this.sizeUpdate != null) {
                        this.sizeUpdate.accept(this.getSize());
                    }
                } else {
                    this.model.onClick(evt, elem.value);
                }
            } else {
                this.model.onClick(evt, null);
            }
            this.model.treeUpdated();
            evt.consume();
        }
    }

    public Vec2i getSize() {
        int[] s = new int[2];
        this.walk(s, this.root, 0);
        return new Vec2i(s[0], s[1] * 10);
    }

    private void walk(int[] s, TreeElement e, int layer) {
        s[1] = s[1] + 1;
        s[0] = Math.max(s[0], layer * 5 + this.gui.textWidth(e.display) + 5);
        if (e.showChildren) {
            for (TreeElement i : e.children) {
                this.walk(s, i, layer + 1);
            }
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.map.clear();
        this.drawTree(event, 0, new int[1], this.root);
    }

    private void drawTree(MouseEvent event, int x, int[] y, TreeElement e) {
        int txtc;
        int bg;
        int n = y[0];
        y[0] = n + 1;
        int yp = n;
        int textColor = this.gui.getColors().button_text_color;
        int n2 = bg = e.value == null ? 0 : this.model.bgColor(e.value);
        if (bg != 0) {
            this.gui.drawBox(x * 5, yp * 10, this.bounds.w, 10, bg);
        }
        int n3 = txtc = e.value == null ? 0 : this.model.textColor(e.value);
        if (txtc != 0) {
            textColor = txtc;
        }
        if (event.isHovered(new Box(this.bounds.x, yp * 10, this.bounds.w, 10))) {
            textColor = this.gui.getColors().button_text_hover;
            Tooltip tt = this.model.getTooltip(e.value);
            if (tt != null) {
                tt.set();
            }
        }
        this.map.put(yp, e);
        this.gui.drawText(x * 5 + 3, yp * 10, e.display, textColor);
        e.depth = x;
        if (e.showChildren) {
            if (e != this.root && !e.children.isEmpty()) {
                this.gui.drawTexture(x * 5 - 5, yp * 10, 8, 8, 24, 8, "editor");
            }
            for (TreeElement i : e.children) {
                this.drawTree(event, x + 1, y, i);
            }
        } else if (e != this.root && !e.children.isEmpty()) {
            this.gui.drawTexture(x * 5 - 5, yp * 10, 8, 8, 24, 0, "editor");
        }
    }

    public void updateTree() {
        ArrayList old = new ArrayList(this.root.children);
        this.root.children.clear();
        this.root.showChildren = true;
        this.model.getElements(null, e -> {
            TreeElement t = new TreeElement();
            t.display = this.model.getName(e);
            t.value = e;
            TreeElement oldTree = this.find(old, e);
            if (oldTree != null) {
                t.showChildren = oldTree.showChildren;
            }
            this.root.children.add(t);
            this.model.refresh(e);
            this.walkChildren(t, oldTree != null ? oldTree.children : null);
        });
        if (this.sizeUpdate != null) {
            this.sizeUpdate.accept(this.getSize());
        }
    }

    private TreeElement find(List<TreeElement> list, T elem) {
        for (TreeElement e : list) {
            if (e.value == elem) {
                return e;
            }
            TreeElement d = this.find(e.children, elem);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    private void walkChildren(TreeElement p, List<TreeElement> old) {
        this.model.getElements(p.value, e -> {
            TreeElement t = new TreeElement();
            t.display = this.model.getName(e);
            t.value = e;
            p.children.add(t);
            TreeElement oldTree = null;
            if (old != null) {
                oldTree = this.find(old, e);
            }
            if (oldTree != null) {
                t.showChildren = oldTree.showChildren;
            }
            this.walkChildren(t, oldTree != null ? oldTree.children : null);
        });
    }

    public void setSizeUpdate(Consumer<Vec2i> sizeUpdate) {
        this.sizeUpdate = sizeUpdate;
    }

    public static abstract class TreeModel<T> {
        protected abstract int textColor(T var1);

        protected abstract void getElements(T var1, Consumer<T> var2);

        protected abstract int bgColor(T var1);

        protected abstract void treeUpdated();

        protected abstract void onClick(MouseEvent var1, T var2);

        protected abstract String getName(T var1);

        protected abstract Tooltip getTooltip(T var1);

        protected abstract void refresh(T var1);
    }

    private class TreeElement {
        private String display;
        private T value;
        private List<TreeElement> children = new ArrayList<TreeElement>();
        private boolean showChildren;
        private int depth;

        private TreeElement() {
        }
    }
}

