/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ProcessPopup;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;

public class FileChooserPopup
extends PopupPanel {
    private File currDir;
    private File selected;
    private TextField path;
    private TextField name;
    private Runnable accept;
    private Button acceptBtn;
    private boolean saveDialog;
    private FileDisplay files;
    private ScrollPanel filesScroll;
    private BiPredicate<File, String> filter;
    private Function<String, String> extAdder;
    private Label fileDescLabel;
    private String title;
    private Frame frm;

    public FileChooserPopup(Frame frame) {
        super(frame.getGui());
        this.frm = frame;
        this.setBounds(new Box(0, 0, 310, 220));
        this.fileDescLabel = new Label(this.gui, "");
        this.fileDescLabel.setBounds(new Box(5, 185, 200, 10));
        this.addElement(this.fileDescLabel);
        this.currDir = MinecraftClientAccess.get().getGameDir().getAbsoluteFile();
        if (this.currDir.getAbsolutePath().endsWith("/.") || this.currDir.getAbsolutePath().endsWith("\\.")) {
            this.currDir = this.currDir.getParentFile();
        }
        this.path = new TextField(this.gui);
        this.name = new TextField(this.gui);
        this.path.setBounds(new Box(5, 10, 300, 20));
        this.name.setBounds(new Box(5, 195, 260, 20));
        this.addElement(this.name);
        this.addElement(this.path);
        this.acceptBtn = new Button(this.gui, "", null);
        this.acceptBtn.setBounds(new Box(265, 195, 40, 20));
        this.addElement(this.acceptBtn);
        this.path.setText(this.currDir.getAbsolutePath());
        this.files = new FileDisplay();
        this.files.setBackgroundColor(this.gui.getColors().panel_background);
        this.files.setBounds(new Box(0, 0, 300, 0));
        this.filesScroll = new ScrollPanel(this.gui);
        this.filesScroll.setDisplay(this.files);
        this.filesScroll.setBounds(new Box(5, 35, 300, 135));
        this.addElement(this.filesScroll);
        this.filter = (a, b) -> true;
        this.extAdder = Function.identity();
        if (this.gui.getNative().isSupported(FileChooserPopup.class)) {
            Button openNative = new Button(this.gui, "...", this::openNative);
            openNative.setTooltip(new Tooltip(this.frm, this.gui.i18nFormat("tooltip.cpm.filechooser.openNative", new Object[0])));
            openNative.setBounds(new Box(265, 175, 40, 20));
            this.addElement(openNative);
        }
        this.acceptBtn.setAction(() -> {
            if (this.selected != null) {
                if (this.saveDialog) {
                    File ext;
                    if (!this.filter.test(this.selected, this.selected.getName()) && this.filter.test(ext = new File(this.selected.getParentFile(), this.extAdder.apply(this.selected.getName())), ext.getName())) {
                        this.selected = ext;
                        this.name.setText(ext.getName());
                    }
                    if (this.selected.exists()) {
                        frame.openPopup(new ConfirmPopup(frame, this.gui.i18nFormat("label.cpm.overwrite", new Object[0]), this.gui.i18nFormat("label.cpm.overwrite", new Object[0]), () -> {
                            this.close();
                            this.accept.run();
                        }, () -> frame.openPopup(this)));
                    } else {
                        this.close();
                        this.accept.run();
                    }
                } else if (this.selected.exists()) {
                    if (!this.filter.test(this.selected, this.selected.getName())) {
                        return;
                    }
                    this.close();
                    this.accept.run();
                }
            } else {
                if (!this.filter.test(this.currDir, this.currDir.getName())) {
                    return;
                }
                this.selected = this.currDir;
                this.close();
                this.accept.run();
            }
        });
        this.path.setEventListener(() -> {
            File dir = new File(this.path.getText());
            if (dir.exists() && dir.isDirectory()) {
                this.currDir = dir;
                this.files.refresh();
            }
        });
        this.name.setEventListener(() -> {
            this.selected = new File(this.currDir, this.name.getText());
        });
        this.files.refresh();
    }

    public void setTitle(String text) {
        this.title = text;
    }

    public void setCurrentDirectory(File currDir) {
        this.currDir = currDir;
        this.selected = new File(currDir, this.name.getText());
        this.path.setText(currDir.getAbsolutePath());
        this.files.refresh();
    }

    public File getCurrentDirectory() {
        return this.currDir;
    }

    public File getSelected() {
        return this.selected;
    }

    public void setSelected(File sel) {
        this.selected = sel;
        if (sel != null) {
            this.currDir = sel.getParentFile();
            this.name.setText(sel.getName());
            this.path.setText(this.currDir.getAbsolutePath());
            this.files.refresh();
        }
    }

    public void setAccept(Runnable accept) {
        this.accept = accept;
    }

    public void setAccept(Consumer<File> accept) {
        this.accept = () -> accept.accept(this.selected);
    }

    public void setButtonText(String text) {
        this.acceptBtn.setText(text);
    }

    public void setSaveDialog(boolean saveDialog) {
        this.saveDialog = saveDialog;
    }

    public void setFilter(BiPredicate<File, String> filter) {
        this.filter = filter;
        this.files.refresh();
    }

    public void setFileDescText(String text) {
        this.fileDescLabel.setText(text);
    }

    public void setExtAdder(Function<String, String> extAdder) {
        this.extAdder = extAdder;
    }

    public void setFileName(String name) {
        this.name.setText(name);
        this.selected = new File(this.currDir, name);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getDesc() {
        return this.fileDescLabel.getText();
    }

    public BiPredicate<File, String> getFilter() {
        return this.filter;
    }

    public boolean isSaveDialog() {
        return this.saveDialog;
    }

    public void openNative() {
        NativeChooser nc = (NativeChooser)this.gui.getNative().getNative(FileChooserPopup.class, this);
        new ProcessPopup<File>(this.frm, this.gui.i18nFormat("label.cpm.waiting", new Object[0]), this.gui.i18nFormat("label.cpm.filechooser.waitingForNative", new Object[0]), nc::open, this::setSelected, ex -> {
            if (ex == null) {
                return;
            }
            Log.error("Error while opening native file chooser", ex);
            this.frm.openPopup(new MessagePopup(this.frm, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.filechooser.nativeError", ex.getMessage())));
        }).start();
    }

    public static interface NativeChooser {
        public File open();
    }

    public static class FileFilter
    implements BiPredicate<File, String> {
        private boolean folder;
        private String ext;

        public FileFilter(String ext) {
            this.ext = ext;
        }

        public FileFilter(boolean allowFolder) {
            this.folder = allowFolder;
        }

        @Override
        public boolean test(File f, String n) {
            if (this.ext != null && !n.endsWith("." + this.ext)) {
                return false;
            }
            return this.folder == f.isDirectory();
        }

        public String getExt() {
            return this.ext;
        }

        public boolean isFolder() {
            return this.folder;
        }
    }

    private class FileDisplay
    extends Panel {
        private String[] files;

        public FileDisplay() {
            super(FileChooserPopup.this.getGui());
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            this.gui.pushMatrix();
            this.gui.setPosOffset(this.bounds);
            event = event.offset(this.bounds);
            int y = 0;
            for (int i = 0; i < this.files.length; ++i) {
                String string = this.files[i];
                int yp = y++;
                int textColor = -1;
                if (event.isHovered(new Box(0, yp * 10, this.bounds.w, 10))) {
                    textColor = -256;
                }
                if (FileChooserPopup.this.selected != null && FileChooserPopup.this.selected.getName().equals(string) && FileChooserPopup.this.selected.getParentFile().equals(FileChooserPopup.this.currDir)) {
                    this.gui.drawBox(0, yp * 10, this.bounds.w, 10, -10066177);
                }
                this.gui.drawText(2, yp * 10 + 1, string, textColor);
            }
            this.gui.popMatrix();
        }

        @Override
        public void mouseClick(MouseEvent event) {
            if (event.isInBounds(this.bounds) && !event.isConsumed()) {
                int yp = (event.y - this.bounds.y) / 10;
                if (yp >= 0 && yp < this.files.length) {
                    String string = this.files[yp];
                    if (FileChooserPopup.this.selected != null && FileChooserPopup.this.selected.getName().equals(string) && FileChooserPopup.this.selected.getParentFile().equals(FileChooserPopup.this.currDir) && FileChooserPopup.this.selected.isDirectory()) {
                        try {
                            FileChooserPopup.this.currDir = FileChooserPopup.this.selected.getCanonicalFile();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        FileChooserPopup.this.selected = null;
                        this.refresh();
                        event.consume();
                        return;
                    }
                    FileChooserPopup.this.selected = new File(FileChooserPopup.this.currDir, string);
                    if (FileChooserPopup.this.filter.test(FileChooserPopup.this.selected, string)) {
                        FileChooserPopup.this.name.setText(FileChooserPopup.this.selected.getName());
                    }
                }
                event.consume();
            }
        }

        private void refresh() {
            String[] fs = FileChooserPopup.this.currDir.list((a, name) -> {
                File file = new File(FileChooserPopup.this.currDir, name);
                if (file.isHidden()) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                return FileChooserPopup.this.filter.test(file, name);
            });
            if (FileChooserPopup.this.currDir.toPath().getNameCount() == 0) {
                this.files = fs;
            } else {
                this.files = new String[fs.length + 1];
                this.files[0] = "..";
                System.arraycopy(fs, 0, this.files, 1, fs.length);
            }
            FileChooserPopup.this.path.setText(FileChooserPopup.this.currDir.getAbsolutePath());
            this.setBounds(new Box(this.bounds.x, this.bounds.y, this.bounds.w, this.files.length * 10 + 2));
            FileChooserPopup.this.filesScroll.setScrollY(0);
        }
    }
}

