/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Tooltip;

public class Button
extends GuiElement {
    protected String name;
    protected Runnable action;
    protected Tooltip tooltip;

    public Button(IGui gui, String name, Runnable action) {
        super(gui);
        this.name = name;
        this.action = action;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        int w = this.gui.textWidth(this.name);
        int bgColor = this.gui.getColors().button_fill;
        int color = this.gui.getColors().button_text_color;
        if (!this.enabled) {
            color = this.gui.getColors().button_text_disabled;
            bgColor = this.gui.getColors().button_disabled;
        } else if (event.isHovered(this.bounds)) {
            color = this.gui.getColors().button_text_hover;
            bgColor = this.gui.getColors().button_hover;
        }
        if (event.isHovered(this.bounds) && this.tooltip != null) {
            this.tooltip.set();
        }
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, bgColor);
        this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 - 4, this.name, color);
    }

    @Override
    public boolean mouseClick(int x, int y, int btn) {
        if (this.enabled && this.bounds.isInBounds(x, y)) {
            if (this.action != null) {
                this.action.run();
            }
            return true;
        }
        return false;
    }

    public void setText(String name) {
        this.name = name;
    }

    public String getText() {
        return this.name;
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
    }
}

