/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class ConfigEntry {
    protected Map<String, ConfigEntry> entries = new HashMap<String, ConfigEntry>();
    protected Map<String, ConfigEntryList> lists = new HashMap<String, ConfigEntryList>();
    protected Map<String, Object> data;
    protected Runnable changeListener;

    private ConfigEntry() {
    }

    public ConfigEntry(Map<String, Object> data, Runnable changeListener) {
        this.data = data;
        this.changeListener = changeListener;
    }

    public String getString(String name, String def) {
        try {
            return (String)this.data.getOrDefault(name, def);
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public String getSetString(String name, String def) {
        try {
            return this.getSet(name, def);
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public void setString(String name, String value) {
        this.data.put(name, value);
        this.changeListener.run();
    }

    public void clearValue(String name) {
        this.data.remove(name);
        this.entries.remove(name);
        this.changeListener.run();
    }

    public int getInt(String name, int def) {
        try {
            return ((Number)this.data.getOrDefault(name, def)).intValue();
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public int getSetInt(String name, int def) {
        try {
            return this.getSet(name, def);
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public void setInt(String name, int value) {
        this.data.put(name, value);
        this.changeListener.run();
    }

    public boolean getBoolean(String name, boolean def) {
        try {
            return (Boolean)this.data.getOrDefault(name, def);
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public boolean getSetBoolean(String name, boolean def) {
        try {
            return this.getSet(name, def);
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    private <T> T getSet(String name, T def) {
        Object v = this.data.get(name);
        if (v == null) {
            v = def;
            this.data.put(name, def);
            this.changeListener.run();
        }
        return (T)v;
    }

    public void setBoolean(String name, boolean value) {
        this.data.put(name, value);
        this.changeListener.run();
    }

    public ConfigEntry getEntry(String name) {
        return this.entries.computeIfAbsent(name, k -> new ConfigEntry((Map)this.data.computeIfAbsent(name, k2 -> new HashMap()), this.changeListener));
    }

    public ConfigEntryList getEntryList(String name) {
        return this.lists.computeIfAbsent(name, k -> new ConfigEntryList((List)this.data.computeIfAbsent(name, k2 -> new ArrayList()), this.changeListener));
    }

    public boolean hasEntry(String name) {
        return this.data.containsKey(name);
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public static class ConfigEntryList {
        protected List<Object> data;
        protected Runnable changeListener;

        public ConfigEntryList(List<Object> data, Runnable changeListener) {
            this.data = data;
            this.changeListener = changeListener;
        }

        public int size() {
            return this.data.size();
        }

        public boolean add(Object e) {
            return this.data.add(e);
        }

        public void clear() {
            this.data.clear();
        }

        public Object get(int index) {
            return this.data.get(index);
        }

        public boolean contains(Object o) {
            return this.data.contains(o);
        }
    }

    public static class ModConfigFile
    extends ConfigEntry {
        public static final Gson gson = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().create();
        private File cfgFile;
        private boolean changed = false;

        public ModConfigFile(File file) {
            this.cfgFile = file;
            this.changeListener = () -> {
                this.changed = true;
            };
            if (this.cfgFile.exists()) {
                try (FileReader rd = new FileReader(this.cfgFile);){
                    this.data = (Map)gson.fromJson((Reader)rd, Object.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.data == null) {
                this.data = new HashMap();
                this.changed = true;
            }
        }

        public void save() {
            if (this.changed) {
                try (FileWriter wr = new FileWriter(this.cfgFile);){
                    gson.toJson((Object)this.data, Object.class, (Appendable)wr);
                    this.changed = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public ConfigEntryTemp createTemp() {
            return new ConfigEntryTemp(this.data);
        }

        public class ConfigEntryTemp
        extends ConfigEntry {
            private ConfigEntry ent;

            public ConfigEntryTemp(Map<String, Object> map) {
                this.changeListener = () -> {};
                this.data = new HashMap<String, Object>(map);
            }

            public void saveConfig() {
                ModConfigFile.this.data = this.data;
                ModConfigFile.this.changed = true;
                ModConfigFile.this.entries.clear();
                ModConfigFile.this.lists.clear();
                ModConfigFile.this.save();
            }

            @Override
            public ConfigEntry getEntry(String name) {
                return this.entries.computeIfAbsent(name, k -> new ConfigEntry(this.mapGet(name, HashMap::new, HashMap::new), this.changeListener));
            }

            @Override
            public ConfigEntryList getEntryList(String name) {
                return this.lists.computeIfAbsent(name, k -> new ConfigEntryList(this.mapGet(name, ArrayList::new, ArrayList::new), this.changeListener));
            }

            private <T> T mapGet(String name, Supplier<T> newV, UnaryOperator<T> copy) {
                return (T)this.data.compute(name, (k, v) -> v == null ? newV.get() : copy.apply(v));
            }
        }
    }
}

