/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.tag.MCTagWithAmount;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import flaxbeard.immersivepetroleum.api.crafting.SulfurRecoveryRecipe;
import flaxbeard.immersivepetroleum.common.util.compat.crafttweaker.TweakerUtils;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersivepetroleum/SRU")
@ZenCodeType.Name(value="mods.immersivepetroleum.Hydrotreater")
public class SulfurRecoveryRecipeTweaker
implements IRecipeManager {
    public IRecipeType<SulfurRecoveryRecipe> getRecipeType() {
        return SulfurRecoveryRecipe.TYPE;
    }

    @ZenCodeType.Method
    public void removeAll() {
        SulfurRecoveryRecipe.recipes.clear();
    }

    @ZenCodeType.Method
    public void removeByOutputItem(IIngredient output) {
        SulfurRecoveryRecipe.recipes.values().removeIf(recipe -> output.matches((IItemStack)new MCItemStack(recipe.outputItem)));
    }

    @ZenCodeType.Method
    public void removeByOutputFluid(IFluidStack output) {
        SulfurRecoveryRecipe.recipes.values().removeIf(recipe -> recipe.output.isFluidEqual(output.getInternal()));
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IFluidStack output, IItemStack outputItem, double chance, MCTagWithAmount<Fluid> inputFluid, int energy) {
        ResourceLocation id = TweakerUtils.ctLoc("hydrotreater/" + recipePath);
        FluidTagInput primary = new FluidTagInput(inputFluid.getTag().getId(), inputFluid.getAmount());
        this.newRecipe(id, output, outputItem, chance, primary, null, energy);
    }

    @ZenCodeType.Method
    public void addRecipeWithSecondary(String recipePath, IFluidStack output, IItemStack outputItem, double chance, MCTagWithAmount<Fluid> inputFluid, MCTagWithAmount<Fluid> inputFluidSecondary, int energy) {
        ResourceLocation id = TweakerUtils.ctLoc("hydrotreater/" + recipePath);
        FluidTagInput primary = new FluidTagInput(inputFluid.getTag().getId(), inputFluid.getAmount());
        FluidTagInput secondary = new FluidTagInput(inputFluidSecondary.getTag().getId(), inputFluidSecondary.getAmount());
        this.newRecipe(id, output, outputItem, chance, primary, secondary, energy);
    }

    private void newRecipe(ResourceLocation id, IFluidStack output, IItemStack outputItem, double chance, FluidTagInput primary, FluidTagInput secondary, int energy) {
        SulfurRecoveryRecipe recipe = new SulfurRecoveryRecipe(id, output.getInternal(), outputItem.getInternal(), primary, secondary, chance, energy, 1);
        SulfurRecoveryRecipe.recipes.put(id, recipe);
    }
}

