/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import flaxbeard.immersivepetroleum.api.crafting.pumpjack.PumpjackHandler;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.multiblocks.PumpjackMultiblock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Pair;

public class PumpjackTileEntity
extends PoweredMultiblockTileEntity<PumpjackTileEntity, MultiblockRecipe>
implements IEBlockInterfaces.IBlockBounds {
    public static final Set<BlockPos> Redstone_IN = ImmutableSet.of((Object)new BlockPos(0, 1, 5));
    public static final Set<BlockPos> Energy_IN = ImmutableSet.of((Object)new BlockPos(2, 1, 5));
    public static final BlockPos East_Port = new BlockPos(2, 0, 2);
    public static final BlockPos West_Port = new BlockPos(0, 0, 2);
    public static final BlockPos Down_Port = new BlockPos(1, 0, 0);
    public FluidTank fakeTank = new FluidTank(0);
    public boolean wasActive = false;
    public float activeTicks = 0.0f;
    private int pipeTicks = 0;
    private boolean lastHadPipes = true;
    public BlockState state = null;
    private static CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(PumpjackTileEntity::getShape);

    public PumpjackTileEntity() {
        super((IETemplateMultiblock)PumpjackMultiblock.INSTANCE, 16000, true, null);
    }

    public TileEntityType<?> func_200662_C() {
        return (TileEntityType)IPTileTypes.PUMP.get();
    }

    public boolean canExtract() {
        return true;
    }

    public int getFluidAmount() {
        return PumpjackHandler.getFluidAmount(this.field_145850_b, this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4);
    }

    public Fluid getFluidType() {
        return PumpjackHandler.getFluid(this.field_145850_b, this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4);
    }

    public int getResidualFluid() {
        return PumpjackHandler.getResidualFluid(this.field_145850_b, this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4);
    }

    public void extractFluid(int amount) {
        PumpjackHandler.depleteFluid(this.field_145850_b, this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4, amount);
    }

    private boolean hasPipes() {
        if (((Boolean)IPServerConfig.EXTRACTION.required_pipes.get()).booleanValue()) {
            BlockPos basePos = this.getBlockPosForPos(Down_Port);
            for (int y = basePos.func_177956_o() - 1; y > 0; --y) {
                BlockPos pos = new BlockPos(basePos.func_177958_n(), y, basePos.func_177952_p());
                BlockState state = this.field_145850_b.func_180495_p(pos);
                if (state.func_177230_c() == Blocks.field_150357_h) {
                    return true;
                }
                if (state.func_177230_c() == IEBlocks.MetalDevices.fluidPipe) continue;
                return false;
            }
        }
        return true;
    }

    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        Block block;
        ItemStack stack;
        super.readCustomNBT(nbt, descPacket);
        boolean lastActive = this.wasActive;
        this.wasActive = nbt.func_74767_n("wasActive");
        this.lastHadPipes = nbt.func_74767_n("lastHadPipes");
        if (!this.wasActive && lastActive) {
            this.activeTicks += 1.0f;
        }
        this.state = null;
        if (nbt.func_186855_b("comp") && !(stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("comp"))).func_190926_b() && (block = Block.func_149634_a((Item)stack.func_77973_b())) != Blocks.field_150350_a) {
            this.state = block.func_176223_P();
        }
    }

    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74757_a("wasActive", this.wasActive);
        nbt.func_74757_a("lastHadPipes", this.lastHadPipes);
        if (this.getFluidType() != null) {
            FluidStack stack = new FluidStack(this.getFluidType(), 0);
            CompoundNBT comp = new CompoundNBT();
            stack.writeToNBT(comp);
            nbt.func_218657_a("comp", (INBT)comp);
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if ((this.field_145850_b.field_72995_K || this.isDummy()) && this.wasActive) {
            this.activeTicks += 1.0f;
            if (this.state != null) {
                float r1 = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 2.0f;
                float r2 = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 2.0f;
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)r1 * 0.04, 0.25, (double)r2 * 0.025);
            }
            return;
        }
        boolean active = false;
        int consumption = (Integer)IPServerConfig.EXTRACTION.pumpjack_consumption.get();
        int extracted = this.energyStorage.extractEnergy(((Integer)IPServerConfig.EXTRACTION.pumpjack_consumption.get()).intValue(), true);
        if (extracted >= consumption && this.canExtract()) {
            if ((this.func_174877_v().func_177958_n() + this.func_174877_v().func_177952_p()) % (Integer)IPServerConfig.EXTRACTION.pipe_check_ticks.get() == this.pipeTicks) {
                this.lastHadPipes = this.hasPipes();
            }
            if (!this.isRSDisabled() && this.lastHadPipes) {
                int available = this.getFluidAmount();
                int residual = this.getResidualFluid();
                if (available > 0 || residual > 0) {
                    int drained;
                    int accepted;
                    int oilAmnt = available <= 0 ? residual : available;
                    FluidStack out = new FluidStack(this.getFluidType(), Math.min((Integer)IPServerConfig.EXTRACTION.pumpjack_speed.get(), oilAmnt));
                    Direction facing = this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e();
                    BlockPos outputPos = ((PumpjackTileEntity)this.master()).getBlockPosForPos(East_Port).func_177972_a(facing);
                    IFluidHandler output = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)outputPos, (Direction)facing.func_176734_d()).orElse(null);
                    if (output != null && (accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                        drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                        this.extractFluid(drained);
                        active = true;
                        out = Utils.copyFluidStackWithAmount((FluidStack)out, (int)(out.getAmount() - drained), (boolean)false);
                    }
                    facing = this.getIsMirrored() ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f();
                    outputPos = ((PumpjackTileEntity)this.master()).getBlockPosForPos(West_Port).func_177972_a(facing);
                    output = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)outputPos, (Direction)facing.func_176734_d()).orElse(null);
                    if (output != null && (accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                        drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                        this.extractFluid(drained);
                        active = true;
                    }
                    if (active) {
                        this.energyStorage.extractEnergy(consumption, false);
                    }
                    this.activeTicks += 1.0f;
                }
            }
            this.pipeTicks = (this.pipeTicks + 1) % (Integer)IPServerConfig.EXTRACTION.pipe_check_ticks.get();
        }
        if (active != this.wasActive) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
        this.wasActive = active;
    }

    public Set<BlockPos> getEnergyPos() {
        return Energy_IN;
    }

    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        if (this.formed && this.isEnergyPos() && (facing == null || facing == Direction.UP)) {
            return IEEnums.IOSideConfig.INPUT;
        }
        return IEEnums.IOSideConfig.NONE;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
    }

    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return false;
    }

    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return 0.0f;
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public int[] getOutputSlots() {
        return null;
    }

    public int[] getOutputTanks() {
        return new int[]{1};
    }

    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    protected MultiblockRecipe getRecipeForId(ResourceLocation id) {
        return null;
    }

    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    public IFluidTank[] getInternalTanks() {
        return null;
    }

    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        PumpjackTileEntity master = (PumpjackTileEntity)this.master();
        if (master != null) {
            if (this.posInMultiblock.equals((Object)East_Port) && (side == null || (this.getIsMirrored() ? side == this.getFacing().func_176735_f() : side == this.getFacing().func_176746_e()))) {
                return new FluidTank[]{master.fakeTank};
            }
            if (this.posInMultiblock.equals((Object)West_Port) && (side == null || (this.getIsMirrored() ? side == this.getFacing().func_176746_e() : side == this.getFacing().func_176735_f()))) {
                return new FluidTank[]{master.fakeTank};
            }
            if (((Boolean)IPServerConfig.EXTRACTION.required_pipes.get()).booleanValue() && this.posInMultiblock.equals((Object)Down_Port) && (side == null || side == Direction.DOWN)) {
                return new FluidTank[]{master.fakeTank};
            }
        }
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    public VoxelShape getBlockBounds(ISelectionContext ctx) {
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        int bX = posInMultiblock.func_177958_n();
        int bY = posInMultiblock.func_177956_o();
        int bZ = posInMultiblock.func_177952_p();
        if (bY == 3 && bX == 1 && bZ != 2 || bX == 1 && bY == 2 && bZ == 0) {
            return new ArrayList<AxisAlignedBB>();
        }
        if (bY < 3 && bX == 1 && bZ == 4) {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            if (bY == 2) {
                list.add(new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 0.25, 1.0));
            } else {
                list.add(new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 1.0));
            }
            if (bY == 0) {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
            }
            return list;
        }
        if (bZ == 2 && bY > 0) {
            if (bX == 0) {
                if (bY == 1) {
                    ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
                    list.add(new AxisAlignedBB(0.6875, 0.0, 0.0, 1.0, 1.0, 0.25));
                    list.add(new AxisAlignedBB(0.6875, 0.0, 0.75, 1.0, 1.0, 1.0));
                    return list;
                }
                if (bY == 2) {
                    ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
                    list.add(new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 0.5, 1.0));
                    list.add(new AxisAlignedBB(0.8125, 0.5, 0.25, 1.0, 1.0, 0.75));
                    return list;
                }
                if (bY == 3) {
                    return Arrays.asList(new AxisAlignedBB(0.9375, 0.0, 0.375, 1.0, 0.125, 0.625));
                }
            }
            if (bX == 1 && bY == 3) {
                return Arrays.asList(new AxisAlignedBB(0.0, -0.125, 0.375, 1.0, 0.125, 0.625));
            }
            if (bX == 2) {
                if (bY == 1) {
                    ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
                    list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.3125, 1.0, 0.25));
                    list.add(new AxisAlignedBB(0.0, 0.0, 0.75, 0.3125, 1.0, 1.0));
                    return list;
                }
                if (bY == 2) {
                    ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
                    list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 0.5, 1.0));
                    list.add(new AxisAlignedBB(0.0, 0.5, 0.25, 0.1875, 1.0, 0.75));
                    return list;
                }
                if (bY == 3) {
                    return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.375, 0.0625, 0.125, 0.625));
                }
            }
        }
        if (bX == 0 && bZ == 5) {
            if (bY == 0) {
                return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.75, 0.0, 0.625, 0.875, 1.0, 0.875), new AxisAlignedBB(0.125, 0.0, 0.625, 0.25, 1.0, 0.875));
            }
            if (bY == 1) {
                return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
            }
        }
        if (bX == 2 && bY == 0 && bZ == 5) {
            return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }
        if (bY == 0) {
            if (bZ == 1 && (bX == 0 || bX == 2)) {
                ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
                if (bX == 0) {
                    list.add(new AxisAlignedBB(0.5, 0.5, 0.5, 1.0, 1.0, 1.0));
                }
                if (bX == 2) {
                    list.add(new AxisAlignedBB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0));
                }
                return list;
            }
            if (bZ == 3 && (bX == 0 || bX == 2)) {
                ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
                if (bX == 0) {
                    list.add(new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 0.5));
                }
                if (bX == 2) {
                    list.add(new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5));
                }
                return list;
            }
            if (bZ == 2 && (bX == 0 || bX == 2)) {
                return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
            }
            if (bX == 1) {
                if (bZ == 0) {
                    return Arrays.asList(new AxisAlignedBB(0.3125, 0.5, 0.8125, 0.6875, 0.875, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125));
                }
                if (bZ == 1) {
                    return Arrays.asList(new AxisAlignedBB(0.3125, 0.5, 0.0, 0.6875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
                }
                if (bZ == 2) {
                    return Arrays.asList(new AxisAlignedBB(0.3125, 0.5, 0.0, 0.6875, 0.875, 0.6875), new AxisAlignedBB(0.0, 0.5, 0.3125, 1.0, 0.875, 0.6875), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
                }
            }
            return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }
}

