/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.settings;

import net.minecraft.client.AbstractOption;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.IteratableOption;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.StringTextComponent;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;

public class ModOptions {
    public static ModOptions DEBUG;
    public static ModOptions COLOURS;
    public static ModOptions LIGHTING;
    public static ModOptions UPDATE;
    public static ModOptions LOAD;
    public static ModOptions DEPTH;
    public static ModOptions SLOPES;
    public static ModOptions STEPS;
    public static ModOptions FLOWERS;
    public static ModOptions COMPRESSION;
    public static ModOptions COORDINATES;
    public static ModOptions BIOMES;
    public static ModOptions WAYPOINTS;
    public static ModOptions ARROW;
    public static ModOptions DISPLAY_ZOOM;
    public static ModOptions IGNORE_HEIGHTMAPS;
    public static ModOptions WAYPOINT_SCALE;
    public static ModOptions OPEN_ANIMATION;
    public static ModOptions RELOAD;
    public static ModOptions ZOOM_BUTTONS;
    public static ModOptions WAYPOINT_BACKGROUNDS;
    public static ModOptions PAUSE_REQUESTS;
    public static ModOptions EXTRA_DEBUG;
    private final boolean enumDouble;
    private final boolean enumBoolean;
    private final String enumString;
    private double valueMin;
    private double valueMax;
    private double valueStep;
    private AbstractOption mcOption;
    private CursorBox tooltip;
    private boolean ingameOnly;

    public static void init() {
        DEBUG = new ModOptions("gui.xaero_debug", false, true, false);
        COLOURS = new ModOptions("gui.xaero_block_colours", false, true, false);
        LIGHTING = new ModOptions("gui.xaero_lighting", false, true, false);
        UPDATE = new ModOptions("gui.xaero_update_chunks", false, true, false);
        LOAD = new ModOptions("gui.xaero_load_chunks", false, true, false);
        DEPTH = new ModOptions("gui.xaero_terrain_depth", false, true, false);
        SLOPES = new ModOptions("gui.xaero_terrain_slopes", false, true, false);
        STEPS = new ModOptions("gui.xaero_footsteps", false, true, false);
        FLOWERS = new ModOptions("gui.xaero_flowers", false, true, false);
        COMPRESSION = new ModOptions("gui.xaero_texture_compression", false, true, false);
        COORDINATES = new ModOptions("gui.xaero_wm_coordinates", false, true, false);
        BIOMES = new ModOptions("gui.xaero_biome_colors", false, true, false);
        WAYPOINTS = new ModOptions("gui.xaero_worldmap_waypoints", false, true, false);
        ARROW = new ModOptions("gui.xaero_render_arrow", false, true, false);
        DISPLAY_ZOOM = new ModOptions("gui.xaero_display_zoom", false, true, false);
        IGNORE_HEIGHTMAPS = new ModOptions("gui.xaero_wm_ignore_heightmaps", false, true, new CursorBox("gui.xaero_wm_box_ignore_heightmaps"), true);
        WAYPOINT_SCALE = new ModOptions("gui.xaero_wm_waypoint_scale", true, false, 0.5, 5.0, 0.5f, false);
        OPEN_ANIMATION = new ModOptions("gui.xaero_open_map_animation", false, true, false);
        RELOAD = new ModOptions("gui.xaero_reload_everything", false, true, false);
        ZOOM_BUTTONS = new ModOptions("gui.xaero_zoom_buttons", false, true, false);
        WAYPOINT_BACKGROUNDS = new ModOptions("gui.xaero_waypoint_backgrounds", false, true, false);
        PAUSE_REQUESTS = new ModOptions("pause_requests", false, true, false);
        EXTRA_DEBUG = new ModOptions("extra_debug", false, true, false);
    }

    private ModOptions(String par3Str, boolean par4, boolean par5, boolean ingameOnly) {
        this(par3Str, par4, par5, null, ingameOnly);
    }

    private ModOptions(String p_i45004_3_, boolean p_i45004_4_, boolean p_i45004_5_, double p_i45004_6_, double p_i45004_7_, float p_i45004_8_, boolean ingameOnly) {
        this(p_i45004_3_, p_i45004_4_, p_i45004_5_, p_i45004_6_, p_i45004_7_, p_i45004_8_, null, ingameOnly);
    }

    private ModOptions(String par3Str, boolean par4, boolean par5, CursorBox tooltip, boolean ingameOnly) {
        this.tooltip = tooltip;
        this.enumString = par3Str;
        this.enumDouble = par4;
        this.enumBoolean = par5;
        this.mcOption = new IteratableOption(par3Str, (gameSettings, option) -> WorldMap.settings.setOptionValue(this), (gameSettings, option) -> new StringTextComponent(WorldMap.settings.getKeyBinding(this)));
        this.ingameOnly = ingameOnly;
    }

    private ModOptions(String p_i45004_3_, boolean p_i45004_4_, boolean p_i45004_5_, double p_i45004_6_, double p_i45004_7_, float p_i45004_8_, CursorBox tooltip, boolean ingameOnly) {
        this.tooltip = tooltip;
        this.enumString = p_i45004_3_;
        this.enumDouble = p_i45004_4_;
        this.enumBoolean = p_i45004_5_;
        this.valueMin = p_i45004_6_;
        this.valueMax = p_i45004_7_;
        this.valueStep = p_i45004_8_;
        this.mcOption = new SliderPercentageOption(p_i45004_3_, p_i45004_6_, p_i45004_7_, p_i45004_8_, gameSettings -> WorldMap.settings.getOptionDoubleValue(this), (gameSettings, option) -> WorldMap.settings.setOptionDoubleValue(this, (double)option), (gameSettings, option) -> new StringTextComponent(WorldMap.settings.getKeyBinding(this)));
        this.ingameOnly = ingameOnly;
    }

    public boolean getEnumDouble() {
        return this.enumDouble;
    }

    public boolean getEnumBoolean() {
        return this.enumBoolean;
    }

    public double getValueMax() {
        return this.valueMax;
    }

    public void setValueMax(float p_148263_1_) {
        this.valueMax = p_148263_1_;
    }

    public double normalizeValue(double p_148266_1_) {
        return MathHelper.func_151237_a((double)((this.snapToStepClamp(p_148266_1_) - this.valueMin) / (this.valueMax - this.valueMin)), (double)0.0, (double)1.0);
    }

    public double denormalizeValue(double p_148262_1_) {
        return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * MathHelper.func_151237_a((double)p_148262_1_, (double)0.0, (double)1.0));
    }

    public double snapToStepClamp(double p_148268_1_) {
        p_148268_1_ = this.snapToStep(p_148268_1_);
        return MathHelper.func_151237_a((double)p_148268_1_, (double)this.valueMin, (double)this.valueMax);
    }

    protected double snapToStep(double p_148264_1_) {
        if (this.valueStep > 0.0) {
            p_148264_1_ = this.valueStep * (double)Math.round(p_148264_1_ / this.valueStep);
        }
        return p_148264_1_;
    }

    public String getEnumString() {
        return I18n.func_135052_a((String)this.enumString, (Object[])new Object[0]);
    }

    public AbstractOption getMcOption() {
        return this.mcOption;
    }

    public CursorBox getTooltip() {
        return this.tooltip;
    }

    public boolean isIngameOnly() {
        return this.ingameOnly;
    }
}

