/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;

public class MapRenderHelper {
    public static void renderTexturedModalRect(float x, float y, float width, float height, int textureX, int textureY, float textureW, float textureH, float fullTextureWidth, float fullTextureHeight) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float normalizedTextureX = (float)textureX / fullTextureWidth;
        float normalizedTextureY = (float)textureY / fullTextureHeight;
        float normalizedTextureX2 = ((float)textureX + textureW) / fullTextureWidth;
        float normalizedTextureY2 = ((float)textureY + textureH) / fullTextureHeight;
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + height), 0.0).func_225583_a_(normalizedTextureX, normalizedTextureY2).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_(normalizedTextureX2, normalizedTextureY2).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + 0.0f), 0.0).func_225583_a_(normalizedTextureX2, normalizedTextureY).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_225583_a_(normalizedTextureX, normalizedTextureY).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void fillIntoExistingBuffer(Matrix4f matrix, IVertexBuilder bufferBuilder, int x1, int y1, int x2, int y2, float r, float g, float b, float a) {
        bufferBuilder.func_227888_a_(matrix, (float)x1, (float)y2, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)x2, (float)y2, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)x2, (float)y1, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)x1, (float)y1, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, IVertexBuilder bufferBuilder, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int textureWidth, int textureHeight) {
        float factorX = 1.0f / (float)textureWidth;
        float factorY = 1.0f / (float)textureHeight;
        float textureX1 = (float)u * factorX;
        float textureX2 = (float)(u + width) * factorX;
        float textureY1 = (float)v * factorY;
        float textureY2 = (float)(v + height) * factorY;
        bufferBuilder.func_227888_a_(matrix, (float)x, (float)(y + height), 0.0f).func_225583_a_(textureX1, textureY2).func_227885_a_(r, g, b, a).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)(x + width), (float)(y + height), 0.0f).func_225583_a_(textureX2, textureY2).func_227885_a_(r, g, b, a).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)(x + width), (float)y, 0.0f).func_225583_a_(textureX2, textureY1).func_227885_a_(r, g, b, a).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)x, (float)y, 0.0f).func_225583_a_(textureX1, textureY1).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, IVertexBuilder bufferBuilder, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a) {
        MapRenderHelper.blitIntoExistingBuffer(matrix, bufferBuilder, x, y, u, v, width, height, r, g, b, a, 256, 256);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int textureWidth, int textureHeight, int texture) {
        BufferBuilder bufferBuilder = renderer.begin(7, DefaultVertexFormats.field_181709_i, texture);
        MapRenderHelper.blitIntoExistingBuffer(matrix, (IVertexBuilder)bufferBuilder, x, y, u, v, width, height, r, g, b, a, textureWidth, textureHeight);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int texture) {
        MapRenderHelper.blitIntoMultiTextureRenderer(matrix, renderer, x, y, u, v, width, height, r, g, b, a, 256, 256, texture);
    }
}

