/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import com.mojang.datafixers.DataFixer;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.BitArray;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.palette.HashMapPalette;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeIntKey;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class WorldDataReader {
    private MapProcessor mapProcessor;
    private boolean[] underair;
    private boolean[] blockFound;
    private byte[] lightLevels;
    private int[] biomeBuffer;
    private MapBlock buildingObject;
    private OverlayBuilder[] overlayBuilders;
    private BlockState[] prevOverlays;
    private BlockPos.Mutable mutableBlockPos;
    private IPalette<BlockState> blockStatePalette;
    private BitArray heightMapBitArray;
    private BitArray blockStatesBitArray;
    private int currentBits;
    private CompoundNBT[] chunkNBTCompounds;
    public Object taskCreationSync;
    private BlockStateColorTypeCache colorTypeCache;
    private BiomeKeyManager biomeKeyManager;

    public WorldDataReader(OverlayManager overlayManager, BlockStateColorTypeCache colorTypeCache, BiomeKeyManager biomeKeyManager) {
        this.colorTypeCache = colorTypeCache;
        this.buildingObject = new MapBlock();
        this.underair = new boolean[256];
        this.blockFound = new boolean[256];
        this.lightLevels = new byte[256];
        this.biomeBuffer = new int[3];
        this.prevOverlays = new BlockState[256];
        this.overlayBuilders = new OverlayBuilder[256];
        this.mutableBlockPos = new BlockPos.Mutable();
        this.blockStatePalette = new HashMapPalette(Block.field_176229_d, 32, null, NBTUtil::func_190008_d, NBTUtil::func_190009_a);
        this.heightMapBitArray = new BitArray(9, 256);
        this.taskCreationSync = new Object();
        for (int i = 0; i < this.overlayBuilders.length; ++i) {
            this.overlayBuilders[i] = new OverlayBuilder(overlayManager);
        }
        this.chunkNBTCompounds = new CompoundNBT[16];
        this.biomeKeyManager = biomeKeyManager;
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildRegion(MapRegion region, ServerWorld worldServer, World world, boolean loading, int[] chunkCountDest) {
        boolean regionIsResting;
        if (!loading) {
            region.pushWriterPause();
        }
        boolean result = true;
        int prevRegX = region.getRegionX();
        int prevRegZ = region.getRegionZ() - 1;
        MapRegion prevRegion = this.mapProcessor.getMapRegion(prevRegX, prevRegZ, false);
        MapRegion mapRegion = region;
        synchronized (mapRegion) {
            regionIsResting = region.isResting();
            if (!loading && regionIsResting) {
                region.setBeingWritten(true);
                region.setShouldCache(false, "world save");
                region.setReloadHasBeenRequested(false, "world save");
                region.setVersion(this.mapProcessor.getGlobalVersion());
                region.setCacheHashCode(WorldMap.settings.getRegionCacheHashCode());
                if (region.getLoadState() != 2) {
                    if (region.getLoadState() == 4) {
                        region.restoreBufferUpdateObjects();
                    }
                    region.setLoadState((byte)2);
                    region.setLastSaveTime(System.currentTimeMillis() + 100000L);
                    this.mapProcessor.addToProcess(region);
                } else {
                    this.mapProcessor.removeToRefresh(region);
                    region.setRefreshing(false);
                }
            }
        }
        int caveStart = this.mapProcessor.getCaveStart();
        boolean ignoreHeightmaps = this.mapProcessor.getMapWorld().isIgnoreHeightmaps();
        boolean flowers = WorldMap.settings.flowers;
        if (loading || region.getLoadState() == 2 && regionIsResting) {
            ChunkManager chunkManager = worldServer.func_72863_F().field_217237_a;
            MutableRegistry<Biome> biomeRegistry = region.getBiomeRegistry();
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    MapTileChunk tileChunk = region.getChunk(i, j);
                    if (tileChunk == null) {
                        tileChunk = new MapTileChunk(region, (region.getRegionX() << 3) + i, (region.getRegionZ() << 3) + j);
                        region.setChunk(i, j, tileChunk);
                    }
                    this.readChunkNBTCompounds((ChunkLoader)chunkManager, tileChunk);
                    this.buildTileChunk(tileChunk, caveStart, ignoreHeightmaps, prevRegion, world, biomeRegistry, flowers);
                    tileChunk.setLoadState((byte)2);
                    if (!tileChunk.includeInSave()) {
                        tileChunk = null;
                        region.setChunk(i, j, null);
                        continue;
                    }
                    chunkCountDest[0] = chunkCountDest[0] + 1;
                }
            }
            if (region.isMultiplayer()) {
                region.setLastSaveTime(System.currentTimeMillis() - 60000L + 1500L);
            }
        } else {
            result = false;
        }
        if (!loading) {
            region.popWriterPause();
        }
        return result;
    }

    private void readChunkNBTCompounds(ChunkLoader chunkLoader, MapTileChunk tileChunk) {
        for (int xl = 0; xl < 4; ++xl) {
            for (int zl = 0; zl < 4; ++zl) {
                int i = zl << 2 | xl;
                try {
                    this.chunkNBTCompounds[i] = chunkLoader.func_227078_e_(new ChunkPos(tileChunk.getX() * 4 + xl, tileChunk.getZ() * 4 + zl));
                    continue;
                }
                catch (IOException e) {
                    this.chunkNBTCompounds[i] = null;
                }
            }
        }
    }

    public CompoundNBT readChunk(RegionFile regionFile, ChunkPos pos) throws IOException {
        try (DataInputStream datainputstream = regionFile.func_222666_a(pos);){
            if (datainputstream != null) {
                CompoundNBT compoundNBT = CompressedStreamTools.func_74794_a((DataInput)datainputstream);
                return compoundNBT;
            }
            CompoundNBT compoundNBT = null;
            return compoundNBT;
        }
    }

    private void buildTileChunk(MapTileChunk tileChunk, int caveStart, boolean ignoreHeightmaps, MapRegion prevRegion, World world, MutableRegistry<Biome> biomeRegistry, boolean flowers) {
        tileChunk.unincludeInSave();
        tileChunk.resetHeights();
        for (int insideX = 0; insideX < 4; ++insideX) {
            for (int insideZ = 0; insideZ < 4; ++insideZ) {
                int i;
                DataFixer fixer;
                MapTile tile = tileChunk.getTile(insideX, insideZ);
                int chunkX = (tileChunk.getX() << 2) + insideX;
                int chunkZ = (tileChunk.getZ() << 2) + insideZ;
                CompoundNBT nbttagcompound = this.chunkNBTCompounds[insideZ << 2 | insideX];
                if (nbttagcompound == null) {
                    if (tile == null) continue;
                    tileChunk.setChanged(true);
                    tileChunk.setTile(insideX, insideZ, null);
                    this.mapProcessor.getTilePool().addToPool(tile);
                    continue;
                }
                boolean createdTile = false;
                if (tile == null) {
                    tile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                    createdTile = true;
                }
                if (this.buildTile(nbttagcompound = NBTUtil.func_210822_a((DataFixer)(fixer = Minecraft.func_71410_x().func_184126_aj()), (DefaultTypeReferences)DefaultTypeReferences.CHUNK, (CompoundNBT)nbttagcompound, (int)(i = nbttagcompound.func_150297_b("DataVersion", 99) ? nbttagcompound.func_74762_e("DataVersion") : -1)), tile, tileChunk, chunkX, chunkZ, caveStart, ignoreHeightmaps, world, biomeRegistry, flowers)) {
                    tileChunk.setTile(insideX, insideZ, tile);
                    if (!createdTile) continue;
                    tileChunk.setChanged(true);
                    continue;
                }
                tileChunk.setTile(insideX, insideZ, null);
                this.mapProcessor.getTilePool().addToPool(tile);
            }
        }
        if (tileChunk.wasChanged()) {
            tileChunk.setToUpdateBuffers(true);
            tileChunk.setChanged(false);
        }
    }

    private boolean buildTile(CompoundNBT nbttagcompound, MapTile tile, MapTileChunk tileChunk, int chunkX, int chunkZ, int caveStart, boolean ignoreHeightmaps, World world, MutableRegistry<Biome> biomeRegistry, boolean flowers) {
        boolean heightMapExists;
        CompoundNBT levelCompound = nbttagcompound.func_74775_l("Level");
        String status = levelCompound.func_74779_i("Status");
        if (ChunkStatus.func_222591_a((String)status).func_222584_c() < ChunkStatus.field_222614_j.func_222584_c()) {
            return false;
        }
        ListNBT sectionsList = levelCompound.func_150295_c("Sections", 10);
        if (sectionsList.size() == 0) {
            return false;
        }
        int fillCounter = 256;
        for (int i = 0; i < this.blockFound.length; ++i) {
            this.overlayBuilders[i].startBuilding();
            this.blockFound[i] = false;
            this.underair[i] = false;
            this.prevOverlays[i] = null;
        }
        boolean oldHeightMap = !levelCompound.func_150297_b("Heightmaps", 10);
        int[] oldHeightMapArray = null;
        if (oldHeightMap) {
            oldHeightMapArray = levelCompound.func_74759_k("HeightMap");
            heightMapExists = oldHeightMapArray.length == 256;
        } else {
            long[] heightMapArray = levelCompound.func_74775_l("Heightmaps").func_197645_o("WORLD_SURFACE");
            boolean bl = heightMapExists = heightMapArray.length == 37;
            if (heightMapExists) {
                System.arraycopy(heightMapArray, 0, this.heightMapBitArray.func_188143_a(), 0, heightMapArray.length);
            }
        }
        int[] biomes = null;
        boolean biomesDataExists = false;
        if (levelCompound.func_150297_b("Biomes", 11)) {
            biomes = levelCompound.func_74759_k("Biomes");
            biomesDataExists = biomes.length == 1024;
        }
        boolean lightIsOn = !levelCompound.func_150297_b("isLightOn", 1) || levelCompound.func_74767_n("isLightOn");
        boolean cave = caveStart != -1;
        for (int i = sectionsList.size() - 1; i >= 0 && fillCounter > 0; --i) {
            CompoundNBT sectionCompound = sectionsList.func_150305_b(i);
            boolean hasBlocks = sectionCompound.func_150297_b("BlockStates", 12);
            boolean preparedSectionData = false;
            byte[] lightMap = null;
            int sectionHeight = sectionCompound.func_74771_c("Y") * 16;
            int sectionBasedHeight = sectionHeight + 15;
            for (int z = 0; z < 16; ++z) {
                block3: for (int x = 0; x < 16; ++x) {
                    int startHeight;
                    int pos_2d = (z << 4) + x;
                    if (this.blockFound[pos_2d]) continue;
                    if (cave) {
                        startHeight = caveStart;
                    } else {
                        int height = heightMapExists ? (oldHeightMap ? oldHeightMapArray[pos_2d] : this.heightMapBitArray.func_188142_a(pos_2d)) : 255;
                        startHeight = ignoreHeightmaps || height == -1 ? sectionBasedHeight : height + 3;
                    }
                    if (i > 0 && startHeight < sectionHeight) continue;
                    int localStartHeight = 15;
                    if (startHeight >> 4 << 4 == sectionHeight) {
                        localStartHeight = startHeight & 0xF;
                    }
                    if (!preparedSectionData) {
                        if (hasBlocks) {
                            ListNBT paletteList = sectionCompound.func_150295_c("Palette", 10);
                            this.blockStatePalette.func_196968_a(paletteList);
                            long[] blockStatesArray = sectionCompound.func_197645_o("BlockStates");
                            int bits = blockStatesArray.length * 64 / 4096;
                            int bitsOther = Math.max(4, MathHelper.func_151241_e((int)paletteList.size()));
                            if (bitsOther > 8) {
                                bits = bitsOther;
                            }
                            if (this.blockStatesBitArray == null || this.currentBits != bits) {
                                this.blockStatesBitArray = new BitArray(bits, 4096);
                                this.currentBits = bits;
                            }
                            System.arraycopy(blockStatesArray, 0, this.blockStatesBitArray.func_188143_a(), 0, blockStatesArray.length);
                        }
                        if (lightIsOn && sectionCompound.func_150297_b("BlockLight", 7) && (lightMap = sectionCompound.func_74770_j("BlockLight")).length != 2048) {
                            lightMap = null;
                        }
                        preparedSectionData = true;
                    }
                    for (int y = localStartHeight; y >= 0; --y) {
                        BlockState state;
                        int biomePos = x >> 2 | z >> 2 << 2 | (sectionHeight | y) >> 2 << 4;
                        int biomeInt = biomesDataExists && biomePos >= 0 && biomePos < 1024 ? biomes[biomePos] : 0;
                        BiomeIntKey biome = this.biomeKeyManager.get(biomeInt);
                        int h = sectionHeight + y;
                        int pos = y << 8 | pos_2d;
                        BlockState blockState = state = hasBlocks ? (BlockState)this.blockStatePalette.func_186039_a(this.blockStatesBitArray.func_188142_a(pos)) : Blocks.field_150350_a.func_176223_P();
                        if (state == null) {
                            state = Blocks.field_150350_a.func_176223_P();
                        }
                        this.mutableBlockPos.func_181079_c(chunkX << 4 | x, sectionHeight | y, chunkZ << 4 | z);
                        boolean buildResult = this.buildPixel(this.buildingObject, state, x, h, z, pos_2d, this.biomeBuffer, this.lightLevels[pos_2d], biome, cave, this.overlayBuilders[pos_2d], world, this.mutableBlockPos, biomeRegistry, flowers);
                        if (!buildResult && y == 0 && i == 0) {
                            this.buildingObject.prepareForWriting();
                            buildResult = true;
                        }
                        if (buildResult) {
                            MapBlock currentPixel = tile.getBlock(x, z);
                            if (!this.buildingObject.equals(currentPixel)) {
                                tile.setBlock(x, z, this.buildingObject);
                                this.buildingObject = currentPixel != null ? currentPixel : new MapBlock();
                                tileChunk.setChanged(true);
                            }
                            this.blockFound[pos_2d] = true;
                            --fillCounter;
                            continue block3;
                        }
                        this.lightLevels[pos_2d] = lightMap == null ? (byte)0 : this.nibbleValue(lightMap, pos);
                    }
                }
            }
        }
        tile.setWrittenOnce(true);
        tile.setLoaded(true);
        return true;
    }

    private boolean buildPixel(MapBlock pixel, BlockState state, int x, int h, int z, int pos_2d, int[] biomeBuffer, byte light, BiomeKey biome, boolean cave, OverlayBuilder overlayBuilder, World world, BlockPos.Mutable mutableBlockPos, MutableRegistry<Biome> biomeRegistry, boolean flowers) {
        Block b;
        FluidState fluidFluidState = state.func_204520_s();
        BlockState fluidState = fluidFluidState.func_206883_i();
        if (!fluidFluidState.func_206888_e()) {
            this.underair[pos_2d] = true;
            if (this.buildPixelHelp(pixel, fluidState, fluidState.func_177230_c(), fluidFluidState, pos_2d, h, cave, light, biome, overlayBuilder, world, biomeRegistry, flowers)) {
                return true;
            }
        }
        if ((b = state.func_177230_c()) instanceof AirBlock) {
            this.underair[pos_2d] = true;
            return false;
        }
        if (!this.underair[pos_2d]) {
            if (!cave) {
                this.underair[pos_2d] = true;
            }
            return false;
        }
        if (b == fluidState.func_177230_c()) {
            return false;
        }
        return this.buildPixelHelp(pixel, state, state.func_177230_c(), null, pos_2d, h, cave, light, biome, overlayBuilder, world, biomeRegistry, flowers);
    }

    private boolean buildPixelHelp(MapBlock pixel, BlockState state, Block b, FluidState fluidFluidState, int pos_2d, int h, boolean cave, byte light, BiomeKey dataBiome, OverlayBuilder overlayBuilder, World world, MutableRegistry<Biome> biomeRegistry, boolean flowers) {
        BiomeKey blockBiome = null;
        if (this.mapProcessor.getMapWriter().shouldOverlay(state, fluidFluidState, state.func_200016_a((IBlockReader)world, (BlockPos)this.mutableBlockPos))) {
            if (state != this.prevOverlays[pos_2d]) {
                blockBiome = this.colorTypeCache.getOverlayBiomeColour(world, state, (BlockPos)this.mutableBlockPos, this.biomeBuffer, this.colorTypeCache.PLACEHOLDER_BIOME, biomeRegistry);
                this.prevOverlays[pos_2d] = state;
            }
            overlayBuilder.build(state, this.biomeBuffer, state.func_200016_a((IBlockReader)world, (BlockPos)this.mutableBlockPos), light, world, this.mapProcessor);
            return false;
        }
        if (this.mapProcessor.getMapWriter().isInvisible(world, state, b, flowers)) {
            return false;
        }
        pixel.prepareForWriting();
        overlayBuilder.finishBuilding(pixel);
        blockBiome = this.colorTypeCache.getBlockBiomeColour(world, state, (BlockPos)this.mutableBlockPos, this.biomeBuffer, dataBiome, biomeRegistry);
        if (pixel.getNumberOfOverlays() > 0) {
            blockBiome = dataBiome;
        }
        boolean glowing = this.mapProcessor.getMapWriter().isGlowing(state);
        pixel.write(state, h, this.biomeBuffer, blockBiome, light, glowing, cave);
        return true;
    }

    private byte nibbleValue(byte[] array, int index) {
        byte b = array[index >> 1];
        if ((index & 1) == 0) {
            return (byte)(b & 0xF);
        }
        return (byte)(b >> 4 & 0xF);
    }
}

