/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.cache;

import java.util.Hashtable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BiomeKeyManager;

public class BlockStateColorTypeCache {
    public final BiomeKey PLACEHOLDER_BIOME;
    public final BiomeKey UNKNOWN_BIOME;
    private Hashtable<BlockState, Integer> colorTypes = new Hashtable();
    private Hashtable<BlockState, Integer> overlayColorTypes = new Hashtable();
    private int grassColor;
    private int foliageColor;
    private BlockState grassState;
    private BlockState oakLeavesState;
    private BlockState waterState;
    private BiomeKeyManager biomeKeyManager;

    public BlockStateColorTypeCache(BiomeKeyManager biomeKeyManager) {
        this.biomeKeyManager = biomeKeyManager;
        this.grassState = Blocks.field_196658_i.func_176223_P();
        this.oakLeavesState = Blocks.field_196642_W.func_176223_P();
        this.waterState = Blocks.field_150355_j.func_176223_P();
        this.PLACEHOLDER_BIOME = biomeKeyManager.get("xaeroworldmap:placeholder_biome");
        this.UNKNOWN_BIOME = biomeKeyManager.get("xaeroworldmap:unknown_biome");
    }

    public BiomeKey getBlockBiomeColour(World world, BlockState state, BlockPos pos, int[] dest, BiomeKey biomeId, MutableRegistry<Biome> biomeRegistry) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        BiomeKey blockBiome = null;
        Integer cachedColorType = this.colorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.func_71410_x().func_213162_bc();
        if (colorType == -1 && isRenderThread) {
            Material material;
            try {
                customColour = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, null, null, 0);
            }
            catch (Throwable t) {
                customColour = 0;
            }
            if (customColour != -1 && customColour != this.grassColor && customColour != this.foliageColor && (material = state.func_185904_a()) != null && (material.func_151565_r() == MaterialColor.field_151661_c || material.func_151565_r() == MaterialColor.field_151669_i)) {
                customColour = this.tryGettingColor(state, world, pos, 0);
                gotFullCC = true;
                if (material.func_151565_r() == MaterialColor.field_151661_c && customColour == this.tryGettingColor(this.grassState, world, pos, 0)) {
                    customColour = this.grassColor;
                } else if (material.func_151565_r() == MaterialColor.field_151669_i && customColour == this.tryGettingColor(this.oakLeavesState, world, pos, 0)) {
                    customColour = this.foliageColor;
                }
            }
            if (customColour == this.grassColor) {
                colorType = 1;
            } else if (customColour == this.foliageColor) {
                colorType = 2;
            } else {
                if (!gotFullCC) {
                    customColour = this.tryGettingColor(state, world, pos, 0);
                    gotFullCC = true;
                }
                colorType = customColour != 0xFFFFFF && customColour != -1 ? 3 : 0;
            }
            this.colorTypes.put(state, colorType);
        } else if (colorType == 3 && !isRenderThread) {
            colorType = -1;
        }
        if ((colorType == 1 || colorType == 2) && biomeId == null) {
            if (isRenderThread) {
                biomeId = this.getBiome(world, pos, biomeRegistry);
            } else {
                colorType = -1;
            }
        }
        dest[0] = colorType;
        if (colorType == -1) {
            blockBiome = biomeId;
        } else if (colorType == 1 || colorType == 2) {
            blockBiome = biomeId;
        } else if (colorType == 3) {
            if (!gotFullCC) {
                customColour = this.tryGettingColor(state, world, pos, 0);
            }
            dest[2] = customColour;
        }
        return blockBiome;
    }

    public BiomeKey getOverlayBiomeColour(World world, BlockState state, BlockPos pos, int[] dest, BiomeKey biomeId, MutableRegistry<Biome> biomeRegistry) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        BiomeKey blockBiome = null;
        Integer cachedColorType = this.overlayColorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.func_71410_x().func_213162_bc();
        if (colorType == -1 && isRenderThread) {
            if (state.func_177230_c() == Blocks.field_150355_j) {
                colorType = 1;
            } else {
                Material material;
                customColour = this.tryGettingColor(state, world, pos, 0);
                gotFullCC = true;
                colorType = customColour != 0xFFFFFF && customColour != -1 ? ((material = state.func_185904_a()) != null && material.func_151565_r() == MaterialColor.field_151662_n && customColour == this.tryGettingColor(this.waterState, world, pos, 0) ? 1 : 2) : 0;
            }
            this.overlayColorTypes.put(state, colorType);
        } else if (colorType == 2 && !isRenderThread) {
            colorType = -1;
        }
        dest[0] = colorType;
        if (colorType == 1) {
            blockBiome = biomeId != null ? biomeId : this.getBiome(world, pos, biomeRegistry);
        } else if (colorType == 2) {
            if (!gotFullCC) {
                customColour = this.tryGettingColor(state, world, pos, 0);
            }
            dest[2] = customColour;
        }
        return blockBiome;
    }

    public void updateGrassColor() {
        this.grassColor = this.tryGettingColor(this.grassState, null, null, 0);
        this.foliageColor = this.tryGettingColor(this.oakLeavesState, null, null, 0);
        if (WorldMap.settings.debug) {
            System.out.println("Default grass colour: " + this.grassColor);
        }
    }

    private BiomeKey getBiome(World world, BlockPos pos, MutableRegistry<Biome> biomeRegistry) {
        Biome biome = world.func_226691_t_(pos);
        ResourceLocation biomeIdentifier = biomeRegistry.func_177774_c((Object)biome);
        return biomeIdentifier == null ? this.UNKNOWN_BIOME : this.biomeKeyManager.get(biomeIdentifier.toString());
    }

    private int tryGettingColor(BlockState state, World world, BlockPos pos, int tint) {
        try {
            return Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, (IBlockDisplayReader)world, pos, tint);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }
}

