/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ItemStackKey;
import org.apache.commons.lang3.mutable.MutableInt;

public class InventoryHelper {
    private InventoryHelper() {
    }

    public static boolean hasItem(IItemHandler inventory, Predicate<ItemStack> matches) {
        AtomicBoolean result = new AtomicBoolean(false);
        InventoryHelper.iterate(inventory, (slot, stack) -> {
            if (!stack.func_190926_b() && matches.test((ItemStack)stack)) {
                result.set(true);
            }
        }, result::get);
        return result.get();
    }

    public static Set<Integer> getItemSlots(IItemHandler inventory, Predicate<ItemStack> matches) {
        HashSet<Integer> slots = new HashSet<Integer>();
        InventoryHelper.iterate(inventory, (slot, stack) -> {
            if (!stack.func_190926_b() && matches.test((ItemStack)stack)) {
                slots.add((Integer)slot);
            }
        });
        return slots;
    }

    public static void copyTo(IItemHandlerModifiable handlerA, IItemHandlerModifiable handlerB) {
        int slotsA = handlerA.getSlots();
        int slotsB = handlerB.getSlots();
        for (int slot = 0; slot < slotsA && slot < slotsB; ++slot) {
            ItemStack slotStack = handlerA.getStackInSlot(slot);
            if (slotStack.func_190926_b()) continue;
            handlerB.setStackInSlot(slot, slotStack);
        }
    }

    public static List<ItemStack> insertIntoInventory(List<ItemStack> stacks, IItemHandler inventory, boolean simulate) {
        if (stacks.isEmpty()) {
            return stacks;
        }
        IItemHandler targetInventory = inventory;
        if (simulate) {
            targetInventory = InventoryHelper.cloneInventory(inventory);
        }
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            ItemStack result = InventoryHelper.insertIntoInventory(stack, targetInventory, false);
            if (result.func_190926_b()) continue;
            remaining.add(result);
        }
        return remaining;
    }

    public static IItemHandler cloneInventory(IItemHandler inventory) {
        ItemStackHandler cloned = new ItemStackHandler(inventory.getSlots());
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            cloned.insertItem(slot, inventory.getStackInSlot(slot).func_77946_l(), false);
        }
        return cloned;
    }

    public static ItemStack insertIntoInventory(ItemStack stack, IItemHandler inventory, boolean simulate) {
        ItemStack remainingStack = stack.func_77946_l();
        int slots = inventory.getSlots();
        for (int slot = 0; slot < slots && !remainingStack.func_190926_b(); ++slot) {
            remainingStack = inventory.insertItem(slot, remainingStack, simulate);
        }
        return remainingStack;
    }

    public static ItemStack extractFromInventory(Item item, int count, IItemHandler inventory, boolean simulate) {
        ItemStack ret = ItemStack.field_190927_a;
        int slots = inventory.getSlots();
        for (int slot = 0; slot < slots && ret.func_190916_E() < count; ++slot) {
            ItemStack slotStack = inventory.getStackInSlot(slot);
            if (slotStack.func_77973_b() != item || !ret.func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)ret, (ItemStack)slotStack)) continue;
            int toExtract = Math.min(slotStack.func_190916_E(), count - ret.func_190916_E());
            ItemStack extractedStack = inventory.extractItem(slot, toExtract, simulate);
            if (ret.func_190926_b()) {
                ret = extractedStack;
                continue;
            }
            ret.func_190920_e(ret.func_190916_E() + extractedStack.func_190916_E());
        }
        return ret;
    }

    public static ItemStack extractFromInventory(ItemStack stack, IItemHandler inventory, boolean simulate) {
        int extractedCount = 0;
        int slots = inventory.getSlots();
        for (int slot = 0; slot < slots && extractedCount < stack.func_190916_E(); ++slot) {
            ItemStack slotStack = inventory.getStackInSlot(slot);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotStack)) continue;
            int toExtract = Math.min(slotStack.func_190916_E(), stack.func_190916_E() - extractedCount);
            extractedCount += inventory.extractItem(slot, toExtract, simulate).func_190916_E();
        }
        if (extractedCount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = stack.func_77946_l();
        result.func_190920_e(extractedCount);
        return result;
    }

    public static boolean runPickupOnBackpack(World world, ItemStack remainingStack, IBackpackWrapper backpackWrapper, boolean simulate) {
        List<IPickupResponseUpgrade> pickupUpgrades = backpackWrapper.getUpgradeHandler().getWrappersThatImplement(IPickupResponseUpgrade.class);
        for (IPickupResponseUpgrade pickupUpgrade : pickupUpgrades) {
            ItemStack ret = pickupUpgrade.pickup(world, remainingStack, simulate);
            remainingStack.func_190920_e(ret.func_190916_E());
            if (!remainingStack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public static void iterate(IItemHandler handler, BiConsumer<Integer, ItemStack> actOn) {
        InventoryHelper.iterate(handler, actOn, () -> false);
    }

    public static void iterate(IItemHandler handler, BiConsumer<Integer, ItemStack> actOn, BooleanSupplier shouldExit) {
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            actOn.accept(slot, stack);
            if (shouldExit.getAsBoolean()) break;
        }
    }

    public static int getCountMissingInHandler(IItemHandler itemHandler, ItemStack filter, int expectedCount) {
        MutableInt missingCount = new MutableInt(expectedCount);
        InventoryHelper.iterate(itemHandler, (slot, stack) -> {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)filter)) {
                missingCount.subtract(Math.min(stack.func_190916_E(), missingCount.getValue()));
            }
        }, () -> missingCount.getValue() == 0);
        return missingCount.getValue();
    }

    public static <T> T iterate(IItemHandler handler, BiFunction<Integer, ItemStack, T> getFromSlotStack, Supplier<T> supplyDefault, Predicate<T> shouldExit) {
        T ret = supplyDefault.get();
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            ret = getFromSlotStack.apply(slot, stack);
            if (shouldExit.test(ret)) break;
        }
        return ret;
    }

    public static boolean anyItemTagMatches(Item itemA, Item itemB) {
        for (ResourceLocation tag : itemA.getTags()) {
            if (!itemB.getTags().contains(tag)) continue;
            return true;
        }
        return false;
    }

    public static void transfer(IItemHandler handlerA, IItemHandler handlerB, Consumer<Supplier<ItemStack>> onInserted) {
        int slotsA = handlerA.getSlots();
        for (int slot = 0; slot < slotsA; ++slot) {
            ItemStack slotStack = handlerA.getStackInSlot(slot);
            if (slotStack.func_190926_b()) continue;
            ItemStack resultStack = InventoryHelper.insertIntoInventory(slotStack, handlerB, true);
            int countToExtract = slotStack.func_190916_E() - resultStack.func_190916_E();
            if (countToExtract <= 0 || handlerA.extractItem(slot, countToExtract, true).func_190916_E() != countToExtract) continue;
            InventoryHelper.insertIntoInventory(handlerA.extractItem(slot, countToExtract, false), handlerB, false);
            onInserted.accept(() -> {
                ItemStack copiedStack = slotStack.func_77946_l();
                copiedStack.func_190920_e(countToExtract);
                return copiedStack;
            });
        }
    }

    public static boolean isEmpty(IItemHandler itemHandler) {
        int slots = itemHandler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            if (itemHandler.getStackInSlot(slot).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getAndRemove(IItemHandler itemHandler, int slot) {
        if (slot >= itemHandler.getSlots()) {
            return ItemStack.field_190927_a;
        }
        return itemHandler.extractItem(slot, itemHandler.getStackInSlot(slot).func_190916_E(), false);
    }

    public static void insertOrDropItem(PlayerEntity player, ItemStack stack, IItemHandler ... inventories) {
        ItemStack ret = stack;
        for (IItemHandler inventory : inventories) {
            if (!(ret = InventoryHelper.insertIntoInventory(ret, inventory, false)).func_190926_b()) continue;
            return;
        }
        if (!ret.func_190926_b()) {
            player.func_71019_a(ret, true);
        }
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(IItemHandler handler) {
        return InventoryHelper.getCompactedStacks(handler, new HashSet<Integer>());
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(IItemHandler handler, Set<Integer> ignoreSlots) {
        HashMap<ItemStackKey, Integer> ret = new HashMap<ItemStackKey, Integer>();
        InventoryHelper.iterate(handler, (slot, stack) -> {
            if (stack.func_190926_b() || ignoreSlots.contains(slot)) {
                return;
            }
            ItemStackKey itemStackKey = new ItemStackKey((ItemStack)stack);
            ret.put(itemStackKey, ret.computeIfAbsent(itemStackKey, fs -> 0) + stack.func_190916_E());
        });
        return ret;
    }

    public static List<ItemStack> getCompactedStacksSortedByCount(IItemHandler handler) {
        Map<ItemStackKey, Integer> compactedStacks = InventoryHelper.getCompactedStacks(handler);
        ArrayList<Map.Entry<ItemStackKey, Integer>> sortedList = new ArrayList<Map.Entry<ItemStackKey, Integer>>(compactedStacks.entrySet());
        sortedList.sort(InventorySorter.BY_COUNT);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        sortedList.forEach(e -> {
            ItemStack stackCopy = ((ItemStackKey)e.getKey()).getStack().func_77946_l();
            stackCopy.func_190920_e(((Integer)e.getValue()).intValue());
            ret.add(stackCopy);
        });
        return ret;
    }

    public static Set<ItemStackKey> getUniqueStacks(IItemHandler handler) {
        HashSet<ItemStackKey> uniqueStacks = new HashSet<ItemStackKey>();
        InventoryHelper.iterate(handler, (slot, stack) -> {
            if (stack.func_190926_b()) {
                return;
            }
            ItemStackKey itemStackKey = new ItemStackKey((ItemStack)stack);
            uniqueStacks.add(itemStackKey);
        });
        return uniqueStacks;
    }

    public static List<Integer> getEmptySlotsRandomized(IItemHandler inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public static void shuffleItems(List<ItemStack> stacks, int emptySlotsCount, Random rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.func_190926_b()) {
                iterator.remove();
                continue;
            }
            if (itemstack.func_190916_E() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (emptySlotsCount - stacks.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(MathHelper.func_76136_a((Random)rand, (int)0, (int)(list.size() - 1)));
            int i = MathHelper.func_76136_a((Random)rand, (int)1, (int)(itemstack2.func_190916_E() / 2));
            ItemStack itemstack1 = itemstack2.func_77979_a(i);
            if (itemstack2.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, rand);
    }
}

