/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeWrapper;

public class TankClickMessage {
    private final int upgradeSlot;

    public TankClickMessage(int upgradeSlot) {
        this.upgradeSlot = upgradeSlot;
    }

    public static void encode(TankClickMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.upgradeSlot);
    }

    public static TankClickMessage decode(PacketBuffer packetBuffer) {
        return new TankClickMessage(packetBuffer.readInt());
    }

    public static void onMessage(TankClickMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TankClickMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayerEntity sender, TankClickMessage msg) {
        if (sender == null || !(sender.field_71070_bA instanceof BackpackContainer)) {
            return;
        }
        UpgradeContainerBase<?, ?> upgradeContainer = ((BackpackContainer)sender.field_71070_bA).getUpgradeContainers().get(msg.upgradeSlot);
        if (!(upgradeContainer instanceof TankUpgradeContainer)) {
            return;
        }
        TankUpgradeContainer tankContainer = (TankUpgradeContainer)upgradeContainer;
        ItemStack cursorStack = sender.field_71071_by.func_70445_o();
        cursorStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> {
            TankUpgradeWrapper tankWrapper = (TankUpgradeWrapper)tankContainer.getUpgradeWrapper();
            FluidStack tankContents = tankWrapper.getContents();
            if (tankContents.isEmpty()) {
                TankClickMessage.drainHandler(sender, fluidHandler, tankWrapper);
            } else if (!tankWrapper.fillHandler((IFluidHandlerItem)fluidHandler, itemStackIn -> {
                sender.field_71071_by.func_70437_b(itemStackIn);
                sender.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, sender.field_71071_by.func_70445_o()));
            })) {
                TankClickMessage.drainHandler(sender, fluidHandler, tankWrapper);
            }
        });
    }

    private static void drainHandler(ServerPlayerEntity sender, IFluidHandlerItem fluidHandler, TankUpgradeWrapper tankWrapper) {
        tankWrapper.drainHandler(fluidHandler, itemStackIn -> {
            sender.field_71071_by.func_70437_b(itemStackIn);
            sender.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, sender.field_71071_by.func_70445_o()));
        });
    }
}

