/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.container.Slot;
import net.minecraft.world.World;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.BackpackWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.CompositeBackpackWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ProgressBar;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.SmeltingLogicContainer;

public class SmeltingLogicControl
extends CompositeBackpackWidget<BackpackWidget> {
    private static final TextureBlitData FURNACE_BACKGROUND = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 202), new Dimension(68, 54));
    private static final TextureBlitData COOK_PROGRESS = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(100, 239), new Dimension(22, 16));
    private static final TextureBlitData BURN_PROGRESS = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(99, 225), new Dimension(14, 14));
    private final SmeltingLogicContainer smeltingLogicContainer;

    public SmeltingLogicControl(Position position, SmeltingLogicContainer smeltingLogicContainer) {
        super(position);
        this.smeltingLogicContainer = smeltingLogicContainer;
        this.addChild(new ProgressBar(new Position(this.x + 19, this.y + 18), COOK_PROGRESS, this::getCookProgress, ProgressBar.ProgressDirection.LEFT_RIGHT));
        this.addChild(new ProgressBar(new Position(this.x + 1, this.y + 20), BURN_PROGRESS, this::getBurnProgress, ProgressBar.ProgressDirection.BOTTOM_UP));
    }

    private float getBurnProgress() {
        return this.smeltingLogicContainer.isBurning((World)Minecraft.func_71410_x().field_71441_e) ? this.getProgress(this.smeltingLogicContainer.getBurnTimeFinish(), this.smeltingLogicContainer.getBurnTimeTotal()) : 0.0f;
    }

    private float getCookProgress() {
        return this.smeltingLogicContainer.isCooking() ? this.getProgress(this.smeltingLogicContainer.getCookTimeFinish(), this.smeltingLogicContainer.getCookTimeTotal()) : 0.0f;
    }

    private float getProgress(long finishTime, int timeTotal) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return 0.0f;
        }
        return 1.0f - (float)Math.max(finishTime - world.func_82737_E(), 0L) / (float)timeTotal;
    }

    @Override
    protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        GuiHelper.blit(minecraft, matrixStack, this.x, this.y, FURNACE_BACKGROUND);
    }

    @Override
    public int getWidth() {
        return 68;
    }

    @Override
    public int getHeight() {
        return 54;
    }

    public void moveSlotsToView(int screenGuiLeft, int screenGuiTop) {
        List<Slot> smeltingSlots = this.smeltingLogicContainer.getSmeltingSlots();
        this.positionSlot(smeltingSlots.get(0), screenGuiLeft, screenGuiTop, 1, 1);
        this.positionSlot(smeltingSlots.get(2), screenGuiLeft, screenGuiTop, 47, 19);
        this.positionSlot(smeltingSlots.get(1), screenGuiLeft, screenGuiTop, 1, 37);
    }

    private void positionSlot(Slot slot, int screenGuiLeft, int screenGuiTop, int xOffset, int yOffset) {
        slot.field_75223_e = this.x - screenGuiLeft + xOffset;
        slot.field_75221_f = this.y - screenGuiTop + yOffset;
    }
}

