/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.BackpackSoundHandler;

public class PlayDiscMessage {
    private final boolean blockBackpack;
    private final UUID backpackUuid;
    private final int musicDiscItemId;
    private int entityId;
    private BlockPos pos;

    public PlayDiscMessage(UUID backpackUuid, int musicDiscItemId, BlockPos pos) {
        this.blockBackpack = true;
        this.backpackUuid = backpackUuid;
        this.musicDiscItemId = musicDiscItemId;
        this.pos = pos;
    }

    public PlayDiscMessage(UUID backpackUuid, int musicDiscItemId, int entityId) {
        this.blockBackpack = false;
        this.backpackUuid = backpackUuid;
        this.musicDiscItemId = musicDiscItemId;
        this.entityId = entityId;
    }

    public static void encode(PlayDiscMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeBoolean(msg.blockBackpack);
        packetBuffer.func_179252_a(msg.backpackUuid);
        packetBuffer.writeInt(msg.musicDiscItemId);
        if (msg.blockBackpack) {
            packetBuffer.func_179255_a(msg.pos);
        } else {
            packetBuffer.writeInt(msg.entityId);
        }
    }

    public static PlayDiscMessage decode(PacketBuffer packetBuffer) {
        if (packetBuffer.readBoolean()) {
            return new PlayDiscMessage(packetBuffer.func_179253_g(), packetBuffer.readInt(), packetBuffer.func_179259_c());
        }
        return new PlayDiscMessage(packetBuffer.func_179253_g(), packetBuffer.readInt(), packetBuffer.readInt());
    }

    public static void onMessage(PlayDiscMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PlayDiscMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(PlayDiscMessage msg) {
        Item discItem = Item.func_150899_d((int)msg.musicDiscItemId);
        if (!(discItem instanceof MusicDiscItem)) {
            return;
        }
        SoundEvent soundEvent = ((MusicDiscItem)discItem).func_185075_h();
        UUID backpackUuid = msg.backpackUuid;
        if (msg.blockBackpack) {
            BackpackSoundHandler.playBackpackSound(soundEvent, backpackUuid, msg.pos);
        } else {
            BackpackSoundHandler.playBackpackSound(soundEvent, backpackUuid, msg.entityId);
        }
    }
}

