/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;

public class InceptionInventoryHandler
implements IItemHandlerModifiable {
    private IItemHandlerModifiable combinedInventories;
    private final IItemHandlerModifiable wrappedInventoryHandler;
    private final InventoryOrder inventoryOrder;
    private final SubBackpacksHandler subBackpacksHandler;

    public InceptionInventoryHandler(IItemHandlerModifiable wrappedInventoryHandler, InventoryOrder inventoryOrder, SubBackpacksHandler subBackpacksHandler) {
        this.wrappedInventoryHandler = wrappedInventoryHandler;
        this.inventoryOrder = inventoryOrder;
        this.subBackpacksHandler = subBackpacksHandler;
        subBackpacksHandler.addRefreshListener(sbs -> this.refreshHandlerDelegate());
        this.refreshHandlerDelegate();
    }

    private void refreshHandlerDelegate() {
        ArrayList<IItemHandlerModifiable> handlers = new ArrayList<IItemHandlerModifiable>();
        if (this.inventoryOrder == InventoryOrder.MAIN_FIRST) {
            handlers.add(this.wrappedInventoryHandler);
        }
        this.subBackpacksHandler.getSubBackpacks().forEach(sbp -> handlers.add(sbp.getInventoryForInputOutput()));
        if (this.inventoryOrder == InventoryOrder.INCEPTED_FIRST) {
            handlers.add(this.wrappedInventoryHandler);
        }
        this.combinedInventories = new CombinedInvWrapper(handlers.toArray(new IItemHandlerModifiable[0]));
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.combinedInventories.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.combinedInventories.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.combinedInventories.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.combinedInventories.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.combinedInventories.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.combinedInventories.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.combinedInventories.isItemValid(slot, stack);
    }
}

