/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.internal.ForgeTransmogrifier;
import com.sk89q.worldedit.forge.internal.NBTConverter;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ForgeAdapter {
    private ForgeAdapter() {
    }

    public static com.sk89q.worldedit.world.World adapt(World world) {
        return new ForgeWorld(world);
    }

    public static Biome adapt(BiomeType biomeType) {
        return (Biome)ServerLifecycleHooks.getCurrentServer().func_244267_aX().func_243612_b(Registry.field_239720_u_).func_82594_a(new ResourceLocation(biomeType.getId()));
    }

    public static BiomeType adapt(Biome biome) {
        ResourceLocation id = ServerLifecycleHooks.getCurrentServer().func_244267_aX().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
        Objects.requireNonNull(id, "biome is not registered");
        return BiomeTypes.get(id.toString());
    }

    public static Vector3 adapt(Vector3d vector) {
        return Vector3.at(vector.field_72450_a, vector.field_72448_b, vector.field_72449_c);
    }

    public static BlockVector3 adapt(BlockPos pos) {
        return BlockVector3.at(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static Vector3d toVec3(BlockVector3 vector) {
        return new Vector3d((double)vector.getBlockX(), (double)vector.getBlockY(), (double)vector.getBlockZ());
    }

    public static Direction adapt(com.sk89q.worldedit.util.Direction face) {
        switch (face) {
            case NORTH: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case WEST: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.EAST;
            }
            case DOWN: {
                return Direction.DOWN;
            }
        }
        return Direction.UP;
    }

    public static com.sk89q.worldedit.util.Direction adaptEnumFacing(@Nullable Direction face) {
        if (face == null) {
            return null;
        }
        switch (face) {
            case NORTH: {
                return com.sk89q.worldedit.util.Direction.NORTH;
            }
            case SOUTH: {
                return com.sk89q.worldedit.util.Direction.SOUTH;
            }
            case WEST: {
                return com.sk89q.worldedit.util.Direction.WEST;
            }
            case EAST: {
                return com.sk89q.worldedit.util.Direction.EAST;
            }
            case DOWN: {
                return com.sk89q.worldedit.util.Direction.DOWN;
            }
        }
        return com.sk89q.worldedit.util.Direction.UP;
    }

    public static BlockPos toBlockPos(BlockVector3 vector) {
        return new BlockPos(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Deprecated
    public static Property<?> adaptProperty(net.minecraft.state.Property<?> property) {
        return ForgeTransmogrifier.transmogToWorldEditProperty(property);
    }

    @Deprecated
    public static Map<Property<?>, Object> adaptProperties(BlockType block, Map<net.minecraft.state.Property<?>, Comparable<?>> mcProps) {
        TreeMap props = new TreeMap(Comparator.comparing(Property::getName));
        for (Map.Entry<net.minecraft.state.Property<?>, Comparable<?>> prop : mcProps.entrySet()) {
            Object value = prop.getValue();
            if (prop.getKey() instanceof DirectionProperty) {
                value = ForgeAdapter.adaptEnumFacing((Direction)value);
            } else if (prop.getKey() instanceof EnumProperty) {
                value = ((IStringSerializable)value).func_176610_l();
            }
            props.put(block.getProperty(prop.getKey().func_177701_a()), value);
        }
        return props;
    }

    public static net.minecraft.block.BlockState adapt(BlockState blockState) {
        int blockStateId = BlockStateIdAccess.getBlockStateId(blockState);
        if (!BlockStateIdAccess.isValidInternalId(blockStateId)) {
            return ForgeTransmogrifier.transmogToMinecraft(blockState);
        }
        return Block.func_196257_b((int)blockStateId);
    }

    public static BlockState adapt(net.minecraft.block.BlockState blockState) {
        int blockStateId = Block.func_196246_j((net.minecraft.block.BlockState)blockState);
        BlockState worldEdit = BlockStateIdAccess.getBlockStateById(blockStateId);
        if (worldEdit == null) {
            return ForgeTransmogrifier.transmogToWorldEdit(blockState);
        }
        return worldEdit;
    }

    public static Block adapt(BlockType blockType) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockType.getId()));
    }

    public static BlockType adapt(Block block) {
        return BlockTypes.get(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString());
    }

    public static Item adapt(ItemType itemType) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemType.getId()));
    }

    public static ItemType adapt(Item item) {
        return ItemTypes.get(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).toString());
    }

    public static ItemStack adapt(BaseItemStack baseItemStack) {
        CompoundNBT forgeCompound = null;
        if (baseItemStack.getNbtData() != null) {
            forgeCompound = NBTConverter.toNative(baseItemStack.getNbtData());
        }
        ItemStack itemStack = new ItemStack((IItemProvider)ForgeAdapter.adapt(baseItemStack.getType()), baseItemStack.getAmount());
        itemStack.func_77982_d(forgeCompound);
        return itemStack;
    }

    public static BaseItemStack adapt(ItemStack itemStack) {
        Tag tagTag;
        CompoundTag tag = NBTConverter.fromNative(itemStack.serializeNBT());
        tag = tag.getValue().isEmpty() ? null : ((tagTag = (Tag)tag.getValue().get("tag")) instanceof CompoundTag ? (CompoundTag)tagTag : null);
        return new BaseItemStack(ForgeAdapter.adapt(itemStack.func_77973_b()), tag, itemStack.func_190916_E());
    }

    public static ForgePlayer adaptPlayer(ServerPlayerEntity player) {
        Preconditions.checkNotNull((Object)player);
        return new ForgePlayer(player);
    }
}

