/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TooltipList {
    private final List<ITextComponent> lines = new ArrayList<ITextComponent>();
    public int zOffset = 950;
    public int zOffsetItemTooltip = 0;
    public int backgroundColor = -267386864;
    public int borderColorStart = 0x505000FF;
    public int borderColorEnd = (this.borderColorStart & 0xFEFEFE) >> 1 | this.borderColorStart & 0xFF000000;

    public boolean shouldRender() {
        return !this.lines.isEmpty();
    }

    public void reset() {
        this.lines.clear();
        this.zOffset = 950;
        this.zOffsetItemTooltip = 0;
        this.backgroundColor = -267386864;
        this.borderColorStart = 0x505000FF;
        this.borderColorEnd = (this.borderColorStart & 0xFEFEFE) >> 1 | this.borderColorStart & 0xFF000000;
    }

    public void add(ITextComponent component) {
        this.lines.add(component);
    }

    public void blankLine() {
        this.add(StringTextComponent.field_240750_d_);
    }

    public void styledString(String text, Style style) {
        this.add((ITextComponent)new StringTextComponent(text).func_240703_c_(style));
    }

    public void styledString(String text, TextFormatting color) {
        this.add((ITextComponent)new StringTextComponent(text).func_240699_a_(color));
    }

    public void styledTranslate(String key, Style style, Object ... objects) {
        this.add((ITextComponent)new TranslationTextComponent(key, objects).func_240703_c_(style));
    }

    public void string(String text) {
        this.styledString(text, Style.field_240709_b_);
    }

    public void translate(String key, Object ... objects) {
        this.styledTranslate(key, Style.field_240709_b_, objects);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack mStack, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        boolean bl;
        ArrayList<IReorderingProcessor> textLines = new ArrayList<IReorderingProcessor>(this.lines.size());
        for (ITextComponent iTextComponent : this.lines) {
            textLines.add(iTextComponent.func_241878_f());
        }
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = 0;
        for (IReorderingProcessor textLine : textLines) {
            int textLineWidth = font.func_243245_a(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean bl2 = false;
        int titleLinesCount = 1;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            boolean bl3 = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            bl = true;
        }
        if (bl) {
            int wrappedTooltipWidth = 0;
            ArrayList<IReorderingProcessor> wrappedTextLines = new ArrayList<IReorderingProcessor>();
            for (int i = 0; i < this.lines.size(); ++i) {
                ITextComponent textLine = this.lines.get(i);
                List wrappedLine = font.func_238425_b_((ITextProperties)textLine, tooltipTextWidth);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (IReorderingProcessor line : wrappedLine) {
                    int lineWidth = font.func_243245_a(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        mStack.func_227860_a_();
        mStack.func_227861_a_(0.0, 0.0, (double)this.zOffset);
        Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder buffer = tesselator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, this.backgroundColor, this.backgroundColor);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, this.borderColorStart, this.borderColorEnd);
        TooltipList.drawGradientRect(mat, buffer, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, this.borderColorStart, this.borderColorEnd);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, this.borderColorStart, this.borderColorStart);
        TooltipList.drawGradientRect(mat, buffer, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, this.borderColorEnd, this.borderColorEnd);
        tesselator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)buffer);
        for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
            IReorderingProcessor line = (IReorderingProcessor)textLines.get(lineNumber);
            if (line != null) {
                font.func_238416_a_(line, (float)tooltipX, (float)tooltipY, -1, true, mat, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
            }
            if (lineNumber + 1 == titleLinesCount) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.func_228461_a_();
        mStack.func_227865_b_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawGradientRect(Matrix4f mat, BufferBuilder buffer, int left, int top, int right, int bottom, int startColor, int endColor) {
        int startAlpha = startColor >> 24 & 0xFF;
        int startRed = startColor >> 16 & 0xFF;
        int startGreen = startColor >> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endAlpha = endColor >> 24 & 0xFF;
        int endRed = endColor >> 16 & 0xFF;
        int endGreen = endColor >> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        buffer.func_227888_a_(mat, (float)right, (float)top, 0.0f).func_225586_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_227888_a_(mat, (float)left, (float)top, 0.0f).func_225586_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_227888_a_(mat, (float)left, (float)bottom, 0.0f).func_225586_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_227888_a_(mat, (float)right, (float)bottom, 0.0f).func_225586_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
    }
}

