/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integrations.ironfurnaces;

import ironfurnaces.container.BlockIronFurnaceContainerBase;
import ironfurnaces.tileentity.BlockIronFurnaceTileBase;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.reflect.FieldUtils;
import top.theillusivec4.polymorph.Polymorph;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.type.IFurnaceProvider;
import top.theillusivec4.polymorph.api.type.IPersistentSelector;
import top.theillusivec4.polymorph.common.integrations.CompatibilityModule;
import top.theillusivec4.polymorph.common.network.NetworkManager;
import top.theillusivec4.polymorph.common.network.server.SPacketHighlightRecipe;

public class IronFurnacesModule
extends CompatibilityModule {
    @Override
    public void setup() {
        PolymorphApi.getInstance().addEntityProvider(tileEntity -> {
            if (tileEntity instanceof BlockIronFurnaceTileBase) {
                return new IronFurnaceSelector((BlockIronFurnaceTileBase)tileEntity);
            }
            return null;
        }, container -> {
            if (container instanceof BlockIronFurnaceContainerBase) {
                return new IronFurnaceProvider((BlockIronFurnaceContainerBase)container);
            }
            return null;
        });
    }

    private static class IronFurnaceProvider
    implements IFurnaceProvider {
        final IInventory input;
        private final BlockIronFurnaceContainerBase container;

        public IronFurnaceProvider(BlockIronFurnaceContainerBase containerBase) {
            this.container = containerBase;
            this.input = ((Slot)containerBase.field_75151_b.get((int)0)).field_75224_c;
        }

        public IRecipeType<? extends AbstractCookingRecipe> getRecipeType() {
            if (this.input instanceof BlockIronFurnaceTileBase) {
                BlockIronFurnaceTileBase te = (BlockIronFurnaceTileBase)this.input;
                return te.recipeType;
            }
            return IRecipeType.field_222150_b;
        }

        @Override
        @Nonnull
        public Container getContainer() {
            return this.container;
        }

        @Override
        @Nonnull
        public IInventory getInventory() {
            return this.input;
        }

        @Override
        @Nonnull
        public Slot getOutputSlot() {
            return (Slot)this.container.field_75151_b.get(2);
        }

        @Override
        @Nonnull
        public List<? extends AbstractCookingRecipe> getRecipes(World world, RecipeManager recipeManager) {
            return recipeManager.func_215370_b(this.getRecipeType(), this.input, world);
        }
    }

    private static class IronFurnaceSelector
    implements IPersistentSelector {
        private final BlockIronFurnaceTileBase parent;
        private AbstractCookingRecipe selectedRecipe;
        private ItemStack lastFailedInput = ItemStack.field_190927_a;
        private String savedRecipe = "";

        public IronFurnaceSelector(BlockIronFurnaceTileBase tileEntity) {
            this.parent = tileEntity;
        }

        @Override
        public Optional<IRecipe<?>> fetchRecipe(World world) {
            Optional<IRecipe<?>> maybeRecipe;
            ItemStack input = this.parent.func_70301_a(0);
            if (input == this.lastFailedInput) {
                return Optional.empty();
            }
            if (!this.savedRecipe.isEmpty()) {
                Optional saved = world.func_199532_z().func_215367_a(new ResourceLocation(this.savedRecipe));
                if (!saved.isPresent() || !((IRecipe)saved.get()).func_77569_a((IInventory)this.parent, world)) {
                    this.savedRecipe = "";
                } else {
                    this.setSelectedRecipe((IRecipe)saved.get());
                    this.savedRecipe = "";
                    return saved;
                }
            }
            if (!(maybeRecipe = world.func_199532_z().func_199510_b().stream().filter(val -> val.func_222127_g() == this.getRecipeType()).flatMap(val -> Util.func_215081_a((Optional)this.getRecipeType().func_222148_a(val, world, (IInventory)this.parent))).min(Comparator.comparing(recipe -> recipe.func_77571_b().func_77977_a())).map(val -> {
                this.setSelectedRecipe((IRecipe<?>)val);
                return val;
            })).isPresent()) {
                this.lastFailedInput = input;
            }
            return maybeRecipe;
        }

        @Override
        public IRecipeType<? extends IRecipe<?>> getRecipeType() {
            return this.parent.recipeType;
        }

        @Nonnull
        public Optional<IRecipe<?>> getSelectedRecipe() {
            return Optional.ofNullable(this.selectedRecipe);
        }

        @Override
        public void setSavedRecipe(String recipe) {
            this.savedRecipe = recipe;
        }

        @Override
        public void setSelectedRecipe(IRecipe<?> recipe) {
            this.selectedRecipe = (AbstractCookingRecipe)recipe;
            World world = this.parent.func_145831_w();
            if (world instanceof ServerWorld) {
                try {
                    FieldUtils.writeField((Object)this.parent, (String)"curRecipe", (Object)this.selectedRecipe, (boolean)true);
                }
                catch (IllegalAccessException e) {
                    Polymorph.LOGGER.error("Error accessing curRecipe from Iron Furnaces!");
                }
                catch (IllegalArgumentException e) {
                    Polymorph.LOGGER.debug("Cannot find Iron Furnaces, skipping field override!");
                }
                ((ServerWorld)world).func_217369_A().forEach(player -> {
                    if (player.field_71070_bA instanceof BlockIronFurnaceContainerBase && ((Slot)player.field_71070_bA.field_75151_b.get((int)0)).field_75224_c == this.parent) {
                        NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketHighlightRecipe(recipe.func_199560_c().toString()));
                    }
                });
            }
        }

        @Override
        public TileEntity getParent() {
            return this.parent;
        }
    }
}

