/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.client.selector;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.polymorph.api.type.IFurnaceProvider;
import top.theillusivec4.polymorph.client.selector.RecipeSelector;
import top.theillusivec4.polymorph.client.selector.RecipeSelectorManager;
import top.theillusivec4.polymorph.common.network.NetworkManager;
import top.theillusivec4.polymorph.common.network.client.CPacketSetRecipe;

public class FurnaceRecipeSelector
extends RecipeSelector<IInventory, AbstractCookingRecipe> {
    private ItemStack lastStack = ItemStack.field_190927_a;

    public FurnaceRecipeSelector(ContainerScreen<?> screen, IFurnaceProvider provider) {
        super(screen, provider);
    }

    @Override
    public void tick() {
        super.tick();
        ItemStack currentStack = this.provider.getInventory().func_70301_a(0);
        if (!ItemStack.func_179545_c((ItemStack)currentStack, (ItemStack)this.lastStack)) {
            this.lastStack = currentStack;
            this.fetchRecipes();
        }
    }

    @Override
    public void selectRecipe(AbstractCookingRecipe recipe) {
        NetworkManager.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketSetRecipe(recipe.func_199560_c().toString()));
    }

    @Override
    public void highlightRecipe(String recipe) {
        this.recipeSelectorGui.highlightButton(recipe);
    }

    @Override
    public void setRecipes(List<AbstractCookingRecipe> recipes, World world, boolean refresh, String selected) {
        if (refresh) {
            HashSet recipeOutputs = new HashSet();
            recipes.removeIf(rec -> !recipeOutputs.add(new RecipeSelector.RecipeOutput(rec.func_77572_b(this.provider.getInventory()))));
        }
        this.recipeSelectorGui.setRecipes(recipes);
        boolean bl = this.toggleButton.field_230694_p_ = recipes.size() > 1;
        if (!recipes.isEmpty()) {
            this.highlightRecipe(selected.isEmpty() ? recipes.get(0).func_199560_c().toString() : selected);
        }
        RecipeSelectorManager.getPreferredRecipe().ifPresent(id -> {
            for (AbstractCookingRecipe recipe : recipes) {
                if (recipe.func_199560_c() != id) continue;
                RecipeSelectorManager.setPreferredRecipe(null);
                this.selectRecipe(recipe);
                return;
            }
        });
    }

    @Override
    public void setRecipes(Set<String> recipeIds, World world, boolean refresh, String selected) {
        ArrayList<AbstractCookingRecipe> recipes = new ArrayList<AbstractCookingRecipe>();
        recipeIds.forEach(id -> world.func_199532_z().func_215367_a(new ResourceLocation(id)).ifPresent(recipe -> {
            if (recipe instanceof AbstractCookingRecipe) {
                recipes.add((AbstractCookingRecipe)recipe);
            }
        }));
        recipes.sort(Comparator.comparing(recipe -> recipe.func_77571_b().func_77977_a()));
        this.setRecipes((List<AbstractCookingRecipe>)recipes, world, refresh, selected);
    }
}

