/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.actions;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.jeitweaker.JEIManager;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.tuple.Pair;

public class ActionHideRecipe
implements IUndoableAction {
    private final String category;
    private final String recipeName;

    public ActionHideRecipe(String category, String recipeName) {
        this.category = category;
        this.recipeName = recipeName;
    }

    public void apply() {
        JEIManager.HIDDEN_RECIPES.add((Pair<String, String>)Pair.of((Object)this.category, (Object)this.recipeName));
    }

    public void undo() {
        JEIManager.HIDDEN_RECIPES.removeIf(next -> ((String)next.getLeft()).equals(this.category) && ((String)next.getRight()).equals(this.recipeName));
    }

    public String describeUndo() {
        return "Undoing JEI hiding recipe: " + this.recipeName + " in category: " + this.category;
    }

    public String describe() {
        return "JEI Hiding recipe: " + this.recipeName + " in category: " + this.category;
    }

    public boolean shouldApplyOn(LogicalSide side) {
        return !CraftTweakerAPI.isServer();
    }
}

