/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.jeitweaker.actions.ActionAddInfo;
import com.blamejared.jeitweaker.actions.ActionAddItem;
import com.blamejared.jeitweaker.actions.ActionHideCategory;
import com.blamejared.jeitweaker.actions.ActionHideFluid;
import com.blamejared.jeitweaker.actions.ActionHideItem;
import com.blamejared.jeitweaker.actions.ActionHideMod;
import com.blamejared.jeitweaker.actions.ActionHideRecipe;
import com.blamejared.jeitweaker.actions.ActionHideRegex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.jei.JEI")
@ZenRegister
public class JEIManager {
    public static final List<IItemStack> HIDDEN_ITEMS = new ArrayList<IItemStack>();
    public static final List<IFluidStack> HIDDEN_FLUIDS = new ArrayList<IFluidStack>();
    public static final List<String> HIDDEN_RECIPE_CATEGORIES = new ArrayList<String>();
    public static final List<Pair<String, String>> HIDDEN_RECIPES = new ArrayList<Pair<String, String>>();
    public static final Map<IItemStack, String[]> ITEM_DESCRIPTIONS = new HashMap<IItemStack, String[]>();
    public static final Map<IFluidStack, String[]> FLUID_DESCRIPTIONS = new HashMap<IFluidStack, String[]>();
    public static final List<IItemStack> CUSTOM_ITEMS = new ArrayList<IItemStack>();

    @ZenCodeType.Method
    public static void addItem(IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new ActionAddItem(stack));
    }

    @ZenCodeType.Method
    public static void hideMod(String modid, @ZenCodeType.Optional(value="(name as string) => {return false;}") IRecipeManager.RecipeFilter exclude) {
        CraftTweakerAPI.apply((IAction)new ActionHideMod(modid, exclude));
    }

    @ZenCodeType.Method
    public static void hideRegex(String regex) {
        CraftTweakerAPI.apply((IAction)new ActionHideRegex(regex));
    }

    @ZenCodeType.Method
    public static void hideItem(IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new ActionHideItem(stack));
    }

    @ZenCodeType.Method
    public static void hideFluid(IFluidStack stack) {
        CraftTweakerAPI.apply((IAction)new ActionHideFluid(stack));
    }

    @ZenCodeType.Method
    public static void addInfo(IItemStack stack, String[] description) {
        CraftTweakerAPI.apply(new ActionAddInfo<IItemStack>(ITEM_DESCRIPTIONS, stack, description));
    }

    @ZenCodeType.Method
    public static void addInfo(IFluidStack stack, String[] description) {
        CraftTweakerAPI.apply(new ActionAddInfo<IFluidStack>(FLUID_DESCRIPTIONS, stack, description));
    }

    @ZenCodeType.Method
    public static void hideCategory(String category) {
        CraftTweakerAPI.apply((IAction)new ActionHideCategory(category));
    }

    @ZenCodeType.Method
    public static void hideRecipe(String category, String recipeName) {
        CraftTweakerAPI.apply((IAction)new ActionHideRecipe(category, recipeName));
    }
}

