/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl.managers.CTCraftingTableManager;
import com.blamejared.jeitweaker.JEIManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public class JEIAddonPlugin
implements IModPlugin {
    public static final List<ResourceLocation> JEI_CATEGORIES = new ArrayList<ResourceLocation>();

    public void registerRecipes(IRecipeRegistration registration) {
        IIngredientManager ingredientManager = registration.getIngredientManager();
        IIngredientType itemType = ingredientManager.getIngredientType(ItemStack.class);
        IIngredientType fluidType = ingredientManager.getIngredientType(FluidStack.class);
        JEIManager.ITEM_DESCRIPTIONS.forEach((key, value) -> registration.addIngredientInfo((Object)key.getInternal(), itemType, value));
        JEIManager.FLUID_DESCRIPTIONS.forEach((key, value) -> registration.addIngredientInfo((Object)key.getInternal(), fluidType, value));
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        Item[] items = (Item[])JEIManager.CUSTOM_ITEMS.stream().filter(iItemStack -> !registration.hasSubtypeInterpreter(iItemStack.getInternal())).map(iItemStack -> iItemStack.getInternal().func_77973_b()).distinct().toArray(Item[]::new);
        if (items.length == 0) {
            return;
        }
        registration.useNbtForSubtypes(items);
    }

    public void onRuntimeAvailable(IJeiRuntime iJeiRuntime) {
        IIngredientManager ingredientManager = iJeiRuntime.getIngredientManager();
        IIngredientType itemType = ingredientManager.getIngredientType(ItemStack.class);
        IIngredientType fluidType = ingredientManager.getIngredientType(FluidStack.class);
        IRecipeManager recipeManager = iJeiRuntime.getRecipeManager();
        if (!JEIManager.HIDDEN_ITEMS.isEmpty()) {
            List collect = ingredientManager.getAllIngredients(itemType).stream().filter(itemStack -> JEIManager.HIDDEN_ITEMS.stream().anyMatch(iItemStack -> iItemStack.matches((IItemStack)new MCItemStackMutable(itemStack)))).collect(Collectors.toList());
            ingredientManager.removeIngredientsAtRuntime(itemType, collect);
        }
        if (!JEIManager.HIDDEN_FLUIDS.isEmpty()) {
            ingredientManager.removeIngredientsAtRuntime(fluidType, (Collection)JEIManager.HIDDEN_FLUIDS.stream().map(IFluidStack::getInternal).collect(Collectors.toList()));
        }
        Set<ResourceLocation> changingCategories = JEIManager.HIDDEN_RECIPE_CATEGORIES.stream().map(ResourceLocation::new).collect(Collectors.toSet());
        Set<ResourceLocation> foundCategories = changingCategories.stream().filter(rl -> recipeManager.getRecipeCategories(null, true).stream().anyMatch(iRecipeCategory -> iRecipeCategory.getUid().equals(rl))).collect(Collectors.toSet());
        foundCategories.forEach(arg_0 -> ((IRecipeManager)recipeManager).hideRecipeCategory(arg_0));
        changingCategories.removeAll(foundCategories);
        changingCategories.forEach(resourceLocation -> CraftTweakerAPI.logError((String)"JEITweaker: Unable to remove JEI category with uid: `%s` as it is not a valid category!", (Object[])new Object[]{resourceLocation.toString()}));
        JEIManager.HIDDEN_RECIPES.forEach(val -> {
            ResourceLocation category = new ResourceLocation((String)val.getLeft());
            ResourceLocation recipeName = new ResourceLocation((String)val.getRight());
            Optional recipe = CTCraftingTableManager.recipeManager.func_215367_a(recipeName);
            if (recipe.isPresent()) {
                recipeManager.hideRecipe(recipe.get(), category);
            } else {
                CraftTweakerAPI.logger.throwingErr("Cannot hide recipe with ID: " + val + " as it does not exist!", (Throwable)new IllegalArgumentException("Cannot hide recipe with ID: " + val + " as it does not exist!"));
            }
        });
        if (!JEIManager.CUSTOM_ITEMS.isEmpty()) {
            iJeiRuntime.getIngredientManager().addIngredientsAtRuntime(VanillaTypes.ITEM, (Collection)JEIManager.CUSTOM_ITEMS.stream().map(IItemStack::getInternal).collect(Collectors.toList()));
        }
        JEI_CATEGORIES.clear();
        JEI_CATEGORIES.addAll(recipeManager.getRecipeCategories(null, true).stream().map(IRecipeCategory::getUid).collect(Collectors.toList()));
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jeitweaker:main");
    }
}

