/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.util;

import com.mojang.datafixers.util.Pair;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.config.Perspective;
import com.teamderpy.shouldersurfing.math.Vec2f;
import com.teamderpy.shouldersurfing.util.ShoulderState;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.optifine.shaders.Shaders;

@OnlyIn(value=Dist.CLIENT)
public class ShoulderSurfingHelper {
    private static final ResourceLocation PULL_PROPERTY = new ResourceLocation("pull");
    private static final ResourceLocation THROWING_PROPERTY = new ResourceLocation("throwing");
    private static final ResourceLocation CHARGED_PROPERTY = new ResourceLocation("charged");

    @Nullable
    public static Vec2f project2D(Vector3d position, Matrix4f modelView, Matrix4f projection) {
        Vector4f vec = new Vector4f((float)position.func_82615_a(), (float)position.func_82617_b(), (float)position.func_82616_c(), 1.0f);
        vec.func_229372_a_(modelView);
        vec.func_229372_a_(projection);
        if (vec.func_195915_d() == 0.0f) {
            return null;
        }
        vec.setW(1.0f / vec.func_195915_d() * 0.5f);
        vec.setX(vec.func_195910_a() * vec.func_195915_d() + 0.5f);
        vec.setY(vec.func_195913_b() * vec.func_195915_d() + 0.5f);
        vec.setZ(vec.func_195914_c() * vec.func_195915_d() + 0.5f);
        float x = vec.func_195910_a() * (float)Minecraft.func_71410_x().func_228018_at_().func_198105_m();
        float y = vec.func_195913_b() * (float)Minecraft.func_71410_x().func_228018_at_().func_198083_n();
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isNaN(x) || Float.isNaN(y)) {
            return null;
        }
        return new Vec2f(x, y);
    }

    public static double cameraDistance(ActiveRenderInfo info, World world, double distance) {
        Vector3d view = info.func_216785_c();
        Vector3d cameraOffset = ShoulderSurfingHelper.cameraOffset(info, distance);
        for (int i = 0; i < 8; ++i) {
            double newDistance;
            Vector3d camera;
            Vector3d offset = new Vector3d((double)(i & 1), (double)(i >> 1 & 1), (double)(i >> 2 & 1)).func_186678_a(2.0).func_178786_a(1.0, 1.0, 1.0).func_186678_a(0.1);
            Vector3d head = view.func_178787_e(offset);
            RayTraceContext context = new RayTraceContext(head, camera = head.func_178787_e(cameraOffset), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, info.func_216773_g());
            BlockRayTraceResult result = world.func_217299_a(context);
            if (result == null || !((newDistance = result.func_216347_e().func_72438_d(view)) < distance)) continue;
            distance = newDistance;
        }
        return distance;
    }

    public static RayTraceResult traceFromEyes(Entity renderView, PlayerController playerController, double playerReachOverride, float partialTicks) {
        double distanceSq;
        AxisAlignedBB aabb;
        Vector3d look;
        Vector3d end;
        EntityRayTraceResult entityTrace;
        double blockReach = Math.max((double)playerController.func_78757_d(), playerReachOverride);
        RayTraceResult blockTrace = renderView.func_213324_a(blockReach, partialTicks, false);
        Vector3d eyes = renderView.func_174824_e(partialTicks);
        double entityReach = blockReach;
        if (playerController.func_78749_i()) {
            blockReach = entityReach = Math.max(6.0, playerReachOverride);
        }
        entityReach *= entityReach;
        if (blockTrace != null) {
            entityReach = blockTrace.func_216347_e().func_72436_e(eyes);
        }
        if ((entityTrace = ProjectileHelper.func_221273_a((Entity)renderView, (Vector3d)eyes, (Vector3d)(end = eyes.func_178787_e((look = renderView.func_70676_i(1.0f)).func_186678_a(blockReach))), (AxisAlignedBB)(aabb = renderView.func_174813_aQ().func_216361_a(look.func_186678_a(blockReach)).func_72314_b(1.0, 1.0, 1.0)), entity -> !entity.func_175149_v() && entity.func_70067_L(), (double)entityReach)) != null && ((distanceSq = eyes.func_72436_e(entityTrace.func_216347_e())) < entityReach || blockTrace == null)) {
            return entityTrace;
        }
        return blockTrace;
    }

    public static Pair<Vector3d, Vector3d> shoulderSurfingLook(ActiveRenderInfo info, Entity entity, float partialTicks, double distanceSq) {
        Vector3d cameraOffset = ShoulderSurfingHelper.cameraOffset(info, ShoulderState.getCameraDistance());
        Vector3d offset = ShoulderSurfingHelper.rayTraceHeadOffset(info, cameraOffset);
        Vector3d start = entity.func_174824_e(partialTicks).func_178787_e(cameraOffset);
        Vector3d look = entity.func_70676_i(partialTicks);
        if (Config.CLIENT.limitPlayerReach() && offset.func_189985_c() < distanceSq) {
            distanceSq -= offset.func_189985_c();
        }
        double distance = (double)MathHelper.func_76133_a((double)distanceSq) + cameraOffset.func_72438_d(offset);
        Vector3d end = start.func_178787_e(look.func_186678_a(distance));
        return Pair.of((Object)start, (Object)end);
    }

    public static Vector3d cameraOffset(@Nonnull ActiveRenderInfo info, double distance) {
        double dX = (double)info.func_227997_m_().func_195899_a() * Config.CLIENT.getOffsetY() + (double)info.field_216796_h.func_195899_a() * Config.CLIENT.getOffsetX() + (double)info.func_227996_l_().func_195899_a() * -Config.CLIENT.getOffsetZ();
        double dY = (double)info.func_227997_m_().func_195900_b() * Config.CLIENT.getOffsetY() + (double)info.field_216796_h.func_195900_b() * Config.CLIENT.getOffsetX() + (double)info.func_227996_l_().func_195900_b() * -Config.CLIENT.getOffsetZ();
        double dZ = (double)info.func_227997_m_().func_195902_c() * Config.CLIENT.getOffsetY() + (double)info.field_216796_h.func_195902_c() * Config.CLIENT.getOffsetX() + (double)info.func_227996_l_().func_195902_c() * -Config.CLIENT.getOffsetZ();
        return new Vector3d(dX, dY, dZ).func_72432_b().func_186678_a(distance);
    }

    public static Vector3d rayTraceHeadOffset(@Nonnull ActiveRenderInfo info, Vector3d cameraOffset) {
        Vector3d view = new Vector3d(info.func_227996_l_());
        return ShoulderSurfingHelper.lineIntersection(Vector3d.field_186680_a, view, cameraOffset, view);
    }

    public static Vector3d lineIntersection(Vector3d planePoint, Vector3d planeNormal, Vector3d linePoint, Vector3d lineNormal) {
        double distance = (planeNormal.func_72430_b(planePoint) - planeNormal.func_72430_b(linePoint)) / planeNormal.func_72430_b(lineNormal);
        return linePoint.func_178787_e(lineNormal.func_186678_a(distance));
    }

    public static boolean isHoldingSpecialItem() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            List<? extends String> overrides = Config.CLIENT.getAdaptiveCrosshairItems();
            Item current = player.func_184607_cu().func_77973_b();
            if (ItemModelsProperties.func_239417_a_((Item)current, (ResourceLocation)PULL_PROPERTY) != null || ItemModelsProperties.func_239417_a_((Item)current, (ResourceLocation)THROWING_PROPERTY) != null) {
                return true;
            }
            if (overrides.contains(current.getRegistryName().toString())) {
                return true;
            }
            for (ItemStack item : player.func_184214_aD()) {
                if (ItemModelsProperties.func_239417_a_((Item)item.func_77973_b(), (ResourceLocation)CHARGED_PROPERTY) != null) {
                    return true;
                }
                if (!overrides.contains(item.func_77973_b().getRegistryName().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static void setPerspective(Perspective perspective) {
        Minecraft.func_71410_x().field_71474_y.func_243229_a(perspective.getPointOfView());
        ShoulderState.setEnabled(Perspective.SHOULDER_SURFING.equals((Object)perspective));
    }

    public static float getShadersResMul() {
        if (ShoulderState.doShaders()) {
            return Shaders.shaderPackLoaded ? Shaders.configRenderResMul : 1.0f;
        }
        return 1.0f;
    }
}

