/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.client.render.armor.CustomArmor;
import mekanism.client.render.armor.MekaSuitArmor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.RateLimitMultiTankGasHandler;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.capabilities.radiation.item.RadiationShieldingHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.HUDElement;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.Modules;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.gear.BaseSpecialArmorMaterial;
import mekanism.common.item.gear.ItemHazmatSuitArmor;
import mekanism.common.item.gear.ItemSpecialArmor;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemMekaSuitArmor
extends ItemSpecialArmor
implements IModuleContainerItem,
IModeItem {
    private static final Set<DamageSource> ALWAYS_SUPPORTED_SOURCES = new HashSet<DamageSource>(Arrays.asList(DamageSource.field_82728_o, DamageSource.field_76367_g, DamageSource.field_191291_g, DamageSource.field_188407_q, DamageSource.field_205132_u, DamageSource.field_76379_h, DamageSource.field_82729_p, DamageSource.field_188406_j, DamageSource.field_76377_j, DamageSource.field_190095_e, DamageSource.field_76372_a, DamageSource.field_76368_d, DamageSource.field_76371_c, DamageSource.field_180137_b, DamageSource.field_76370_b, DamageSource.field_220302_v, DamageSource.field_82727_n));
    private static final MekaSuitMaterial MEKASUIT_MATERIAL = new MekaSuitMaterial();
    private final Set<RateLimitMultiTankGasHandler.GasTankSpec> gasTankSpecs = new HashSet<RateLimitMultiTankGasHandler.GasTankSpec>();
    private float absorption;

    public ItemMekaSuitArmor(EquipmentSlotType slot, Item.Properties properties) {
        super(MEKASUIT_MATERIAL, slot, properties.func_208103_a(Rarity.EPIC).setNoRepair().func_200917_a(1));
        Modules.setSupported((Item)this, Modules.ENERGY_UNIT, Modules.RADIATION_SHIELDING_UNIT);
        if (slot == EquipmentSlotType.HEAD) {
            Modules.setSupported((Item)this, Modules.ELECTROLYTIC_BREATHING_UNIT, Modules.INHALATION_PURIFICATION_UNIT, Modules.VISION_ENHANCEMENT_UNIT, Modules.SOLAR_RECHARGING_UNIT, Modules.NUTRITIONAL_INJECTION_UNIT);
            this.gasTankSpecs.add(RateLimitMultiTankGasHandler.GasTankSpec.createFillOnly(MekanismConfig.gear.mekaSuitNutritionalTransferRate, MekanismConfig.gear.mekaSuitNutritionalMaxStorage, gas -> gas == MekanismGases.NUTRITIONAL_PASTE.get()));
            this.absorption = 0.15f;
        } else if (slot == EquipmentSlotType.CHEST) {
            Modules.setSupported((Item)this, Modules.JETPACK_UNIT, Modules.GRAVITATIONAL_MODULATING_UNIT, Modules.CHARGE_DISTRIBUTION_UNIT, Modules.DOSIMETER_UNIT);
            this.gasTankSpecs.add(RateLimitMultiTankGasHandler.GasTankSpec.createFillOnly(MekanismConfig.gear.mekaSuitJetpackTransferRate, MekanismConfig.gear.mekaSuitJetpackMaxStorage, gas -> gas == MekanismGases.HYDROGEN.get()));
            this.absorption = 0.4f;
        } else if (slot == EquipmentSlotType.LEGS) {
            Modules.setSupported((Item)this, Modules.LOCOMOTIVE_BOOSTING_UNIT);
            this.absorption = 0.3f;
        } else if (slot == EquipmentSlotType.FEET) {
            Modules.setSupported((Item)this, Modules.HYDRAULIC_PROPULSION_UNIT, Modules.MAGNETIC_ATTRACTION_UNIT);
            this.absorption = 0.15f;
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        if (MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.detailsKey)) {
            for (Module module : Modules.loadAll(stack)) {
                ILangEntry langEntry = module.getData().getLangEntry();
                if (module.getInstalledCount() > 1) {
                    TranslationTextComponent amount = MekanismLang.GENERIC_FRACTION.translate(module.getInstalledCount(), module.getData().getMaxStackSize());
                    tooltip.add((ITextComponent)MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(EnumColor.GRAY, langEntry, amount));
                    continue;
                }
                tooltip.add((ITextComponent)langEntry.translateColored(EnumColor.GRAY, new Object[0]));
            }
        } else {
            StorageUtils.addStoredEnergy(stack, tooltip, true);
            if (!this.gasTankSpecs.isEmpty()) {
                StorageUtils.addStoredGas(stack, tooltip, true, false);
            }
            tooltip.add((ITextComponent)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.func_238171_j_()));
        }
    }

    public boolean makesPiglinsNeutral(@Nonnull ItemStack stack, @Nonnull LivingEntity wearer) {
        return true;
    }

    public boolean isEnderMask(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, @Nonnull EndermanEntity enderman) {
        return this.func_185083_B_() == EquipmentSlotType.HEAD;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return StorageUtils.getEnergyDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            items.add((Object)StorageUtils.getFilledEnergyVariant(stack, this.getMaxEnergy(stack)));
        }
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        for (Module module : Modules.loadAll(stack)) {
            module.tick(player);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74768_a("HideFlags", 2);
        ItemCapabilityWrapper wrapper = new ItemCapabilityWrapper(stack, RateLimitEnergyHandler.create(() -> this.getChargeRate(stack), () -> this.getMaxEnergy(stack), BasicEnergyContainer.manualOnly, BasicEnergyContainer.alwaysTrue), RadiationShieldingHandler.create(item -> this.isModuleEnabled((ItemStack)item, Modules.RADIATION_SHIELDING_UNIT) ? ItemHazmatSuitArmor.getShieldingByArmor(this.field_77881_a) : 0.0));
        if (!this.gasTankSpecs.isEmpty()) {
            wrapper.add(RateLimitMultiTankGasHandler.create(this.gasTankSpecs));
        }
        return wrapper;
    }

    @Nonnull
    public GasStack useGas(ItemStack stack, Gas type, long amount) {
        Optional capability = stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve();
        if (capability.isPresent()) {
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            return gasHandlerItem.extractChemical(new GasStack(type, amount), Action.EXECUTE);
        }
        return GasStack.EMPTY;
    }

    public GasStack getContainedGas(ItemStack stack, Gas type) {
        Optional capability = stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve();
        if (capability.isPresent()) {
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            for (int i = 0; i < gasHandlerItem.getTanks(); ++i) {
                GasStack gasInTank = (GasStack)gasHandlerItem.getChemicalInTank(i);
                if (gasInTank.getType() != type) continue;
                return gasInTank;
            }
        }
        return GasStack.EMPTY;
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        for (Module module : Modules.loadAll(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChangeMessage);
            return;
        }
    }

    @Override
    public boolean supportsSlotType(ItemStack stack, @Nonnull EquipmentSlotType slotType) {
        return slotType == this.func_185083_B_() && Modules.loadAll(stack).stream().anyMatch(Module::handlesModeChange);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public CustomArmor getGearModel() {
        switch (this.func_185083_B_()) {
            case HEAD: {
                return MekaSuitArmor.HELMET;
            }
            case CHEST: {
                return MekaSuitArmor.BODYARMOR;
            }
            case LEGS: {
                return MekaSuitArmor.PANTS;
            }
        }
        return MekaSuitArmor.BOOTS;
    }

    private FloatingLong getMaxEnergy(ItemStack stack) {
        ModuleEnergyUnit module = Modules.load(stack, Modules.ENERGY_UNIT);
        return module != null ? module.getEnergyCapacity() : (FloatingLong)MekanismConfig.gear.mekaToolBaseEnergyCapacity.get();
    }

    private FloatingLong getChargeRate(ItemStack stack) {
        ModuleEnergyUnit module = Modules.load(stack, Modules.ENERGY_UNIT);
        return module != null ? module.getChargeRate() : (FloatingLong)MekanismConfig.gear.mekaToolBaseChargeRate.get();
    }

    public float getDamageAbsorbed(ItemStack stack, DamageSource source, float amount) {
        float toAbsorb;
        if (!ALWAYS_SUPPORTED_SOURCES.contains(source) && source.func_76363_c()) {
            return 0.0f;
        }
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null && amount > 0.0f && (toAbsorb = amount * this.absorption) > 0.0f) {
            FloatingLong usage = ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageDamage.get()).multiply(toAbsorb);
            if (usage.isZero()) {
                return this.absorption;
            }
            return this.absorption * energyContainer.extract(usage, Action.EXECUTE, AutomationType.MANUAL).divide(usage).floatValue();
        }
        return 0.0f;
    }

    public List<HUDElement> getHUDElements(ItemStack stack) {
        ArrayList<HUDElement> ret = new ArrayList<HUDElement>();
        for (Module module : Modules.loadAll(stack)) {
            if (!module.renderHUD()) continue;
            module.addHUDElements(ret);
        }
        return ret;
    }

    protected static class MekaSuitMaterial
    extends BaseSpecialArmorMaterial {
        protected MekaSuitMaterial() {
        }

        @Override
        public float func_230304_f_() {
            return 0.1f;
        }

        @Nonnull
        public String func_200897_d() {
            return "mekanism:mekasuit";
        }
    }
}

