/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedResolvableConfigValue;
import net.minecraftforge.common.ForgeConfigSpec;

public class CachedFloatingLongValue
extends CachedResolvableConfigValue<FloatingLong, String>
implements FloatingLongSupplier {
    private static final Predicate<Object> VALIDATOR = object -> CachedFloatingLongValue.tryGetValue(object) != null;
    public static final Predicate<Object> POSITIVE = object -> {
        FloatingLong value = CachedFloatingLongValue.tryGetValue(object);
        return value != null && value.greaterThan(FloatingLong.ZERO);
    };

    @Nullable
    private static FloatingLong tryGetValue(Object object) {
        if (object instanceof String) {
            try {
                return FloatingLong.parseFloatingLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private CachedFloatingLongValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<String> internal) {
        super(config, internal);
    }

    public static CachedFloatingLongValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String comment, String path, FloatingLong defaultValue) {
        return CachedFloatingLongValue.define(config, builder, comment, path, defaultValue, false);
    }

    public static CachedFloatingLongValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String comment, String path, FloatingLong defaultValue, boolean worldRestart) {
        return CachedFloatingLongValue.define(config, builder, comment, path, defaultValue, worldRestart, VALIDATOR);
    }

    public static CachedFloatingLongValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String comment, String path, FloatingLong defaultValue, Predicate<Object> validator) {
        return CachedFloatingLongValue.define(config, builder, comment, path, defaultValue, false, validator);
    }

    public static CachedFloatingLongValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String comment, String path, FloatingLong defaultValue, boolean worldRestart, Predicate<Object> validator) {
        if (worldRestart) {
            builder.worldRestart();
        }
        return new CachedFloatingLongValue(config, (ForgeConfigSpec.ConfigValue<String>)builder.comment(comment).define(path, (Object)defaultValue.toString(), validator));
    }

    @Override
    protected FloatingLong resolve(String encoded) {
        return FloatingLong.parseFloatingLong(encoded, true);
    }

    @Override
    protected String encode(FloatingLong value) {
        return value.toString();
    }
}

