/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities.sailboats;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.entities.AbstractBannerUser;
import com.talhanation.smallships.entities.TNBoatEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractCogEntity
extends AbstractBannerUser {
    public float momentum;
    public float outOfControlTicks;
    public float deltaRotation;
    public boolean field_70128_L;
    private double waterLevel;
    public boolean leftInputDown;
    public boolean rightInputDown;
    public boolean forwardInputDown;
    public boolean backInputDown;
    private float boatGlide;
    private TNBoatEntity.Status status;
    private TNBoatEntity.Status previousStatus;
    public int passengerwaittime;
    public float passengerfaktor;

    public AbstractCogEntity(EntityType<? extends AbstractCogEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void func_70071_h_() {
        --this.passengerwaittime;
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        this.outOfControlTicks = this.status != TNBoatEntity.Status.UNDER_WATER && this.status != TNBoatEntity.Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.outOfControlTicks >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        super.func_70071_h_();
        this.tickLerp();
        if (this.func_184186_bw()) {
            this.updateMotion();
            if (this.field_70170_p.field_72995_K) {
                this.controlBoat();
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        if (this.getSailState() != 0 && this.getBoatStatus().equals((Object)TNBoatEntity.Status.IN_WATER) && this.func_184179_bs() instanceof PlayerEntity && ((Boolean)SmallShipsConfig.PlaySwimmSound.get()).booleanValue()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187549_bG, this.func_184176_by(), 0.05f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof PlayerEntity);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 5 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof WaterMobEntity) && !(entity instanceof PlayerEntity)) {
                    if (this.passengerwaittime >= 0) continue;
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    @Override
    public void tickLerp() {
    }

    @Override
    public void Watersplash() {
        super.Watersplash();
        Vector3d vector3d = this.func_70676_i(0.0f);
        float f0 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.8f;
        float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.8f;
        float f0_1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 1.6f;
        float f1_1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * 1.6f;
        float f2 = 2.5f - this.field_70146_Z.nextFloat() * 0.7f;
        float f2_ = -1.3f - this.field_70146_Z.nextFloat() * 0.7f;
        float x = 0.0f;
        for (int i = 0; i < 2; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 + (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.5, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 - (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.5, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 + (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.5, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 - (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.5, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 + (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 - (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 + (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 - (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2_ + (double)f0_1, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)(f2_ - x) + (double)f1_1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2_ - (double)f0_1, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)(f2_ - x) - (double)f1_1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2_ + (double)f0_1, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)(f2_ - x) + (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2_ - (double)f0_1, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)(f2_ - x) - (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2_ + (double)f0_1, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)(f2_ - x) + (double)f1_1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2_ - (double)f0_1, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)(f2_ - x) - (double)f1_1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2_ + (double)f0_1, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)(f2_ - x) + (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2_ - (double)f0_1, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)(f2_ - x) - (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
        }
    }

    public TNBoatEntity.Status getBoatStatus() {
        TNBoatEntity.Status boatentity$status = this.getUnderwaterStatus();
        if (boatentity$status != null) {
            this.waterLevel = this.func_174813_aQ().field_72337_e;
            return boatentity$status;
        }
        if (this.checkInWater()) {
            return TNBoatEntity.Status.IN_WATER;
        }
        float f = this.getBoatGlide();
        if (f > 0.0f) {
            this.boatGlide = 0.0f;
            return TNBoatEntity.Status.ON_LAND;
        }
        return TNBoatEntity.Status.IN_AIR;
    }

    public void updateMotion() {
        double d0 = -0.04;
        double d1 = this.func_189652_ae() ? 0.0 : d0;
        double d2 = 0.0;
        double CogTurnFactor = (Double)SmallShipsConfig.CogTurnFactor.get();
        this.momentum = 1.0f;
        if (this.func_184188_bt().size() == 2) {
            this.passengerfaktor = 0.05f;
        }
        if (this.func_184188_bt().size() == 4) {
            this.passengerfaktor = 0.1f;
        }
        if (this.func_184188_bt().size() == 6) {
            this.passengerfaktor = 0.2f;
        }
        if (this.func_184188_bt().size() == 8) {
            this.passengerfaktor = 0.3f;
        }
        if (this.func_184188_bt().size() > 8) {
            this.passengerfaktor = 0.4f;
        }
        if (this.previousStatus == TNBoatEntity.Status.IN_AIR && this.status != TNBoatEntity.Status.IN_AIR && this.status != TNBoatEntity.Status.ON_LAND) {
            this.waterLevel = this.func_174813_aQ().field_72338_b + (double)this.func_213302_cg();
            this.func_70107_b(this.func_226277_ct_(), (double)(this.getWaterLevelAbove() - this.func_213302_cg()) + 0.101, this.func_226281_cx_());
            this.func_213317_d(this.func_213322_ci().func_216372_d(10.0, 0.0, 10.0));
            this.status = TNBoatEntity.Status.IN_WATER;
        } else {
            if (this.status == TNBoatEntity.Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_174813_aQ().field_72338_b + 0.1) / (double)this.func_213302_cg();
                this.momentum = 0.9f;
            } else if (this.status == TNBoatEntity.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.momentum = 0.9f;
            } else if (this.status == TNBoatEntity.Status.UNDER_WATER) {
                d2 = 0.01f;
                this.momentum = 0.45f;
            } else if (this.status == TNBoatEntity.Status.IN_AIR) {
                this.momentum = 0.9f;
            } else if (this.status == TNBoatEntity.Status.ON_LAND) {
                this.momentum = this.boatGlide * 0.001f;
                if (this.func_184179_bs() instanceof PlayerEntity) {
                    this.boatGlide /= 1.0f;
                }
            }
            Vector3d vec3d = this.func_213322_ci();
            this.func_213293_j(vec3d.field_72450_a * (double)(this.momentum - this.passengerfaktor), vec3d.field_72448_b + d1, vec3d.field_72449_c * (double)(this.momentum - this.passengerfaktor));
            this.deltaRotation = (float)((double)this.deltaRotation * ((double)(this.momentum - this.passengerfaktor) * CogTurnFactor));
            if (d2 > 0.0) {
                Vector3d vec3d1 = this.func_213322_ci();
                this.func_213293_j(vec3d1.field_72450_a, (vec3d1.field_72448_b + d2 * 0.06) * 0.75, vec3d1.field_72449_c);
            }
        }
    }

    protected void controlBoat() {
        double CogSpeedFactor = (Double)SmallShipsConfig.CogSpeedFactor.get();
        int sailstate = this.getSailState();
        if (this.func_184207_aI()) {
            float f = 0.0f;
            if (this.leftInputDown) {
                this.deltaRotation -= 1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                f += 0.005f;
            }
            this.field_70177_z += this.deltaRotation;
            if (sailstate != 0) {
                switch (sailstate) {
                    case 1: {
                        f = (float)((double)f + (double)0.04f * CogSpeedFactor * 1.0 / 4.0);
                        break;
                    }
                    case 2: {
                        f = (float)((double)f + (double)0.04f * CogSpeedFactor * 2.0 / 4.0);
                        break;
                    }
                    case 3: {
                        f = (float)((double)f + (double)0.04f * CogSpeedFactor * 3.0 / 4.0);
                        break;
                    }
                    case 4: {
                        f = (float)((double)f + (double)0.04f * CogSpeedFactor * 1.0);
                    }
                }
            }
            if (this.backInputDown) {
                f = (float)((double)f - (double)0.01f * CogSpeedFactor);
            }
            if (this.forwardInputDown) {
                f = (float)((double)f + (double)0.01f * CogSpeedFactor);
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f)));
            this.setSteerState(this.rightInputDown && !this.leftInputDown, this.leftInputDown && !this.rightInputDown);
            this.setIsForward(this.forwardInputDown);
        }
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    private TNBoatEntity.Status getUnderwaterStatus() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return TNBoatEntity.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? TNBoatEntity.Status.UNDER_WATER : null;
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        double CogHealth = (Double)SmallShipsConfig.CogHealth.get();
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            boolean flag;
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source instanceof IndirectEntityDamageSource && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(3);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || (double)this.getDamageTaken() > CogHealth) {
                this.onDestroyed(source, flag);
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
    }

    @Override
    public Vector3d func_230268_c_(LivingEntity rider) {
        return super.func_230268_c_(rider);
    }

    @Override
    public PlayerEntity getDriver() {
        return super.getDriver();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateInputs(boolean leftInputDown, boolean rightInputDown, boolean forwardInputDown, boolean backInputDown) {
        this.leftInputDown = leftInputDown;
        this.rightInputDown = rightInputDown;
        this.forwardInputDown = forwardInputDown;
        this.backInputDown = backInputDown;
    }
}

