/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.google.common.collect.Lists;
import com.talhanation.smallships.Main;
import com.talhanation.smallships.compatiblity.BiomesOPlenty;
import com.talhanation.smallships.compatiblity.Environmental;
import com.talhanation.smallships.compatiblity.LordOfTheRingsMod;
import com.talhanation.smallships.network.MessagePaddleState;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TNBoatEntity
extends Entity {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(TNBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(TNBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(TNBoatEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> BOAT_TYPE = EntityDataManager.func_187226_a(TNBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> LEFT_PADDLE = EntityDataManager.func_187226_a(TNBoatEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RIGHT_PADDLE = EntityDataManager.func_187226_a(TNBoatEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ROCKING_TICKS = EntityDataManager.func_187226_a(TNBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final float[] paddlePositions = new float[2];
    private final List<Entity> passengers = Lists.newArrayList();
    private float momentum;
    private float outOfControlTicks;
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    public boolean leftInputDown;
    public boolean rightInputDown;
    public boolean forwardInputDown;
    public boolean backInputDown;
    private double waterLevel;
    private float boatGlide;
    private Status status;
    private Status previousStatus;
    private double lastYd;
    private boolean rocking;
    private boolean downwards;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;
    private float waveAngle;
    private float prevWaveAngle;

    public TNBoatEntity(EntityType<? extends TNBoatEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public void Watersplash() {
    }

    public void onKeyPressed() {
    }

    public void onKeyLowerPressed() {
    }

    public void onKeyHigherPressed() {
    }

    public void onInvPressed(PlayerEntity player) {
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(FORWARD_DIRECTION, (Object)1);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BOAT_TYPE, (Object)Type.OAK.ordinal());
        this.field_70180_af.func_187214_a(LEFT_PADDLE, (Object)false);
        this.field_70180_af.func_187214_a(RIGHT_PADDLE, (Object)false);
        this.field_70180_af.func_187214_a(ROCKING_TICKS, (Object)0);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_241849_j(Entity entity) {
        return TNBoatEntity.canVehicleCollide(this, entity);
    }

    public static boolean canVehicleCollide(Entity entity0, Entity entity) {
        return (entity.func_241845_aY() || entity.func_70104_M()) && !entity0.func_184223_x(entity);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected Vector3d func_241839_a(Direction.Axis axis, TeleportationRepositioner.Result result) {
        return LivingEntity.func_242288_h((Vector3d)super.func_241839_a(axis, result));
    }

    public double func_70042_X() {
        return -0.1;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public void func_203002_i(boolean downwards) {
        if (!this.field_70170_p.field_72995_K) {
            this.rocking = true;
            this.downwards = downwards;
            if (this.getRockingTicks() == 0) {
                this.setRockingTicks(60);
            }
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)this.field_70146_Z.nextFloat(), this.func_226278_cu_() + 0.7, this.func_226281_cx_() + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0);
        if (this.field_70146_Z.nextInt(20) == 0) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_184181_aa(), this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat(), false);
        }
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof BoatEntity || entityIn instanceof TNBoatEntity) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    public Item getItemBoat() {
        switch (this.getBoatType()) {
            default: {
                return Items.field_151124_az;
            }
            case SPRUCE: {
                return Items.field_185150_aH;
            }
            case BIRCH: {
                return Items.field_185151_aI;
            }
            case JUNGLE: {
                return Items.field_185152_aJ;
            }
            case ACACIA: {
                return Items.field_185153_aK;
            }
            case DARK_OAK: {
                return Items.field_185154_aL;
            }
            case BOP_CHERRY: {
                return BiomesOPlenty.CHERRY_BOAT;
            }
            case BOP_DEAD: {
                return BiomesOPlenty.DEAD_BOAT;
            }
            case BOP_FIR: {
                return BiomesOPlenty.FIR_BOAT;
            }
            case BOP_HELLBARK: {
                return BiomesOPlenty.HELLBARK_BOAT;
            }
            case BOP_JACARANDA: {
                return BiomesOPlenty.JACARANDA_BOAT;
            }
            case BOP_MAGIC: {
                return BiomesOPlenty.MAGIC_BOAT;
            }
            case BOP_MAHOGANY: {
                return BiomesOPlenty.MAHOGANY_BOAT;
            }
            case BOP_PALM: {
                return BiomesOPlenty.PALM_BOAT;
            }
            case BOP_REDWOOD: {
                return BiomesOPlenty.REDWOOD_BOAT;
            }
            case BOP_UMBRAN: {
                return BiomesOPlenty.UMBRAN_BOAT;
            }
            case BOP_WILLOW: {
                return BiomesOPlenty.WILLOW_BOAT;
            }
            case LOTR_APPLE: {
                return LordOfTheRingsMod.APPLE_BOAT;
            }
            case LOTR_ASPEN: {
                return LordOfTheRingsMod.ASPEN_BOAT;
            }
            case LOTR_BEECH: {
                return LordOfTheRingsMod.BEECH_BOAT;
            }
            case LOTR_CEDAR: {
                return LordOfTheRingsMod.CEDAR_BOAT;
            }
            case LOTR_CHARRED: {
                return LordOfTheRingsMod.CHARRED_BOAT;
            }
            case LOTR_CHERRY: {
                return LordOfTheRingsMod.CHERRY_BOAT;
            }
            case LOTR_CYPRESS: {
                return LordOfTheRingsMod.CYPRESS_BOAT;
            }
            case LOTR_FIR: {
                return LordOfTheRingsMod.FIR_BOAT;
            }
            case LOTR_GREEN_OAK: {
                return LordOfTheRingsMod.GREEN_OAK_BOAT;
            }
            case LOTR_HOLLY: {
                return LordOfTheRingsMod.HOLLY_BOAT;
            }
            case LOTR_LAIRELOSSE: {
                return LordOfTheRingsMod.LAIRELOSSE_BOAT;
            }
            case LOTR_LARCH: {
                return LordOfTheRingsMod.LARCH_BOAT;
            }
            case LOTR_LEBETHRON: {
                return LordOfTheRingsMod.LEBETHRON_BOAT;
            }
            case LOTR_MALLORN: {
                return LordOfTheRingsMod.MALLORN_BOAT;
            }
            case LOTR_MAPLE: {
                return LordOfTheRingsMod.MAPLE_BOAT;
            }
            case LOTR_MIRK_OAK: {
                return LordOfTheRingsMod.MIRK_OAK_BOAT;
            }
            case LOTR_PEAR: {
                return LordOfTheRingsMod.PEAR_BOAT;
            }
            case LOTR_PINE: {
                return LordOfTheRingsMod.PINE_BOAT;
            }
            case LOTR_ROTTEN: {
                return LordOfTheRingsMod.ROTTEN_BOAT;
            }
            case ENVI_CHERRY: {
                return Environmental.CHERRY_BOAT;
            }
            case ENVI_WILLOW: {
                return Environmental.WILLOW_BOAT;
            }
            case ENVI_WISTERIA: 
        }
        return Environmental.WISTERIA_BOAT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean func_241845_aY() {
        return !this.field_70128_L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    public void func_70071_h_() {
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        this.outOfControlTicks = this.status != Status.UNDER_WATER && this.status != Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.outOfControlTicks >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        super.func_70071_h_();
        this.tickLerp();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof PlayerEntity)) {
                this.setPaddleState(false, false);
            }
            this.floatBoat();
            if (this.field_70170_p.field_72995_K) {
                this.controlBoat();
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePaddleState(this.getPaddleState(0), this.getPaddleState(1)));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.tickBubbleColumn();
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                SoundEvent soundevent;
                if (!this.func_174814_R() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.paddlePositions[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundevent = this.getPaddleSound()) != null) {
                    Vector3d vector3d = this.func_70676_i(1.0f);
                    double d0 = i == 1 ? -vector3d.field_72449_c : vector3d.field_72449_c;
                    double d1 = i == 1 ? vector3d.field_72450_a : -vector3d.field_72450_a;
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_() + d0, this.func_226278_cu_(), this.func_226281_cx_() + d1, soundevent, this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
                }
                this.paddlePositions[i] = (float)((double)this.paddlePositions[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof PlayerEntity);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof WaterMobEntity) && !(entity instanceof PlayerEntity)) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
    }

    public float getWaveFactor() {
        return this.field_70170_p.func_72896_J() ? 3.0f : 1.125f;
    }

    public float getWaveSpeed() {
        return this.field_70170_p.func_72896_J() ? 0.15f : 0.06f;
    }

    public float getWaveAngle(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevWaveAngle, (float)this.waveAngle);
    }

    private void tickBubbleColumn() {
        if (this.field_70170_p.field_72995_K) {
            int i = this.getRockingTicks();
            this.rockingIntensity = i > 0 ? (this.rockingIntensity += 0.05f) : (this.rockingIntensity -= 0.1f);
            this.rockingIntensity = MathHelper.func_76131_a((float)this.rockingIntensity, (float)0.0f, (float)1.0f);
            this.prevRockingAngle = this.rockingAngle;
            this.rockingAngle = 10.0f * (float)Math.sin(0.5f * (float)this.field_70170_p.func_82737_E()) * this.rockingIntensity;
            this.prevWaveAngle = this.waveAngle;
            this.waveAngle = (float)Math.sin(this.getWaveSpeed() * (float)this.field_70173_aa) * this.getWaveFactor();
        } else {
            int k;
            if (!this.rocking) {
                this.setRockingTicks(0);
            }
            if ((k = this.getRockingTicks()) > 0) {
                this.setRockingTicks(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setRockingTicks(0);
                    Vector3d vector3d = this.func_213322_ci();
                    if (this.downwards) {
                        this.func_213317_d(vector3d.func_72441_c(0.0, -0.7, 0.0));
                        this.func_184226_ay();
                    } else {
                        this.func_213293_j(vector3d.field_72450_a, this.func_205708_a(PlayerEntity.class) ? 2.7 : 0.6, vector3d.field_72449_c);
                    }
                }
                this.rocking = false;
            }
        }
    }

    @Nullable
    protected SoundEvent getPaddleSound() {
        switch (this.getBoatStatus()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return SoundEvents.field_193779_I;
            }
            case ON_LAND: {
                return SoundEvents.field_193778_H;
            }
        }
        return null;
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void setPaddleState(boolean left, boolean right) {
        this.field_70180_af.func_187227_b(LEFT_PADDLE, (Object)left);
        this.field_70180_af.func_187227_b(RIGHT_PADDLE, (Object)right);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRowingTime(int side, float limbSwing) {
        return this.getPaddleState(side) ? (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[side] - (double)0.3926991f), (double)this.paddlePositions[side], (double)limbSwing) : 0.0f;
    }

    private Status getBoatStatus() {
        Status boatentity$status = this.getUnderwaterStatus();
        if (boatentity$status != null) {
            this.waterLevel = this.func_174813_aQ().field_72337_e;
            return boatentity$status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = this.getBoatGlide();
        if (f > 0.0f) {
            this.boatGlide = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(l1, k1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                        f = Math.max(f, fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.func_177956_o() + f;
        }
        return l + 1;
    }

    public float getBoatGlide() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        VoxelShape voxelshape = VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutable.func_181079_c(l1, k2, i2);
                    BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
                    if (blockstate.func_177230_c() instanceof LilyPadBlock || !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196952_d((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable).func_197751_a((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                    f += blockstate.getSlipperiness((IWorldReader)this.field_70170_p, (BlockPos)blockpos$mutable, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status getUnderwaterStatus() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private void floatBoat() {
        double d0 = -0.04f;
        double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.momentum = 0.05f;
        if (this.previousStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.waterLevel = this.func_226283_e_(1.0);
            this.func_70107_b(this.func_226277_ct_(), (double)(this.getWaterLevelAbove() - this.func_213302_cg()) + 0.101, this.func_226281_cx_());
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            if (this.status == Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_226278_cu_()) / (double)this.func_213302_cg();
                this.momentum = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.momentum = 0.9f;
            } else if (this.status == Status.UNDER_WATER) {
                d2 = 0.01f;
                this.momentum = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                this.momentum = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                this.momentum = this.boatGlide;
                if (this.func_184179_bs() instanceof PlayerEntity) {
                    this.boatGlide /= 2.0f;
                }
            }
            Vector3d vector3d = this.func_213322_ci();
            this.func_213293_j(vector3d.field_72450_a * (double)this.momentum, vector3d.field_72448_b + d1, vector3d.field_72449_c * (double)this.momentum);
            this.deltaRotation *= this.momentum;
            if (d2 > 0.0) {
                Vector3d vector3d1 = this.func_213322_ci();
                this.func_213293_j(vector3d1.field_72450_a, (vector3d1.field_72448_b + d2 * 0.06153846016296973) * 0.75, vector3d1.field_72449_c);
            }
        }
    }

    private void controlBoat() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
            if (this.leftInputDown) {
                this.deltaRotation -= 1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                f += 0.005f;
            }
            this.field_70177_z += this.deltaRotation;
            if (this.forwardInputDown) {
                f += 0.04f;
            }
            if (this.backInputDown) {
                f -= 0.005f;
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f)));
            this.setPaddleState(this.rightInputDown && !this.leftInputDown || this.forwardInputDown, this.leftInputDown && !this.rightInputDown || this.forwardInputDown);
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof AnimalEntity) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vector3d vector3d = new Vector3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vector3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vector3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.clampRotation(passenger);
            if (passenger instanceof AnimalEntity && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((AnimalEntity)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected void clampRotation(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.clampRotation(entityToUpdate);
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("Type", this.getBoatType().getName());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.setBoatType(Type.getTypeFromString(compound.func_74779_i("Type")));
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        if (this.outOfControlTicks < 60.0f) {
            if (!this.field_70170_p.field_72995_K) {
                return player.func_184220_m((Entity)this) ? ActionResultType.CONSUME : ActionResultType.PASS;
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.lastYd = this.func_213322_ci().field_72448_b;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.status != Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_225503_b_(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            for (int i = 0; i < 3; ++i) {
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.func_199703_a((IItemProvider)Items.field_151055_y);
                            }
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public boolean getPaddleState(int side) {
        return (Boolean)this.field_70180_af.func_187225_a(side == 0 ? LEFT_PADDLE : RIGHT_PADDLE) != false && this.func_184179_bs() != null;
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    private void setRockingTicks(int ticks) {
        this.field_70180_af.func_187227_b(ROCKING_TICKS, (Object)ticks);
    }

    private int getRockingTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ROCKING_TICKS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRockingAngle(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevRockingAngle, (float)this.rockingAngle);
    }

    public void setForwardDirection(int forwardDirection) {
        this.field_70180_af.func_187227_b(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(FORWARD_DIRECTION);
    }

    public void setBoatType(Type boatType) {
        this.field_70180_af.func_187227_b(BOAT_TYPE, (Object)boatType.ordinal());
    }

    public Type getBoatType() {
        return Type.byId((Integer)this.field_70180_af.func_187225_a(BOAT_TYPE));
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2 && !this.func_208600_a((ITag)FluidTags.field_206959_a);
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateClientControls() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        this.updateInputs(player.field_71158_b.field_187257_e, player.field_71158_b.field_187258_f, player.field_71158_b.field_187255_c, player.field_71158_b.field_187256_d);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateInputs(boolean leftInputDown, boolean rightInputDown, boolean forwardInputDown, boolean backInputDown) {
        this.leftInputDown = leftInputDown;
        this.rightInputDown = rightInputDown;
        this.forwardInputDown = forwardInputDown;
        this.backInputDown = backInputDown;
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }

    public boolean canSwim() {
        return this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_WATER;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.func_70080_a(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYaw, (float)this.lerpPitch);
        }
    }

    public Vector3d func_230268_c_(LivingEntity rider) {
        float[] fArray;
        if (rider.func_184591_cq() == HandSide.RIGHT) {
            float[] fArray2 = new float[2];
            fArray2[0] = 90.0f;
            fArray = fArray2;
            fArray2[1] = -90.0f;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = -90.0f;
            fArray = fArray3;
            fArray3[1] = 90.0f;
        }
        for (float angle : fArray) {
            Vector3d pos = this.removeVehicle(TNBoatEntity.func_233559_a_((double)this.func_213311_cf(), (double)rider.func_213311_cf(), (float)(this.field_70177_z + angle)), rider);
            if (pos == null) continue;
            return pos;
        }
        return this.func_213303_ch();
    }

    private Vector3d removeVehicle(Vector3d dir, LivingEntity rider) {
        double x = this.func_226277_ct_() + dir.field_72450_a;
        double y = this.func_174813_aQ().field_72338_b;
        double z = this.func_226281_cx_() + dir.field_72449_c;
        double limit = this.func_174813_aQ().field_72337_e + 0.75;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        block0: for (Pose pose : rider.func_230297_ef_()) {
            blockPos.func_189532_c(x, y, z);
            while ((double)blockPos.func_177956_o() < limit) {
                double ground = this.field_70170_p.func_242403_h((BlockPos)blockPos);
                if ((double)blockPos.func_177956_o() + ground > limit) continue block0;
                if (TransportationHelper.func_234630_a_((double)ground)) {
                    Vector3d pos = new Vector3d(x, (double)blockPos.func_177956_o() + ground, z);
                    if (TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)rider, (AxisAlignedBB)rider.func_233648_f_(pose).func_191194_a(pos))) {
                        rider.func_213301_b(pose);
                        return pos;
                    }
                }
                blockPos.func_189536_c(Direction.UP);
            }
        }
        return null;
    }

    public PlayerEntity getDriver() {
        List passengers = this.func_184188_bt();
        if (passengers.size() <= 0) {
            return null;
        }
        if (passengers.get(0) instanceof PlayerEntity) {
            return (PlayerEntity)passengers.get(0);
        }
        return null;
    }

    public static enum Type {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak"),
        BOP_CHERRY("bop_cherry"),
        BOP_DEAD("bop_cherry"),
        BOP_FIR("bop_fir"),
        BOP_HELLBARK("bop_hellbark"),
        BOP_JACARANDA("bop_jacaranda"),
        BOP_MAGIC("bop_magic"),
        BOP_MAHOGANY("bop_mahogany"),
        BOP_PALM("bop_palm"),
        BOP_REDWOOD("bop_redwood"),
        BOP_UMBRAN("bop_umbran"),
        BOP_WILLOW("bop_willow"),
        LOTR_APPLE("lotr_apple"),
        LOTR_ASPEN("lotr_aspen"),
        LOTR_BEECH("lotr_beech"),
        LOTR_CEDAR("lotr_cedar"),
        LOTR_CHARRED("lotr_charred"),
        LOTR_CHERRY("lotr_cherry"),
        LOTR_CYPRESS("lotr_cypress"),
        LOTR_FIR("lotr_fir"),
        LOTR_GREEN_OAK("lotr_green_oak"),
        LOTR_HOLLY("lotr_holly"),
        LOTR_LAIRELOSSE("lotr_lairelosse"),
        LOTR_LARCH("lotr_larch"),
        LOTR_LEBETHRON("lotr_lebethron"),
        LOTR_MALLORN("lotr_mallorn"),
        LOTR_MAPLE("lotr_maple"),
        LOTR_MIRK_OAK("lotr_mirk_oak"),
        LOTR_PEAR("lotr_pear"),
        LOTR_PINE("lotr_pine"),
        LOTR_ROTTEN("lotr_rotten"),
        ENVI_CHERRY("envi_cherry"),
        ENVI_WISTERIA("envi_wisteria"),
        ENVI_WILLOW("envi_willow");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] aboatentity$type = Type.values();
            if (id < 0 || id >= aboatentity$type.length) {
                id = 0;
            }
            return aboatentity$type[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] aboatentity$type = Type.values();
            for (int i = 0; i < aboatentity$type.length; ++i) {
                if (!aboatentity$type[i].getName().equals(nameIn)) continue;
                return aboatentity$type[i];
            }
            return aboatentity$type[0];
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

