/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.registry;

import com.github.wolfshotz.wyrmroost.registry.WRBlocks;
import com.github.wolfshotz.wyrmroost.world.features.NoExposureReplacementFeature;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class WRWorld {
    public static List<Consumer<BiomeLoadingEvent>> BIOME_LISTENERS = new ArrayList<Consumer<BiomeLoadingEvent>>();

    public static void onBiomeLoad(BiomeLoadingEvent evt) {
        for (Consumer<BiomeLoadingEvent> e : BIOME_LISTENERS) {
            e.accept(evt);
        }
        BiomeGenerationSettingsBuilder generator = evt.getGeneration();
        switch (evt.getCategory()) {
            case NETHER: {
                generator.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Features.RED_GEODE_FEATURE);
                break;
            }
            case THEEND: {
                generator.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Features.PURPLE_GEODE_FEATURE);
                break;
            }
            default: {
                generator.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Features.PLATINUM_ORE_FEATURE);
                generator.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Features.BLUE_GEODE_FEATURE);
            }
        }
    }

    public static class Features {
        public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"wyrmroost");
        public static final RegistryObject<Feature<ReplaceBlockConfig>> NO_EXPOSE_REPLACE = REGISTRY.register("no_expose_replace", () -> new NoExposureReplacementFeature((Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
        public static ConfiguredFeature<?, ?> RED_GEODE_FEATURE;
        public static ConfiguredFeature<?, ?> PURPLE_GEODE_FEATURE;
        public static ConfiguredFeature<?, ?> BLUE_GEODE_FEATURE;
        public static ConfiguredFeature<?, ?> PLATINUM_ORE_FEATURE;

        public static void init() {
            RED_GEODE_FEATURE = Features.configure("ore_red_geode", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, ((Block)WRBlocks.RED_GEODE_ORE.get()).func_176223_P(), 4)).func_242733_d(128)).func_242728_a()).func_242731_b(8));
            PURPLE_GEODE_FEATURE = Features.configure("ore_purple_geode", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)NO_EXPOSE_REPLACE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150377_bs.func_176223_P(), ((Block)WRBlocks.PURPLE_GEODE_ORE.get()).func_176223_P())).func_242733_d(80)).func_242728_a()).func_242731_b(45));
            BLUE_GEODE_FEATURE = Features.configure("ore_blue_geode", (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)WRBlocks.BLUE_GEODE_ORE.get()).func_176223_P(), 10)).func_242733_d(16)).func_242728_a());
            PLATINUM_ORE_FEATURE = Features.configure("ore_platinum", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)WRBlocks.PLATINUM_ORE.get()).func_176223_P(), 9)).func_242733_d(64)).func_242728_a()).func_242731_b(20));
        }

        private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> configure(String id, ConfiguredFeature<FC, ?> cf) {
            return (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)id, cf);
        }
    }
}

