/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.registry;

import com.github.wolfshotz.wyrmroost.CommonEvents;
import com.github.wolfshotz.wyrmroost.client.ClientEvents;
import com.github.wolfshotz.wyrmroost.client.render.entity.EmptyRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.alpine.AlpineRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.butterfly.ButterflyLeviathanRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.canari.CanariWyvernRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.coin_dragon.CoinDragonRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.dragon_egg.DragonEggRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.dragon_fruit.DragonFruitDrakeRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.ldwyrm.LDWyrmRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.owdrake.OWDrakeRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.projectile.BreathWeaponRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.projectile.GeodeTippedArrowRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.rooststalker.RoostStalkerRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.royal_red.RoyalRedRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.silverglider.SilverGliderRenderer;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.AlpineEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.ButterflyLeviathanEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.CanariWyvernEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.CoinDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.DragonFruitDrakeEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.LDWyrmEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.OWDrakeEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.RoostStalkerEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.RoyalRedEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.SilverGliderEntity;
import com.github.wolfshotz.wyrmroost.entities.dragonegg.DragonEggEntity;
import com.github.wolfshotz.wyrmroost.entities.dragonegg.DragonEggProperties;
import com.github.wolfshotz.wyrmroost.entities.projectile.GeodeTippedArrowEntity;
import com.github.wolfshotz.wyrmroost.entities.projectile.WindGustEntity;
import com.github.wolfshotz.wyrmroost.entities.projectile.breath.FireBreathEntity;
import com.github.wolfshotz.wyrmroost.items.LazySpawnEggItem;
import com.github.wolfshotz.wyrmroost.registry.WRItems;
import com.github.wolfshotz.wyrmroost.registry.WRWorld;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class WREntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"wyrmroost");
    public static final RegistryObject<EntityType<LDWyrmEntity>> LESSER_DESERTWYRM = Builder.access$600(Builder.access$500(Builder.access$400(Builder.access$300(Builder.access$200(Builder.access$100(Builder.access$000("lesser_desertwyrm", LDWyrmEntity::new), LDWyrmEntity::getAttributes), EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, LDWyrmEntity::getSpawnPlacement), LDWyrmEntity::setSpawnBiomes), 14073020, 14595783), () -> LDWyrmRenderer::new), b -> b.func_220321_a(0.6f, 0.2f));
    public static final RegistryObject<EntityType<OWDrakeEntity>> OVERWORLD_DRAKE = Builder.access$600(Builder.access$500(Builder.access$800(Builder.access$400(Builder.access$300(Builder.access$700(Builder.access$100(Builder.access$000("overworld_drake", OWDrakeEntity::new), OWDrakeEntity::getAttributes)), OWDrakeEntity::setSpawnBiomes), 7898902, 4088382), new DragonEggProperties(0.65f, 1.0f, 18000)), () -> OWDrakeRenderer::new), b -> b.func_220321_a(2.376f, 2.58f));
    public static final RegistryObject<EntityType<SilverGliderEntity>> SILVER_GLIDER = Builder.access$600(Builder.access$500(Builder.access$800(Builder.access$400(Builder.access$300(Builder.access$200(Builder.access$100(Builder.access$000("silver_glider", SilverGliderEntity::new), SilverGliderEntity::getAttributes), EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SilverGliderEntity::getSpawnPlacement), SilverGliderEntity::setSpawnBiomes), 0xC8C8C8, 0xC4C4C4), new DragonEggProperties(0.4f, 0.65f, 12000)), () -> SilverGliderRenderer::new), b -> b.func_220321_a(1.5f, 0.75f));
    public static final RegistryObject<EntityType<RoostStalkerEntity>> ROOSTSTALKER = Builder.access$600(Builder.access$500(Builder.access$800(Builder.access$400(Builder.access$300(Builder.access$700(Builder.access$100(Builder.access$000("roost_stalker", RoostStalkerEntity::new), RoostStalkerEntity::getAttributes)), RoostStalkerEntity::setSpawnBiomes), 5378061, 0x959595), new DragonEggProperties(0.25f, 0.35f, 6000)), () -> RoostStalkerRenderer::new), b -> b.func_220321_a(0.65f, 0.5f));
    public static final RegistryObject<EntityType<ButterflyLeviathanEntity>> BUTTERFLY_LEVIATHAN = Builder.access$600(Builder.access$500(Builder.access$800(Builder.access$400(Builder.access$300(Builder.access$200(Builder.access$100(Builder.access$900("butterfly_leviathan", ButterflyLeviathanEntity::new, EntityClassification.WATER_CREATURE), ButterflyLeviathanEntity::getAttributes), EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, Heightmap.Type.OCEAN_FLOOR_WG, ButterflyLeviathanEntity::getSpawnPlacement), ButterflyLeviathanEntity::setSpawnBiomes), 1517628, 8023898), new DragonEggProperties(0.75f, 1.25f, 40000).setConditions(Entity::func_70090_H)), () -> ButterflyLeviathanRenderer::new), b -> b.func_220321_a(4.0f, 3.0f));
    public static final RegistryObject<EntityType<DragonFruitDrakeEntity>> DRAGON_FRUIT_DRAKE = Builder.access$600(Builder.access$500(Builder.access$800(Builder.access$400(Builder.access$300(Builder.access$200(Builder.access$100(Builder.access$000("dragon_fruit_drake", DragonFruitDrakeEntity::new), DragonFruitDrakeEntity::getAttributes), EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, DragonFruitDrakeEntity::getSpawnPlacement), DragonFruitDrakeEntity::setSpawnBiomes), 14703770, 7898902), new DragonEggProperties(0.45f, 0.75f, 9600)), () -> DragonFruitDrakeRenderer::new), b -> b.func_220321_a(1.5f, 1.9f));
    public static final RegistryObject<EntityType<CanariWyvernEntity>> CANARI_WYVERN = Builder.access$600(Builder.access$500(Builder.access$800(Builder.access$400(Builder.access$300(Builder.access$200(Builder.access$100(Builder.access$000("canari_wyvern", CanariWyvernEntity::new), CanariWyvernEntity::getAttributes), EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING, AbstractDragonEntity::canFlyerSpawn), CanariWyvernEntity::setSpawnBiomes), 1908520, 4795918), new DragonEggProperties(0.25f, 0.35f, 6000).setConditions(c -> c.field_70170_p.func_180495_p(c.func_233580_cy_().func_177977_b()).func_177230_c() == Blocks.field_196648_Z)), () -> CanariWyvernRenderer::new), b -> b.func_220321_a(0.65f, 0.85f));
    public static final RegistryObject<EntityType<RoyalRedEntity>> ROYAL_RED = Builder.access$600(Builder.access$500(Builder.access$800(Builder.access$400(Builder.access$300(Builder.access$200(Builder.access$100(Builder.access$000("royal_red", RoyalRedEntity::new), RoyalRedEntity::getAttributes), EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING, AbstractDragonEntity::canFlyerSpawn), RoyalRedEntity::setSpawnBiomes), 9046272, 0), new DragonEggProperties(0.6f, 1.0f, 72000)), () -> RoyalRedRenderer::new), b -> b.func_220321_a(3.0f, 3.9f).func_220320_c());
    public static final RegistryObject<EntityType<CoinDragonEntity>> COIN_DRAGON = Builder.access$600(Builder.access$100(Builder.access$500(Builder.access$000("coin_dragon", CoinDragonEntity::new), () -> CoinDragonRenderer::new), CoinDragonEntity::getAttributes), b -> b.func_220321_a(0.35f, 0.435f));
    public static final RegistryObject<EntityType<AlpineEntity>> ALPINE = Builder.access$600(Builder.access$500(Builder.access$800(Builder.access$400(Builder.access$300(Builder.access$200(Builder.access$100(Builder.access$000("alpine", AlpineEntity::new), AlpineEntity::getAttributes), EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING, AbstractDragonEntity::canFlyerSpawn), AlpineEntity::setSpawnBiomes), 14940415, 11069951), new DragonEggProperties(1.0f, 1.0f, 12000)), () -> AlpineRenderer::new), b -> b.func_220321_a(2.0f, 2.0f));
    public static final RegistryObject<EntityType<DragonEggEntity>> DRAGON_EGG = Builder.access$600(Builder.access$500(Builder.access$900("dragon_egg", DragonEggEntity::new, EntityClassification.MISC), () -> DragonEggRenderer::new), b -> b.func_200705_b().setCustomClientFactory(DragonEggEntity::new));
    public static final RegistryObject<EntityType<GeodeTippedArrowEntity>> GEODE_TIPPED_ARROW = Builder.access$600(Builder.access$500(Builder.access$900("geode_tipped_arrow", GeodeTippedArrowEntity::new, EntityClassification.MISC), () -> GeodeTippedArrowRenderer::new), b -> b.func_220321_a(0.5f, 0.5f).setCustomClientFactory(GeodeTippedArrowEntity::new));
    public static final RegistryObject<EntityType<FireBreathEntity>> FIRE_BREATH = Builder.access$600(Builder.access$500(Builder.access$900("fire_breath", FireBreathEntity::new, EntityClassification.MISC), () -> BreathWeaponRenderer::new), b -> b.func_220321_a(0.75f, 0.75f).func_200706_c().func_200705_b());
    public static final RegistryObject<EntityType<WindGustEntity>> WIND_GUST = Builder.access$600(Builder.access$500(Builder.access$900("wind_gust", WindGustEntity::new, EntityClassification.MISC), () -> EmptyRenderer::new), b -> b.func_220321_a(4.0f, 4.0f).func_200706_c().func_200705_b());

    public static class Attributes {
        public static final DeferredRegister<Attribute> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"wyrmroost");
        public static final RegistryObject<Attribute> PROJECTILE_DAMAGE = Attributes.ranged("generic.projectileDamage", 2.0, 0.0, 2048.0);

        private static RegistryObject<Attribute> ranged(String name, double defaultValue, double min, double max) {
            return Attributes.register(name.toLowerCase().replace('.', '_'), () -> new RangedAttribute("attribute.name." + name, defaultValue, min, max));
        }

        private static RegistryObject<Attribute> register(String name, Supplier<Attribute> attribute) {
            return REGISTRY.register(name, attribute);
        }
    }

    private static class Builder<T extends Entity> {
        private final String name;
        private final EntityType.IFactory<T> factory;
        private final EntityClassification classification;
        private RegistryObject<EntityType<T>> registered;

        public Builder(String name, EntityType.IFactory<T> factory, EntityClassification classification) {
            this.name = name;
            this.factory = factory;
            this.classification = classification;
        }

        private Builder<T> spawnEgg(int primColor, int secColor) {
            WRItems.register(this.name + "_spawn_egg", () -> new LazySpawnEggItem(() -> this.registered.get(), primColor, secColor));
            return this;
        }

        private Builder<T> renderer(Supplier<IRenderFactory<T>> renderFactory) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.lambda$null$2((Supplier)renderFactory));
            return this;
        }

        private Builder<T> attributes(Supplier<AttributeModifierMap.MutableAttribute> map) {
            try {
                CommonEvents.CALLBACKS.add(() -> GlobalEntityTypeAttributes.put((EntityType)((EntityType)this.registered.get()), (AttributeModifierMap)((AttributeModifierMap.MutableAttribute)map.get()).func_233813_a_()));
            }
            catch (ClassCastException e) {
                throw new ClassCastException("Entity Attributes cannot be Applied to non-living! Erroring Entity: " + this.name);
            }
            return this;
        }

        private <F extends MobEntity> Builder<T> spawnPlacement(EntitySpawnPlacementRegistry.PlacementType type, Heightmap.Type height, EntitySpawnPlacementRegistry.IPlacementPredicate<F> predicate) {
            try {
                CommonEvents.CALLBACKS.add(() -> EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)this.registered.get()), (EntitySpawnPlacementRegistry.PlacementType)type, (Heightmap.Type)height, (EntitySpawnPlacementRegistry.IPlacementPredicate)predicate));
            }
            catch (ClassCastException e) {
                throw new ClassCastException("Entity Spawn Placement cannot be applied to non-mob! Erroring Entity: " + this.name);
            }
            return this;
        }

        private Builder<T> spawnPlacement() {
            return this.spawnPlacement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        }

        private Builder<T> spawnBiomes(Consumer<BiomeLoadingEvent> consumer) {
            WRWorld.BIOME_LISTENERS.add(consumer);
            return this;
        }

        private Builder<T> dragonEgg(DragonEggProperties props) {
            CommonEvents.CALLBACKS.add(() -> DragonEggProperties.MAP.put((EntityType<?>)this.registered.get(), props));
            return this;
        }

        private RegistryObject<EntityType<T>> build(Consumer<EntityType.Builder<T>> consumer) {
            EntityType.Builder builder = EntityType.Builder.func_220322_a(this.factory, (EntityClassification)this.classification);
            consumer.accept(builder);
            this.registered = REGISTRY.register(this.name, () -> builder.func_206830_a("wyrmroost:" + this.name));
            return this.registered;
        }

        private static <T extends Entity> Builder<T> creature(String name, EntityType.IFactory<T> factory) {
            return new Builder<T>(name, factory, EntityClassification.CREATURE);
        }

        private static <T extends Entity> Builder<T> withClassification(String name, EntityType.IFactory<T> factory, EntityClassification classification) {
            return new Builder<T>(name, factory, classification);
        }

        private /* synthetic */ void lambda$null$2(Supplier renderFactory) {
            ClientEvents.CALLBACKS.add(() -> this.lambda$null$1((Supplier)renderFactory));
        }

        private /* synthetic */ void lambda$null$1(Supplier renderFactory) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)this.registered.get()), (IRenderFactory)((IRenderFactory)renderFactory.get()));
        }

        static /* synthetic */ Builder access$000(String x0, EntityType.IFactory x1) {
            return Builder.creature(x0, x1);
        }

        static /* synthetic */ Builder access$100(Builder x0, Supplier x1) {
            return x0.attributes(x1);
        }

        static /* synthetic */ Builder access$200(Builder x0, EntitySpawnPlacementRegistry.PlacementType x1, Heightmap.Type x2, EntitySpawnPlacementRegistry.IPlacementPredicate x3) {
            return x0.spawnPlacement(x1, x2, x3);
        }

        static /* synthetic */ Builder access$300(Builder x0, Consumer x1) {
            return x0.spawnBiomes(x1);
        }

        static /* synthetic */ Builder access$400(Builder x0, int x1, int x2) {
            return x0.spawnEgg(x1, x2);
        }

        static /* synthetic */ Builder access$500(Builder x0, Supplier x1) {
            return x0.renderer(x1);
        }

        static /* synthetic */ RegistryObject access$600(Builder x0, Consumer x1) {
            return x0.build(x1);
        }

        static /* synthetic */ Builder access$700(Builder x0) {
            return x0.spawnPlacement();
        }

        static /* synthetic */ Builder access$800(Builder x0, DragonEggProperties x1) {
            return x0.dragonEgg(x1);
        }

        static /* synthetic */ Builder access$900(String x0, EntityType.IFactory x1, EntityClassification x2) {
            return Builder.withClassification(x0, x1, x2);
        }
    }
}

