/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.items.base;

import com.github.wolfshotz.wyrmroost.items.base.ArmorMaterials;
import com.github.wolfshotz.wyrmroost.registry.WRItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ArmorBase
extends ArmorItem {
    public ArmorBase(ArmorMaterials material, EquipmentSlotType equipType) {
        super((IArmorMaterial)material, equipType, WRItems.builder().func_208103_a(material.getRarity()));
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        int layer = slot == EquipmentSlotType.LEGS ? 2 : 1;
        return "wyrmroost:textures/models/armor/" + this.field_200882_e.func_200897_d() + "_layer_" + layer + ".png";
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> lines, ITooltipFlag flags) {
        super.func_77624_a(stack, world, lines, flags);
        lines.add((ITextComponent)new TranslationTextComponent("item.wyrmroost.armors.set", new Object[]{new TranslationTextComponent("item.wyrmroost.armors." + this.field_200882_e.func_200897_d()).func_240699_a_(((ArmorMaterials)this.field_200882_e).getRarity().field_77937_e)}));
        if (this.hasDescription()) {
            lines.add((ITextComponent)new StringTextComponent(""));
            lines.add((ITextComponent)new TranslationTextComponent(String.format("item.wyrmroost.armors.%s.desc", this.field_200882_e.func_200897_d().toLowerCase())));
        }
    }

    protected boolean hasDescription() {
        return false;
    }

    public void applyFullSetBonus(LivingEntity entity, boolean hasFullSet) {
    }

    public static boolean hasFullSet(LivingEntity entity) {
        Item prev = null;
        for (ItemStack itemStack : entity.func_184193_aE()) {
            Item item = itemStack.func_77973_b();
            if (prev == null || item.getClass() == prev.getClass()) {
                prev = item;
                continue;
            }
            return false;
        }
        return true;
    }
}

