/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.items;

import com.github.wolfshotz.wyrmroost.client.render.FogWraithTailsStackRenderer;
import com.github.wolfshotz.wyrmroost.client.render.RenderHelper;
import com.github.wolfshotz.wyrmroost.registry.WRItems;
import com.github.wolfshotz.wyrmroost.util.TickFloat;
import com.github.wolfshotz.wyrmroost.util.animation.Animation;
import com.github.wolfshotz.wyrmroost.util.animation.IAnimatable;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FogWraithTailsItem
extends Item {
    private static final ImmutableSet<Enchantment> ENCHANTMENTS = ImmutableSet.of((Object)Enchantments.field_185302_k, (Object)Enchantments.field_77334_n, (Object)Enchantments.field_180312_n, (Object)Enchantments.field_180313_o, (Object)Enchantments.field_185303_l, (Object)Enchantments.field_185304_p, (Object[])new Enchantment[0]);

    public FogWraithTailsItem() {
        super(WRItems.builder().func_200917_a(1).setISTER(() -> FogWraithTailsStackRenderer::new));
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entity, int timeLeft) {
        timeLeft = stack.func_77988_m() - timeLeft;
        Capability cap = FogWraithTailsItem.getCapability(stack);
        if (cap.noActiveAnimation()) {
            if (timeLeft > 5) {
                cap.setAnimation(FogWraithTailsStackRenderer.GRAPPLE_ANIMATION);
                entity.field_70177_z = entity.field_70759_as;
            } else {
                cap.setAnimation(FogWraithTailsStackRenderer.TAIL_SWIPE_ANIMATION);
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        Capability cap = FogWraithTailsItem.getCapability(stack);
        cap.updateAnimations();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        Animation animation = cap.getAnimation();
        int tick = cap.getAnimationTick();
        boolean flag = ((LivingEntity)entity).func_184607_cu() == stack || !cap.noActiveAnimation();
        cap.transition.add(flag ? 0.1f : -0.1f);
        if (animation == FogWraithTailsStackRenderer.GRAPPLE_ANIMATION && (tick == 10 || tick == 4)) {
            Vector3d direction;
            Vector3d end;
            Vector3d position = entity.func_174824_e(1.0f);
            BlockRayTraceResult rtr = world.func_217299_a(new RayTraceContext(position, end = position.func_178787_e((direction = entity.func_70040_Z()).func_216372_d(10.0, 10.0, 10.0)), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, null));
            if (rtr.func_216346_c() != RayTraceResult.Type.MISS) {
                BlockPos pos = rtr.func_216350_a();
                if (tick == 10) {
                    Vector3d motion = entity.func_213303_ch().func_178788_d(Vector3d.func_237491_b_((Vector3i)pos));
                    double y = Math.sqrt(motion.func_72433_c());
                    entity.func_213317_d(motion.func_216372_d(-0.4, -0.2, -0.4).func_72441_c(0.0, y * 0.2, 0.0));
                } else if (world.field_72995_K) {
                    BlockState state = world.func_180495_p(pos);
                    pos = pos.func_177972_a(rtr.func_216354_b());
                    for (int i = 0; i < 30; ++i) {
                        world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                    }
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), state.func_215695_r().func_185845_c(), SoundCategory.BLOCKS, state.func_215695_r().func_185843_a(), state.func_215695_r().func_185847_b(), false);
                }
            }
        } else if (entity instanceof PlayerEntity && animation == FogWraithTailsStackRenderer.TAIL_SWIPE_ANIMATION && (tick == 2 || tick == 6)) {
            AxisAlignedBB aabb = entity.func_174813_aQ().func_186662_g(1.0).func_191194_a(entity.func_70040_Z().func_216372_d(1.7, (double)0.7f, 1.7));
            RenderHelper.DebugBox.INSTANCE.queue(aabb, 100);
            boolean playHitSound = false;
            for (Entity attacking : world.func_175674_a(entity, aabb, e -> e instanceof LivingEntity && !e.func_184191_r(entity))) {
                playHitSound |= FogWraithTailsItem.attackEntity((LivingEntity)((PlayerEntity)entity), (LivingEntity)attacking, 8.0f);
            }
            world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), playHitSound ? SoundEvents.field_187727_dV : SoundEvents.field_187733_dX, entity.func_184176_by(), 1.0f, 1.0f);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184598_c(handIn);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return ENCHANTMENTS.contains((Object)enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 15;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new Capability();
    }

    public static Capability getCapability(ItemStack stack) {
        return (Capability)stack.getCapability(IAnimatable.CapImpl.CAPABILITY).orElseThrow(NullPointerException::new);
    }

    private static boolean attackEntity(LivingEntity attacker, LivingEntity attacking, float damage) {
        boolean flag;
        float knockback = (float)EnchantmentHelper.func_77501_a((LivingEntity)attacker) + 1.0f;
        damage += EnchantmentHelper.func_152377_a((ItemStack)attacker.func_184614_ca(), (CreatureAttribute)attacking.func_70668_bt());
        int fire = EnchantmentHelper.func_90036_a((LivingEntity)attacker);
        if (fire > 0) {
            attacking.func_70015_d(fire * 4);
        }
        if (flag = attacking.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker), damage)) {
            attacking.func_233627_a_(knockback, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * (float)Math.PI / 180.0f))));
            attacker.func_213317_d(attacker.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            attacker.func_174815_a(attacker, (Entity)attacking);
            attacker.func_130011_c((Entity)attacking);
        }
        return flag;
    }

    public static class Capability
    extends IAnimatable.CapImpl
    implements ICapabilityProvider {
        public final TickFloat transition = new TickFloat().setLimit(0.0f, 1.0f);
        private final LazyOptional<IAnimatable> holder = LazyOptional.of(() -> this);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull net.minecraftforge.common.capabilities.Capability<T> cap, @Nullable Direction side) {
            return IAnimatable.CapImpl.CAPABILITY.orEmpty(cap, this.holder);
        }
    }
}

