/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.items;

import com.github.wolfshotz.wyrmroost.client.ClientEvents;
import com.github.wolfshotz.wyrmroost.client.render.DragonEggStackRenderer;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.dragonegg.DragonEggEntity;
import com.github.wolfshotz.wyrmroost.entities.dragonegg.DragonEggProperties;
import com.github.wolfshotz.wyrmroost.registry.WRItems;
import com.github.wolfshotz.wyrmroost.util.ModUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DragonEggItem
extends Item {
    public DragonEggItem() {
        super(WRItems.builder().func_200917_a(1).setISTER(() -> DragonEggStackRenderer::new));
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (!player.func_184812_l_()) {
            return false;
        }
        if (!entity.func_70089_S()) {
            return false;
        }
        if (!(entity instanceof AbstractDragonEntity)) {
            return false;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("DragonType", EntityType.func_200718_a((EntityType)entity.func_200600_R()).toString());
        nbt.func_74768_a("HatchTime", DragonEggProperties.MAP.get(entity.func_200600_R()).getHatchTime());
        stack.func_77982_d(nbt);
        player.func_146105_b(this.func_200295_i(stack), true);
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        if (player.func_225608_bj_()) {
            return super.func_195939_a(ctx);
        }
        World world = ctx.func_195991_k();
        CompoundNBT tag = ctx.func_195996_i().func_77978_p();
        BlockPos pos = ctx.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        if (tag == null || !tag.func_74764_b("DragonType")) {
            return ActionResultType.PASS;
        }
        if (!state.func_196952_d((IBlockReader)world, pos).func_197766_b()) {
            pos = pos.func_177972_a(ctx.func_196000_l());
        }
        if (!world.func_217357_a(DragonEggEntity.class, new AxisAlignedBB(pos)).isEmpty()) {
            return ActionResultType.FAIL;
        }
        DragonEggEntity eggEntity = new DragonEggEntity(ModUtils.getEntityTypeByKey(tag.func_74779_i("DragonType")), tag.func_74762_e("HatchTime"), world);
        eggEntity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)eggEntity);
        }
        if (!player.func_184812_l_()) {
            player.func_184611_a(ctx.func_221531_n(), ItemStack.field_190927_a);
        }
        return ActionResultType.SUCCESS;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || tag.isEmpty()) {
            return super.func_200295_i(stack);
        }
        Optional type = EntityType.func_220327_a((String)tag.func_74779_i("DragonType"));
        if (type.isPresent()) {
            String dragonTranslation = ((EntityType)type.get()).func_212546_e().getString();
            return new TranslationTextComponent(dragonTranslation + " ").func_230529_a_((ITextComponent)new TranslationTextComponent(this.func_77658_a()));
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        PlayerEntity player;
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("HatchTime")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.wyrmroost.egg.tooltip", new Object[]{tag.func_74762_e("HatchTime") / 1200}).func_240699_a_(TextFormatting.AQUA));
        }
        if ((player = ClientEvents.getPlayer()) != null && player.func_184812_l_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.wyrmroost.egg.creativetooltip").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public static ItemStack getStack(EntityType<?> type) {
        return DragonEggItem.getStack(type, DragonEggProperties.MAP.get(type).getHatchTime());
    }

    public static ItemStack getStack(EntityType<?> type, int hatchTime) {
        ItemStack stack = new ItemStack((IItemProvider)WRItems.DRAGON_EGG.get());
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("DragonType", EntityType.func_200718_a(type).toString());
        tag.func_74768_a("HatchTime", hatchTime);
        stack.func_77982_d(tag);
        return stack;
    }
}

