/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.dragon;

import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.util.EntityDataEntry;
import com.github.wolfshotz.wyrmroost.registry.WREntities;
import com.github.wolfshotz.wyrmroost.util.TickFloat;
import com.github.wolfshotz.wyrmroost.util.animation.Animation;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class OrbwyrmEntity
extends AbstractDragonEntity {
    public static final Animation HISS_ANIMATION = new Animation(67);
    public static final Animation BITE_ANIMATION = new Animation(19);
    public static final Animation SHOOT_SILK_ANIMATION = new Animation(100);
    public final TickFloat sitTimer = new TickFloat().setLimit(0.0f, 1.0f);

    public OrbwyrmEntity(EntityType<? extends AbstractDragonEntity> dragon, World world) {
        super(dragon, world);
        this.registerDataEntry("Gender", EntityDataEntry.BOOLEAN, GENDER, false);
        this.registerDataEntry("Sleeping", EntityDataEntry.BOOLEAN, SLEEPING, false);
        this.registerDataEntry("Variant", EntityDataEntry.INTEGER, VARIANT, 0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.sitTimer.add(this.func_233684_eK_() || this.func_70608_bn() ? 0.065f : -0.065f);
        this.sleepTimer.add(this.func_70608_bn() ? 0.1f : -0.1f);
        Animation animation = this.getAnimation();
        int tick = this.getAnimationTick();
        if (animation == HISS_ANIMATION || animation == BITE_ANIMATION) {
            // empty if block
        }
    }

    @Override
    public void recievePassengerKeybind(int key, int mods, boolean pressed) {
        if (key == 1 && pressed && this.noActiveAnimation()) {
            if ((mods & 2) != 0) {
                this.setAnimation(HISS_ANIMATION);
            } else {
                this.setAnimation(BITE_ANIMATION);
            }
        }
    }

    @Override
    public int determineVariant() {
        if (this.func_70681_au().nextDouble() < 0.01) {
            return -1;
        }
        return this.func_70681_au().nextInt(3);
    }

    public void func_213295_a(BlockState state, Vector3d multiplier) {
        if (!state.func_203425_a(Blocks.field_196553_aF)) {
            super.func_213295_a(state, multiplier);
        }
    }

    @Override
    public Vector3d getPassengerPosOffset(Entity entity, int index) {
        if (this.getAnimation() == HISS_ANIMATION && index == 0) {
            return new Vector3d(0.0, this.func_70042_X() + 0.5, -0.85);
        }
        return super.getPassengerPosOffset(entity, index);
    }

    @Override
    protected boolean func_184228_n(Entity entity) {
        return !this.func_70631_g_() && this.func_70909_n();
    }

    @Override
    public boolean canFly() {
        return false;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s().func_221467_c();
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.965f;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public float func_213355_cm() {
        return this.func_70631_g_() ? 0.5f : (this.isMale() ? 0.75f : 1.0f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{HISS_ANIMATION, BITE_ANIMATION, SHOOT_SILK_ANIMATION};
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.4).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_((Attribute)WREntities.Attributes.PROJECTILE_DAMAGE.get(), 1.0);
    }
}

