/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.containers;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.DragonInvHandler;
import com.github.wolfshotz.wyrmroost.registry.WRIO;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DragonInvContainer
extends Container {
    public static final int MAX_PLAYER_SLOTS = 36;
    public final DragonInvHandler inventory;
    public final PlayerInventory playerInv;

    public DragonInvContainer(DragonInvHandler inv, PlayerInventory playerInv, int windowID) {
        super((ContainerType)WRIO.DRAGON_INVENTORY.get(), windowID);
        this.inventory = inv;
        this.playerInv = playerInv;
        inv.dragon.addContainerInfo(this);
    }

    public Slot func_75146_a(Slot slotIn) {
        return super.func_75146_a(slotIn);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.inventory.dragon.func_70902_q() == playerIn;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack transferring = slot.func_75211_c();
            if (index < 36 && this.func_75135_a(transferring, 36, this.field_75151_b.size(), false) || index >= 36 && this.func_75135_a(transferring, 0, 36, true)) {
                if (transferring.func_190926_b()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                return transferring.func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    public void makeSlots(int firstIndex, int firstX, int firstY, int length, int height, ISlotArea slot) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < length; ++x) {
                if (this.inventory.getSlots() <= firstIndex) {
                    Wyrmroost.LOG.error("TOO MANY SLOTS! ABORTING THE REST! Ended Index: {}, Supposed to be: {}", (Object)firstIndex, (Object)(length * height));
                    return;
                }
                this.func_75146_a(slot.get(firstIndex++, firstX + x * 18, firstY + y * 18));
            }
        }
    }

    public void makeSlots(IInventory inventory, int index, int initialX, int initialY, int length, int height) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < length; ++x) {
                if (inventory.func_70302_i_() <= index) {
                    Wyrmroost.LOG.error("TOO MANY SLOTS! ABORTING THE REST!");
                    return;
                }
                this.func_75146_a(new Slot(inventory, index++, initialX + x * 18, initialY + y * 18));
            }
        }
    }

    public void makePlayerSlots(PlayerInventory playerInv, int initialX, int initialY) {
        this.makeSlots((IInventory)playerInv, 9, initialX, initialY, 9, 3);
        this.makeSlots((IInventory)playerInv, 0, initialX, initialY + 58, 9, 1);
    }

    public static INamedContainerProvider getProvider(final AbstractDragonEntity dragon) {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Dragon Inventory");
            }

            public Container createMenu(int id, PlayerInventory playersInv, PlayerEntity player) {
                return new DragonInvContainer(dragon.getInvHandler(), playersInv, id);
            }
        };
    }

    public static interface ISlotArea {
        public Slot get(int var1, int var2, int var3);
    }
}

