/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost;

import com.github.wolfshotz.wyrmroost.CommonEvents;
import com.github.wolfshotz.wyrmroost.WRConfig;
import com.github.wolfshotz.wyrmroost.client.ClientEvents;
import com.github.wolfshotz.wyrmroost.network.packets.AddPassengerPacket;
import com.github.wolfshotz.wyrmroost.network.packets.AnimationPacket;
import com.github.wolfshotz.wyrmroost.network.packets.KeybindPacket;
import com.github.wolfshotz.wyrmroost.network.packets.RenameEntityPacket;
import com.github.wolfshotz.wyrmroost.network.packets.SGGlidePacket;
import com.github.wolfshotz.wyrmroost.network.packets.StaffActionPacket;
import com.github.wolfshotz.wyrmroost.registry.WRBlocks;
import com.github.wolfshotz.wyrmroost.registry.WREntities;
import com.github.wolfshotz.wyrmroost.registry.WRIO;
import com.github.wolfshotz.wyrmroost.registry.WRItems;
import com.github.wolfshotz.wyrmroost.registry.WRSounds;
import com.github.wolfshotz.wyrmroost.registry.WRWorld;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="wyrmroost")
public class Wyrmroost {
    public static final String MOD_ID = "wyrmroost";
    public static final Logger LOG = LogManager.getLogger((String)"wyrmroost");
    public static final ItemGroup ITEM_GROUP = new WRItemGroup();
    public static final SimpleChannel NETWORK = Wyrmroost.buildChannel();

    public Wyrmroost() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CommonEvents.load();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::load);
        WREntities.REGISTRY.register(bus);
        WREntities.Attributes.REGISTRY.register(bus);
        WRBlocks.REGISTRY.register(bus);
        WRItems.REGISTRY.register(bus);
        WRIO.REGISTRY.register(bus);
        WRSounds.REGISTRY.register(bus);
        WRWorld.Features.REGISTRY.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, WRConfig.Common.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, WRConfig.Client.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, WRConfig.Server.SPEC);
    }

    private static SimpleChannel buildChannel() {
        String PROTOCOL_VERSION = "1.0";
        SimpleChannel network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)Wyrmroost.rl("network")).clientAcceptedVersions("1.0"::equals).serverAcceptedVersions("1.0"::equals).networkProtocolVersion(() -> "1.0").simpleChannel();
        int index = 1;
        network.messageBuilder(AnimationPacket.class, index, NetworkDirection.PLAY_TO_CLIENT).encoder(AnimationPacket::encode).decoder(AnimationPacket::new).consumer(AnimationPacket::handle).add();
        network.messageBuilder(KeybindPacket.class, ++index, NetworkDirection.PLAY_TO_SERVER).encoder(KeybindPacket::encode).decoder(KeybindPacket::new).consumer(KeybindPacket::handle).add();
        network.messageBuilder(RenameEntityPacket.class, ++index, NetworkDirection.PLAY_TO_SERVER).encoder(RenameEntityPacket::encode).decoder(RenameEntityPacket::new).consumer(RenameEntityPacket::handle).add();
        network.messageBuilder(StaffActionPacket.class, ++index, NetworkDirection.PLAY_TO_SERVER).encoder(StaffActionPacket::encode).decoder(StaffActionPacket::new).consumer(StaffActionPacket::handle).add();
        network.messageBuilder(SGGlidePacket.class, ++index, NetworkDirection.PLAY_TO_SERVER).encoder(SGGlidePacket::encode).decoder(SGGlidePacket::new).consumer(SGGlidePacket::handle).add();
        network.messageBuilder(AddPassengerPacket.class, ++index, NetworkDirection.PLAY_TO_CLIENT).encoder(AddPassengerPacket::encode).decoder(AddPassengerPacket::new).consumer(AddPassengerPacket::handle).add();
        return network;
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static class WRItemGroup
    extends ItemGroup {
        public WRItemGroup() {
            super(Wyrmroost.MOD_ID);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)WRItems.BLUE_GEODE.get());
        }

        public void func_78018_a(NonNullList<ItemStack> items) {
            super.func_78018_a(items);
            if (WRConfig.debugMode) {
                items.add((Object)new ItemStack((IItemProvider)Items.field_151055_y).func_200302_a((ITextComponent)new StringTextComponent("Debug Stick")));
            }
        }
    }
}

