/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.util.ModUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.core.util.Integers;

public class WRConfig {
    public static boolean debugMode = false;
    public static boolean disableFrustumCheck = true;
    public static boolean deckTheHalls = true;
    public static boolean renderEntityOutlines = true;
    public static double fireBreathFlammability = 0.8;
    public static int homeRadius = 16;
    private static boolean respectMobGriefing;
    private static boolean dragonGriefing;
    public static Map<String, Integer> breedLimits;

    public static boolean canGrief(World world) {
        return respectMobGriefing ? world.func_82736_K().func_223586_b(GameRules.field_223599_b) : dragonGriefing;
    }

    public static void configLoad(ModConfig.ModConfigEvent evt) {
        try {
            ForgeConfigSpec spec = evt.getConfig().getSpec();
            if (spec == Common.SPEC) {
                Common.reload();
            } else if (spec == Client.SPEC) {
                Client.reload();
            } else if (spec == Server.SPEC) {
                Server.reload();
            }
        }
        catch (Throwable e) {
            Wyrmroost.LOG.error("Something went wrong updating Wyrmroost configs, using previous or default values! {}", (Object)e.toString());
        }
    }

    public static class Server {
        public static final Server INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public final ForgeConfigSpec.IntValue homeRadius;
        public final ForgeConfigSpec.DoubleValue breathFlammability;
        public final ForgeConfigSpec.BooleanValue respectMobGriefing;
        public final ForgeConfigSpec.BooleanValue dragonGriefing;
        private static final List<String> BREED_LIMIT_DEFAULTS;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> breedLimits;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Wyrmroost Dragon Options").push("dragons");
            this.homeRadius = builder.comment("How far dragons can travel from their home points").translation("config.wyrmroost.homeradius").defineInRange("home_radius", 16, 6, 1024);
            this.breathFlammability = builder.comment(new String[]{"Base Flammability for Dragon Fire Breath.", "A value of 0 will disable fire block damage completely."}).translation("config.wyrmroost.breathFlammability").defineInRange("breath_lammability", 0.8, 0.0, 1.0);
            this.breedLimits = builder.comment(new String[]{"Breed Limit for each dragon. This determines how many times a certain dragon can breed.", "Leaving this blank will disable the functionality."}).translation("config.wyrmroost.breedlimits").defineList("breed_limits", () -> BREED_LIMIT_DEFAULTS, o -> o instanceof String);
            builder.push("griefing");
            this.respectMobGriefing = builder.comment("If True, Dragons will respect the Minecraft MobGriefing Gamerule. Else, follow \"dragonGriefing\" option").translation("config.wyrmroost.respectMobGriefing").define("respect_mob_griefing", true);
            this.dragonGriefing = builder.comment("If true and not respecting MobGriefing rules, allow dragons to grief").translation("config.wyrmroost.dragonGriefing").define("dragon_griefing", true);
            builder.pop();
            builder.pop();
        }

        public static void reload() {
            homeRadius = (Integer)Server.INSTANCE.homeRadius.get();
            fireBreathFlammability = (Double)Server.INSTANCE.breathFlammability.get();
            respectMobGriefing = (Boolean)Server.INSTANCE.respectMobGriefing.get();
            dragonGriefing = (Boolean)Server.INSTANCE.dragonGriefing.get();
            breedLimits = ((List)Server.INSTANCE.breedLimits.get()).stream().collect(Collectors.toMap(s -> s.split(":")[0], s -> Integers.parseInt((String)s.split(":")[1])));
        }

        static {
            Pair pair = new ForgeConfigSpec.Builder().configure(Server::new);
            INSTANCE = (Server)pair.getLeft();
            SPEC = (ForgeConfigSpec)pair.getRight();
            BREED_LIMIT_DEFAULTS = ImmutableList.of((Object)"butterfly_leviathan:1", (Object)"royal_red:2");
        }
    }

    public static class Client {
        public static final Client INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public final ForgeConfigSpec.BooleanValue disableFrustumCheck;
        public final ForgeConfigSpec.BooleanValue renderEntityOutlines;
        public final ForgeConfigSpec.BooleanValue deckTheHalls;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Wyrmroost Client Options").push("General");
            this.disableFrustumCheck = builder.comment("Disables Frustum check when rendering (Dragons parts dont go poof when looking too far) - Only applies to bigger bois").translation("config.wyrmroost.disableFrustumCheck").define("disableFrustumCheck", true);
            this.renderEntityOutlines = builder.comment(new String[]{"Toggles Rendering of the Dragon Staff's Entity Color shaders", "Disable this if you're having issues with shaders"}).translation("config.wyrmroost.renderEntityOutlines").define("renderEntityOutlines", true);
            this.deckTheHalls = builder.comment("Only when the time comes...").translation("config.wyrmroost.deckTheHalls").define("deckTheHalls", true);
            builder.pop();
        }

        public static void reload() {
            disableFrustumCheck = (Boolean)Client.INSTANCE.disableFrustumCheck.get();
            deckTheHalls = (Boolean)Client.INSTANCE.deckTheHalls.get() != false && ModUtils.DECK_THE_HALLS;
            renderEntityOutlines = (Boolean)Client.INSTANCE.renderEntityOutlines.get();
        }

        static {
            Pair pair = new ForgeConfigSpec.Builder().configure(Client::new);
            INSTANCE = (Client)pair.getLeft();
            SPEC = (ForgeConfigSpec)pair.getRight();
        }
    }

    public static class Common {
        public static final Common INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public final ForgeConfigSpec.BooleanValue debugMode;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Wyrmroost General Options").push("general");
            this.debugMode = builder.comment("Do not enable this unless you are told to!").translation("config.wyrmroost.debug").define("debugMode", false);
            builder.pop();
        }

        public static void reload() {
            debugMode = (Boolean)Common.INSTANCE.debugMode.get();
        }

        static {
            Pair pair = new ForgeConfigSpec.Builder().configure(Common::new);
            INSTANCE = (Common)pair.getLeft();
            SPEC = (ForgeConfigSpec)pair.getRight();
        }
    }
}

