/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.NetherShipwreckConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class ShipwreckNetherStructure
extends AbstractBaseStructure<NetherShipwreckConfig> {
    private final ResourceLocation startPool;
    private final int sealevelOffset;

    public ShipwreckNetherStructure(ResourceLocation startPool, int sealevelOffset) {
        super(NetherShipwreckConfig.CODEC);
        this.startPool = startPool;
        this.sealevelOffset = sealevelOffset;
        RSStructures.RS_STRUCTURE_START_PIECES.add(startPool);
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NetherShipwreckConfig config) {
        BlockPos blockPos;
        if (!config.isFlying) {
            blockPos = new BlockPos(chunkX * 16, chunkGenerator.func_230356_f_() + 1, chunkZ * 16);
        } else {
            SharedSeedRandom random = new SharedSeedRandom(seed + (long)chunkX * ((long)chunkZ * 17L));
            int height = chunkGenerator.func_230356_f_() + random.nextInt(Math.max(chunkGenerator.func_230355_e_() - (chunkGenerator.func_230356_f_() + 30), 1));
            blockPos = new BlockPos(chunkX * 16, height, chunkZ * 16);
        }
        int checkRadius = 16;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int xOffset = -checkRadius; xOffset <= checkRadius; xOffset += 8) {
            for (int zOffset = -checkRadius; zOffset <= checkRadius; zOffset += 8) {
                IBlockReader blockView = chunkGenerator.func_230348_a_(xOffset + blockPos.func_177958_n(), zOffset + blockPos.func_177952_p());
                for (int yOffset = 0; yOffset <= 30; yOffset += 5) {
                    mutable.func_189533_g((Vector3i)blockPos).func_196234_d(xOffset, yOffset, zOffset);
                    if (blockView.func_180495_p((BlockPos)mutable).func_196958_f()) continue;
                    return false;
                }
            }
        }
        int structureCheckRadius = 3;
        for (int curChunkX = chunkX - structureCheckRadius; curChunkX <= chunkX + structureCheckRadius; ++curChunkX) {
            for (int curChunkZ = chunkZ - structureCheckRadius; curChunkZ <= chunkZ + structureCheckRadius; ++curChunkZ) {
                for (Structure<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)RSStructureTagMap.STRUCTURE_TAGS.SHIPWRECK_AVOID_NETHER_STRUCTURE)) {
                    StructureSeparationSettings structureConfig;
                    if (structureFeature == this || (structureConfig = chunkGenerator.func_235957_b_().func_236197_a_(structureFeature)) == null || structureConfig.func_236668_a_() <= 8) continue;
                    ChunkPos chunkPos2 = structureFeature.func_236392_a_(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                    if (curChunkX != chunkPos2.field_77276_a || curChunkZ != chunkPos2.field_77275_b) continue;
                    return false;
                }
            }
        }
        return super.func_230363_a_(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, (IFeatureConfig)config);
    }

    public Structure.IStartFactory<NetherShipwreckConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NetherShipwreckConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class Start
    extends MarginedStructureStart<NetherShipwreckConfig> {
        private final long seed;

        public Start(Structure<NetherShipwreckConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox box, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, box, referenceIn, seedIn);
            this.seed = seedIn;
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NetherShipwreckConfig config) {
            int placementHeight = chunkGenerator.func_230356_f_();
            if (!config.isFlying) {
                placementHeight += ShipwreckNetherStructure.this.sealevelOffset;
            } else {
                SharedSeedRandom random = new SharedSeedRandom(this.seed + (long)chunkX * ((long)chunkZ * 17L));
                placementHeight += random.nextInt(Math.max(chunkGenerator.func_230355_e_() - (placementHeight + 30), 1));
            }
            BlockPos blockpos = new BlockPos(chunkX * 16, placementHeight, chunkZ * 16);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(ShipwreckNetherStructure.this.startPool), 6), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)structureManager, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
            GeneralUtils.centerAllPieces(blockpos, this.field_75075_a);
            this.func_202500_a();
        }
    }
}

