/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.common.util.Lazy;

public class LandBasedEndStructure
extends GenericJigsawStructure {
    public LandBasedEndStructure(ResourceLocation poolID, Lazy<Integer> structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, int minHeightLimit, int fixedYSpawn, boolean useHeightmap, boolean cannotSpawnInWater) {
        super(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, allowTerrainHeightRange, terrainHeightRadius, minHeightLimit, fixedYSpawn, useHeightmap, cannotSpawnInWater);
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig defaultFeatureConfig) {
        return LandBasedEndStructure.getTerrainHeight(new ChunkPos(chunkX, chunkZ), chunkGenerator) >= Math.min(chunkGenerator.func_230355_e_(), 50);
    }

    private static int getTerrainHeight(ChunkPos chunkPos1, ChunkGenerator chunkGenerator) {
        int xPos = chunkPos1.field_77276_a * 16;
        int zPos = chunkPos1.field_77275_b * 16;
        int height = chunkGenerator.func_222531_c(xPos, zPos, Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos pos = new BlockPos(xPos, chunkGenerator.func_230355_e_(), zPos);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.func_189533_g((Vector3i)pos).func_189534_c(direction, 16);
            height = Math.min(height, chunkGenerator.func_222531_c(mutable.func_177958_n(), mutable.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG));
        }
        return height;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public static class Builder<T extends GenericJigsawStructure.Builder<T>>
    extends GenericJigsawStructure.Builder<T> {
        public Builder(ResourceLocation startPool) {
            super(startPool);
        }

        @Override
        public LandBasedEndStructure build() {
            return new LandBasedEndStructure(this.startPool, (Lazy<Integer>)this.structureSize, this.centerOffset, this.biomeRange, this.structureBlacklistRange, this.avoidStructuresSet, this.allowTerrainHeightRange, this.terrainHeightRadius, this.minHeightLimit, this.fixedYSpawn, this.useHeightmap, this.cannotSpawnInWater);
        }
    }

    public class Start
    extends GenericJigsawStructure.MainStart {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox box, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, box, referenceIn, seedIn);
        }

        @Override
        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig defaultFeatureConfig) {
            super.generatePieces(dynamicRegistryManager, chunkGenerator, structureManager, chunkX, chunkZ, biome, defaultFeatureConfig);
            MutableBoundingBox box = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b();
            BlockPos centerPos = new BlockPos(box.func_215126_f());
            int radius = (int)Math.sqrt(box.func_175896_b().func_177958_n() * box.func_175896_b().func_177958_n() + box.func_175896_b().func_177952_p() * box.func_175896_b().func_177952_p()) / 2;
            ArrayList<Integer> landHeights = new ArrayList<Integer>();
            for (int xOffset = -radius; xOffset <= radius; xOffset += radius / 2) {
                for (int zOffset = -radius; zOffset <= radius; zOffset += radius / 2) {
                    int landHeight = chunkGenerator.func_222531_c(centerPos.func_177958_n() + xOffset, centerPos.func_177952_p() + zOffset, Heightmap.Type.WORLD_SURFACE_WG);
                    landHeights.add(landHeight);
                }
            }
            int avgHeight = (int)Math.max(landHeights.stream().mapToInt(Integer::intValue).average().orElse(0.0), 50.0);
            int parentHeight = ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78895_b;
            int offsetAmount = avgHeight - parentHeight + LandBasedEndStructure.this.centerOffset;
            this.field_75075_a.forEach(child -> child.func_181138_a(0, offsetAmount, 0));
            GeneralUtils.centerAllPieces(centerPos, this.field_75075_a);
            this.func_202500_a();
        }
    }
}

