/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class RandomReplaceWithPropertiesProcessor
extends StructureProcessor {
    public static final Codec<RandomReplaceWithPropertiesProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212618_g.fieldOf("input_block").forGetter(config -> config.inputBlock), (App)Registry.field_212618_g.optionalFieldOf("output_block").forGetter(config -> config.outputBlock), (App)Registry.field_212618_g.listOf().optionalFieldOf("output_blocks", (Object)ImmutableList.of()).forGetter(config -> config.outputBlocks), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(config -> Float.valueOf(config.probability))).apply((Applicative)instance, instance.stable(RandomReplaceWithPropertiesProcessor::new)));
    private final Block inputBlock;
    private final Optional<Block> outputBlock;
    private final List<Block> outputBlocks;
    private final float probability;

    public RandomReplaceWithPropertiesProcessor(Block inputBlock, Optional<Block> outputBlock, List<Block> outputBlocks, float probability) {
        this.inputBlock = inputBlock;
        this.outputBlock = outputBlock;
        this.outputBlocks = outputBlocks;
        this.probability = probability;
    }

    public Template.BlockInfo func_230386_a_(IWorldReader worldReader, BlockPos pos, BlockPos pos2, Template.BlockInfo infoIn1, Template.BlockInfo infoIn2, PlacementSettings settings) {
        if (infoIn2.field_186243_b.func_177230_c().func_235332_a_(this.inputBlock)) {
            BlockPos worldPos = infoIn2.field_186242_a;
            SharedSeedRandom random = new SharedSeedRandom();
            random.setSeed(worldPos.func_218275_a() * (long)worldPos.func_177956_o());
            if (random.nextFloat() < this.probability) {
                if (this.outputBlock.isPresent()) {
                    BlockState newBlockState = this.outputBlock.get().func_176223_P();
                    for (Property property : infoIn2.field_186243_b.func_235904_r_()) {
                        if (!newBlockState.func_235901_b_(property)) continue;
                        newBlockState = this.getStateWithProperty(newBlockState, infoIn2.field_186243_b, property);
                    }
                    return new Template.BlockInfo(infoIn2.field_186242_a, newBlockState, infoIn2.field_186244_c);
                }
                if (!this.outputBlocks.isEmpty()) {
                    BlockState newBlockState = this.outputBlocks.get(random.nextInt(this.outputBlocks.size())).func_176223_P();
                    for (Property property : infoIn2.field_186243_b.func_235904_r_()) {
                        if (!newBlockState.func_235901_b_(property)) continue;
                        newBlockState = this.getStateWithProperty(newBlockState, infoIn2.field_186243_b, property);
                    }
                    return new Template.BlockInfo(infoIn2.field_186242_a, newBlockState, infoIn2.field_186244_c);
                }
                RepurposedStructures.LOGGER.warn("Repurposed Structures: repurposed_structures:random_replace_with_properties_processor in a processor file has no replacement block of any kind.");
            }
        }
        return infoIn2;
    }

    private <T extends Comparable<T>> BlockState getStateWithProperty(BlockState state, BlockState stateToCopy, Property<T> property) {
        return (BlockState)state.func_206870_a(property, stateToCopy.func_177229_b(property));
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return RSProcessors.RANDOM_REPLACE_WITH_PROPERTIES_PROCESSOR;
    }
}

