/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.Locale;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import org.apache.commons.lang3.math.NumberUtils;

public class DataBlockProcessor
extends StructureProcessor {
    public static final Codec<DataBlockProcessor> CODEC = Codec.unit(DataBlockProcessor::new);

    private DataBlockProcessor() {
    }

    public Template.BlockInfo func_230386_a_(IWorldReader worldView, BlockPos pos, BlockPos blockPos, Template.BlockInfo structureBlockInfoLocal, Template.BlockInfo structureBlockInfoWorld, PlacementSettings structurePlacementData) {
        BlockState blockState = structureBlockInfoWorld.field_186243_b;
        if (blockState.func_203425_a(Blocks.field_185779_df)) {
            String metadata = structureBlockInfoWorld.field_186244_c.func_74779_i("metadata");
            BlockPos worldPos = structureBlockInfoWorld.field_186242_a;
            try {
                if (metadata.contains(DATA_PROCESSOR_MODE.PILLARS.symbol)) {
                    String thirdArgument;
                    String[] splitString = metadata.split(DATA_PROCESSOR_MODE.PILLARS.symbol);
                    Direction direction = Direction.valueOf((String)splitString[0].toUpperCase(Locale.ROOT));
                    BlockStateParser blockArgumentParser = new BlockStateParser(new StringReader(splitString[1]), false);
                    blockArgumentParser.func_197243_a(true);
                    BlockState replacementState = blockArgumentParser.func_197249_b();
                    BlockState currentBlock = worldView.func_180495_p(worldPos);
                    BlockPos.Mutable currentPos = new BlockPos.Mutable().func_189533_g((Vector3i)worldPos);
                    int depth = 256;
                    if (splitString.length > 2 && NumberUtils.isParsable((String)(thirdArgument = splitString[2]))) {
                        depth = Integer.parseInt(thirdArgument) + 1;
                    }
                    while (!currentBlock.func_200132_m() && currentPos.func_177956_o() <= worldView.func_230315_m_().func_241513_m_() && currentPos.func_177956_o() >= 0 && currentPos.func_218141_a((Vector3i)worldPos, (double)depth)) {
                        Template.BlockInfo newPillarState1 = new Template.BlockInfo(structureBlockInfoLocal.field_186242_a, replacementState, null);
                        Template.BlockInfo newPillarState2 = new Template.BlockInfo(currentPos.func_185334_h(), replacementState, null);
                        for (StructureProcessor processor : structurePlacementData.func_215221_j()) {
                            if (newPillarState2 == null) break;
                            newPillarState2 = processor.func_230386_a_(worldView, pos, blockPos, newPillarState1, newPillarState2, structurePlacementData);
                        }
                        if (newPillarState2 != null) {
                            worldView.func_217349_x((BlockPos)currentPos).func_177436_a((BlockPos)currentPos, newPillarState2.field_186243_b, false);
                        }
                        currentPos.func_189536_c(direction);
                        currentBlock = worldView.func_180495_p((BlockPos)currentPos);
                    }
                    return replacementState == null || replacementState.func_203425_a(Blocks.field_189881_dj) ? null : new Template.BlockInfo(worldPos, replacementState, null);
                }
            }
            catch (CommandSyntaxException var11) {
                throw new RuntimeException(var11);
            }
        }
        return structureBlockInfoWorld;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return RSProcessors.DATA_BLOCK_PROCESSOR;
    }

    private static enum DATA_PROCESSOR_MODE {
        PILLARS("-");

        private final String symbol;

        private DATA_PROCESSOR_MODE(String symbol) {
            this.symbol = symbol;
        }
    }
}

