/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;

public class BiomeSurfaceProcessor
extends StructureProcessor {
    public static final Codec<BiomeSurfaceProcessor> CODEC = Codec.unit(BiomeSurfaceProcessor::new);
    private static final Map<IWorldReader, Map<Long, Biome>> MINI_BIOMEPOS_CACHE = new WeakHashMap<IWorldReader, Map<Long, Biome>>();

    private BiomeSurfaceProcessor() {
    }

    public Template.BlockInfo func_230386_a_(IWorldReader worldView, BlockPos pos, BlockPos blockPos, Template.BlockInfo structureBlockInfoLocal, Template.BlockInfo structureBlockInfoWorld, PlacementSettings structurePlacementData) {
        BlockState structureBlock = structureBlockInfoWorld.field_186243_b;
        if (structureBlock.func_203425_a(Blocks.field_196658_i)) {
            BlockPos structurePos = structureBlockInfoWorld.field_186242_a;
            Biome biome = this.getCachedBiome(worldView, structurePos);
            BlockState topSurfaceBlock = ((ConfiguredSurfaceBuilder)biome.func_242440_e().func_242500_d().get()).field_215454_b.func_204108_a();
            return new Template.BlockInfo(structurePos, topSurfaceBlock, structureBlockInfoWorld.field_186244_c);
        }
        if (structureBlock.func_203425_a(Blocks.field_150346_d)) {
            BlockPos structurePos = structureBlockInfoWorld.field_186242_a;
            Biome biome = this.getCachedBiome(worldView, structurePos);
            BlockState underSurfaceBlock = ((ConfiguredSurfaceBuilder)biome.func_242440_e().func_242500_d().get()).field_215454_b.func_204109_b();
            return new Template.BlockInfo(structurePos, underSurfaceBlock, structureBlockInfoWorld.field_186244_c);
        }
        return structureBlockInfoWorld;
    }

    private Biome getCachedBiome(IWorldReader worldView, BlockPos structurePos) {
        Map worldSpecificBiomes = MINI_BIOMEPOS_CACHE.computeIfAbsent(worldView, keyPos -> new HashMap());
        BlockPos biomePos = new BlockPos(structurePos.func_177958_n() >> 2, 0, structurePos.func_177952_p() >> 2);
        Biome biome = worldSpecificBiomes.computeIfAbsent(biomePos.func_218275_a(), keyPos -> worldView.func_226691_t_(structurePos));
        if (worldSpecificBiomes.size() > 20) {
            worldSpecificBiomes.clear();
        }
        return biome;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return RSProcessors.BIOME_SURFACE_PROCESSOR;
    }
}

