/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetChanceConfig;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class StructureBreakage
extends Feature<StructureTargetChanceConfig> {
    private static final Predicate<BlockState> FORTRESS_BLOCKS = blockState -> {
        if (blockState == null) {
            return false;
        }
        return blockState.func_185904_a() == Material.field_151576_e || blockState.func_185904_a() == Material.field_151578_c || blockState.func_203425_a(Blocks.field_196694_dh) || blockState.func_203425_a(Blocks.field_196692_dg) || blockState.func_203425_a(Blocks.field_196688_de) || blockState.func_203425_a(Blocks.field_196690_df) || blockState.func_203425_a(Blocks.field_150411_aY);
    };

    public StructureBreakage(Codec<StructureTargetChanceConfig> config) {
        super(config);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, StructureTargetChanceConfig config) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (random.nextFloat() < config.chance) {
            mutable.func_189533_g((Vector3i)position).func_196234_d(random.nextInt(7) - 3, 0, random.nextInt(7) - 3);
            boolean foundSurface = this.findSurface(world, mutable, Direction.UP);
            if (!foundSurface) {
                mutable.func_189534_c(Direction.DOWN, 5);
                foundSurface = this.findSurface(world, mutable, Direction.DOWN);
            }
            if (!foundSurface) {
                return false;
            }
            mutable.func_189534_c(Direction.UP, 2);
            float f = random.nextFloat() * (float)Math.PI;
            float g = 3.0f;
            int i = 2;
            double d = (float)mutable.func_177958_n() + MathHelper.func_76126_a((float)f) * g;
            double e = (float)mutable.func_177958_n() - MathHelper.func_76126_a((float)f) * g;
            double h = (float)mutable.func_177952_p() + MathHelper.func_76134_b((float)f) * g;
            double j = (float)mutable.func_177952_p() - MathHelper.func_76134_b((float)f) * g;
            double l = mutable.func_177956_o() + random.nextInt(3) - 2;
            double m = mutable.func_177956_o() + random.nextInt(3) - 2;
            int n = mutable.func_177958_n() - MathHelper.func_76123_f((float)g) - i;
            int o = mutable.func_177956_o() - 4;
            int p = mutable.func_177952_p() - MathHelper.func_76123_f((float)g) - i;
            int q = 2 * (MathHelper.func_76123_f((float)g) + i);
            int r = 8;
            for (int s = n; s <= n + q; ++s) {
                int t = p;
                if (t > p + q) continue;
                return this.generateVeinPart(world, random, d, e, h, j, l, m, n, o, p, q, r, chunkGenerator);
            }
        }
        return true;
    }

    private boolean findSurface(ISeedReader world, BlockPos.Mutable mutable, Direction direction) {
        for (int i = 0; i <= 5; ++i) {
            if (FORTRESS_BLOCKS.test(world.func_180495_p((BlockPos)mutable))) {
                return true;
            }
            mutable.func_189536_c(direction);
        }
        return false;
    }

    protected boolean generateVeinPart(ISeedReader world, Random random, double startX, double endX, double startZ, double endZ, double startY, double endY, int x, int y, int z, int size, int i, ChunkGenerator chunkGenerator) {
        double r;
        double q;
        double p;
        double o;
        int m;
        int j = 0;
        BitSet bitSet = new BitSet(size * i * size);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        double[] ds = new double[96];
        for (m = 0; m < 24; ++m) {
            float f = (float)m / 24.0f;
            o = MathHelper.func_219803_d((double)f, (double)startX, (double)endX);
            p = MathHelper.func_219803_d((double)f, (double)startY, (double)endY);
            q = MathHelper.func_219803_d((double)f, (double)startZ, (double)endZ);
            r = random.nextDouble() * 24.0 / 16.0;
            double l = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * f)) + 1.0f) * r + 1.0) / 2.0;
            ds[m * 4 + 0] = o;
            ds[m * 4 + 1] = p;
            ds[m * 4 + 2] = q;
            ds[m * 4 + 3] = l;
        }
        for (m = 0; m < 23; ++m) {
            if (!(ds[m * 4 + 3] > 0.0)) continue;
            for (int n = m + 1; n < 24; ++n) {
                if (!(ds[n * 4 + 3] > 0.0) || !((r = ds[m * 4 + 3] - ds[n * 4 + 3]) * r > (o = ds[m * 4 + 0] - ds[n * 4 + 0]) * o + (p = ds[m * 4 + 1] - ds[n * 4 + 1]) * p + (q = ds[m * 4 + 2] - ds[n * 4 + 2]) * q)) continue;
                if (r > 0.0) {
                    ds[n * 4 + 3] = -1.0;
                    continue;
                }
                ds[m * 4 + 3] = -1.0;
            }
        }
        for (m = 0; m < 24; ++m) {
            double t = ds[m * 4 + 3];
            if (!(t >= 0.0)) continue;
            double u = ds[m * 4 + 0];
            double v = ds[m * 4 + 1];
            double w = ds[m * 4 + 2];
            int aa = Math.max(MathHelper.func_76128_c((double)(u - t)), x);
            int ab = Math.max(MathHelper.func_76128_c((double)(v - t)), y);
            int ac = Math.max(MathHelper.func_76128_c((double)(w - t)), z);
            int ad = Math.max(MathHelper.func_76128_c((double)(u + t)), aa);
            int ae = Math.max(MathHelper.func_76128_c((double)(v + t)), ab);
            int af = Math.max(MathHelper.func_76128_c((double)(w + t)), ac);
            for (int ag = aa; ag <= ad; ++ag) {
                double ah = ((double)ag + 0.5 - u) / t;
                if (!(ah * ah < 1.0)) continue;
                for (int ai = ab; ai <= ae; ++ai) {
                    double aj = ((double)ai + 0.5 - v) / t;
                    if (!(ah * ah + aj * aj < 1.0)) continue;
                    for (int ak = ac; ak <= af; ++ak) {
                        boolean isBelowSealevel;
                        int am;
                        double al = ((double)ak + 0.5 - w) / t;
                        if (!(ah * ah + aj * aj + al * al < 1.0) || bitSet.get(am = ag - x + (ai - y) * size + (ak - z) * size * i)) continue;
                        bitSet.set(am);
                        mutable.func_181079_c(ag, ai, ak);
                        BlockState state = world.func_180495_p((BlockPos)mutable);
                        if (!FORTRESS_BLOCKS.test(state)) continue;
                        ChunkPos currentChunkPos = new ChunkPos((BlockPos)mutable);
                        IChunk currentChunk = world.func_212866_a_(currentChunkPos.field_77276_a, currentChunkPos.field_77275_b);
                        boolean bl = isBelowSealevel = mutable.func_177956_o() < chunkGenerator.func_230356_f_();
                        if (isBelowSealevel && this.isBorderingAir(world, mutable)) continue;
                        currentChunk.func_177436_a((BlockPos)mutable, isBelowSealevel ? Blocks.field_150355_j.func_176223_P() : Blocks.field_201941_jj.func_176223_P(), false);
                        ++j;
                        state = currentChunk.func_180495_p((BlockPos)mutable.func_189536_c(Direction.DOWN));
                        while (state.func_185904_a() == Material.field_151582_l) {
                            currentChunk.func_177436_a((BlockPos)mutable, isBelowSealevel ? Blocks.field_150355_j.func_176223_P() : Blocks.field_201941_jj.func_176223_P(), false);
                            state = currentChunk.func_180495_p((BlockPos)mutable.func_189536_c(Direction.DOWN));
                        }
                        state = currentChunk.func_180495_p((BlockPos)mutable.func_189536_c(Direction.UP));
                        while (state.func_185904_a() == Material.field_151582_l) {
                            isBelowSealevel = mutable.func_177956_o() < chunkGenerator.func_230356_f_();
                            currentChunk.func_177436_a((BlockPos)mutable, isBelowSealevel ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P(), false);
                            state = currentChunk.func_180495_p((BlockPos)mutable.func_189536_c(Direction.UP));
                        }
                        BlockPos.Mutable mutableVineCheck = new BlockPos.Mutable();
                        for (Direction direction : Direction.values()) {
                            BlockState neighboringBlock;
                            if (direction == Direction.UP) continue;
                            mutableVineCheck.func_189533_g((Vector3i)mutable).func_189536_c(direction);
                            if (currentChunkPos.field_77276_a != mutableVineCheck.func_177958_n() >> 4 || currentChunkPos.field_77275_b != mutableVineCheck.func_177952_p() >> 4) {
                                currentChunk = world.func_217349_x((BlockPos)mutableVineCheck);
                                currentChunkPos = new ChunkPos((BlockPos)mutableVineCheck);
                            }
                            if (!(neighboringBlock = currentChunk.func_180495_p((BlockPos)mutableVineCheck)).func_203425_a(Blocks.field_150395_bd) || !((Boolean)neighboringBlock.func_177229_b((Property)VineBlock.func_176267_a((Direction)direction.func_176734_d()))).booleanValue()) continue;
                            while (neighboringBlock.func_185904_a() == Material.field_151582_l) {
                                currentChunk.func_177436_a((BlockPos)mutableVineCheck, isBelowSealevel ? Blocks.field_150355_j.func_176223_P() : Blocks.field_201941_jj.func_176223_P(), false);
                                neighboringBlock = currentChunk.func_180495_p((BlockPos)mutableVineCheck.func_189536_c(Direction.DOWN));
                            }
                        }
                    }
                }
            }
        }
        return j > 0;
    }

    private boolean isBorderingAir(ISeedReader world, BlockPos.Mutable mutable) {
        BlockPos.Mutable mutableWaterCheck = new BlockPos.Mutable();
        ChunkPos currentChunkPos2 = new ChunkPos((BlockPos)mutable);
        IChunk currentChunk2 = world.func_212866_a_(currentChunkPos2.field_77276_a, currentChunkPos2.field_77275_b);
        for (Direction direction : Direction.values()) {
            if (direction == Direction.UP) continue;
            mutableWaterCheck.func_189533_g((Vector3i)mutable).func_189536_c(direction);
            if (currentChunkPos2.field_77276_a != mutableWaterCheck.func_177958_n() >> 4 || currentChunkPos2.field_77275_b != mutableWaterCheck.func_177952_p() >> 4) {
                currentChunk2 = world.func_217349_x((BlockPos)mutableWaterCheck);
                currentChunkPos2 = new ChunkPos((BlockPos)mutableWaterCheck);
            }
            if (!currentChunk2.func_180495_p((BlockPos)mutableWaterCheck).func_196958_f()) continue;
            return true;
        }
        return false;
    }
}

